/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.io.IOException;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.item.Atm;
import org.basex.query.item.Item;
import org.basex.query.item.NodeType;
import org.basex.query.item.Str;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public abstract class FuncCall
extends Arr {
    public Function def;

    protected FuncCall(InputInfo ii, Function fd, Expr ... args) {
        super(ii, args);
        this.def = fd;
        this.type = this.def.ret;
    }

    @Override
    public final Expr comp(QueryContext ctx) throws QueryException {
        super.comp(ctx);
        if (this.uses(Expr.Use.CTX) || !this.values()) {
            return this.optPre(this.cmp(ctx), ctx);
        }
        return this.optPre(this.def.ret.zeroOrOne() ? this.item(ctx, this.input) : this.value(ctx), ctx);
    }

    public Expr cmp(QueryContext ctx) throws QueryException {
        return this;
    }

    protected final Item atom(Item it) throws QueryException {
        return it.node() ? (it.type == NodeType.PI || it.type == NodeType.COM ? Str.get(it.atom(this.input)) : new Atm(it.atom(this.input))) : it;
    }

    @Override
    public final boolean isFun(Function f) {
        return this.def == f;
    }

    @Override
    public final String desc() {
        return this.def.toString();
    }

    @Override
    public final void plan(Serializer ser) throws IOException {
        ser.openElement(this, (byte[][])new byte[][]{QueryText.NAM, Token.token(this.def.desc)});
        Expr[] exprArray = this.expr;
        int n = this.expr.length;
        int n2 = 0;
        while (n2 < n) {
            Expr arg = exprArray[n2];
            arg.plan(ser);
            ++n2;
        }
        ser.closeElement();
    }

    @Override
    public final String toString() {
        String desc = this.def.toString();
        return new TokenBuilder().add(desc.substring(0, desc.indexOf(40) + 1)).addSep(this.expr, ", ").add(")").toString();
    }
}

