/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

public final class Datas {
    private final List<PData> list = Collections.synchronizedList(new ArrayList());

    synchronized Data pin(String db) {
        for (PData d : this.list) {
            if (!d.data.meta.name.equals(db)) continue;
            ++d.pins;
            return d.data;
        }
        return null;
    }

    synchronized boolean unpin(Data data) {
        for (PData d : this.list) {
            boolean close;
            if (d.data != data) continue;
            boolean bl = close = --d.pins == 0;
            if (close) {
                this.list.remove(d);
            }
            return close;
        }
        return false;
    }

    synchronized boolean pinned(String db) {
        for (PData d : this.list) {
            if (!d.data.meta.name.equals(db)) continue;
            return true;
        }
        return false;
    }

    synchronized void add(Data d) {
        this.list.add(new PData(d));
    }

    public synchronized int size() {
        return this.list.size();
    }

    public String info() {
        TokenBuilder tb = new TokenBuilder();
        tb.addExt(Text.SRVDATABASES, this.list.size());
        tb.add(this.list.size() != 0 ? ":" : ".");
        for (PData d : this.list) {
            tb.add(String.valueOf(Text.NL) + "- " + d.data.meta.name + " (" + d.pins + "x)");
        }
        return tb.toString();
    }

    synchronized void close() {
        try {
            for (PData d : this.list) {
                d.data.close();
            }
        }
        catch (IOException ex) {
            Util.debug(ex);
        }
        this.list.clear();
    }

    public synchronized int pins(String db) {
        for (PData d : this.list) {
            if (!d.data.meta.name.equals(db)) continue;
            return d.pins;
        }
        return 0;
    }

    private static final class PData {
        int pins = 1;
        Data data;

        PData(Data d) {
            this.data = d;
        }
    }
}

