/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.pluginloader.ui;

import java.util.HashSet;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import nl.mpi.kinnate.plugin.BasePlugin;
import nl.mpi.pluginloader.PluginManager;
import nl.mpi.pluginloader.PluginService;
import nl.mpi.pluginloader.ui.PluginMenuAction;

public class PluginMenu
extends JMenu {
    final PluginService pluginService;

    public PluginMenu(PluginService pluginService, PluginManager pluginManager) {
        super("Plugins");
        this.pluginService = pluginService;
        try {
            Iterator<BasePlugin> pluginIterator = pluginService.getPlugins();
            boolean hasPlugins = false;
            while (pluginIterator.hasNext()) {
                hasPlugins = true;
                BasePlugin kinOathPlugin = pluginIterator.next();
                System.out.println("Plugin: " + kinOathPlugin.getName());
                JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(new PluginMenuAction(pluginManager, kinOathPlugin));
                menuItem.setSelected(pluginManager.isActivated(kinOathPlugin));
                this.add(menuItem);
            }
            if (!hasPlugins) {
                this.add(new JLabel("<no plugins found>"));
            }
        }
        catch (ServiceConfigurationError serviceError) {
            this.add(new JLabel("<failed to load any plugins>"));
        }
    }

    public static void main(String[] args) {
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        JMenuBar jMenuBar = new JMenuBar();
        final JTextArea jTextArea = new JTextArea();
        PluginManager pluginManager = new PluginManager(){
            HashSet<BasePlugin> hashSet = new HashSet();

            public boolean isActivated(BasePlugin kinOathPlugin) {
                return this.hashSet.contains(kinOathPlugin);
            }

            public void activatePlugin(BasePlugin kinOathPlugin) {
                this.hashSet.add(kinOathPlugin);
                jTextArea.setText("activate: \n" + kinOathPlugin.getName() + "\n" + kinOathPlugin.getMajorVersionNumber() + "." + kinOathPlugin.getMinorVersionNumber() + "." + kinOathPlugin.getBuildVersionNumber() + "\n" + kinOathPlugin.getDescription());
            }

            public void deactivatePlugin(BasePlugin kinOathPlugin) {
                this.hashSet.remove(kinOathPlugin);
                jTextArea.setText("deactivate: \n" + kinOathPlugin.getName() + "\n" + kinOathPlugin.getMajorVersionNumber() + "." + kinOathPlugin.getMinorVersionNumber() + "." + kinOathPlugin.getBuildVersionNumber() + "\n" + kinOathPlugin.getDescription());
            }
        };
        jMenuBar.add(new PluginMenu(PluginService.getInstance(), pluginManager));
        jFrame.setJMenuBar(jMenuBar);
        jFrame.setContentPane(new JScrollPane(jTextArea));
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

