/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.kindata;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlElement;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kindata.EntityRelation;
import nl.mpi.kinnate.svg.GraphPanelSize;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphSorter {
    static int sortCounter = 0;
    @XmlElement(name="Entity", namespace="http://mpi.nl/tla/kin")
    private EntityData[] graphDataNodeArray = new EntityData[0];
    private HashMap<UniqueIdentifier, SortingEntity> knownSortingEntities;
    private HashMap<UniqueIdentifier, Point> preferredLocations = new HashMap();
    private int xPadding = 100;
    private int yPadding = 100;

    public void setPadding(GraphPanelSize graphPanelSize) {
        this.xPadding = graphPanelSize.getHorizontalSpacing();
        this.yPadding = graphPanelSize.getVerticalSpacing();
    }

    public void setPreferredEntityLocation(UniqueIdentifier[] egoIdentifierArray, Point defaultLocation) {
        if (this.preferredLocations == null) {
            this.preferredLocations = new HashMap();
        }
        for (UniqueIdentifier uniqueIdentifier : egoIdentifierArray) {
            this.preferredLocations.put(uniqueIdentifier, defaultLocation);
        }
    }

    private Point getDefaultPosition(HashMap<UniqueIdentifier, Point> entityPositions, UniqueIdentifier uniqueIdentifier) {
        Point preferredPoint;
        if (this.preferredLocations != null && (preferredPoint = this.preferredLocations.get(uniqueIdentifier)) != null) {
            return preferredPoint;
        }
        Rectangle rectangle = this.getGraphSize(entityPositions);
        Point defaultPosition = new Point(rectangle.x + rectangle.width + this.xPadding, rectangle.y + rectangle.height + this.yPadding);
        return new Point(defaultPosition.x, 0);
    }

    public void setEntitys(EntityData[] graphDataNodeArrayLocal) {
        this.graphDataNodeArray = graphDataNodeArrayLocal;
        this.knownSortingEntities = new HashMap();
        for (EntityData currentNode : graphDataNodeArrayLocal) {
            if (!currentNode.isVisible) continue;
            this.knownSortingEntities.put(currentNode.getUniqueIdentifier(), new SortingEntity(currentNode));
        }
        for (SortingEntity currentSorter : this.knownSortingEntities.values()) {
            currentSorter.calculateRelations(this.knownSortingEntities);
        }
    }

    public Rectangle getGraphSize(HashMap<UniqueIdentifier, Point> entityPositions) {
        int[] minPostion = null;
        int[] maxPostion = null;
        for (Point currentPosition : entityPositions.values()) {
            if (minPostion == null) {
                minPostion = new int[]{Math.round(currentPosition.x), Math.round(currentPosition.y)};
                maxPostion = new int[]{Math.round(currentPosition.x), Math.round(currentPosition.y)};
                continue;
            }
            minPostion[0] = Math.min((int)minPostion[0], Math.round(currentPosition.x));
            minPostion[1] = Math.min(minPostion[1], Math.round(currentPosition.y));
            maxPostion[0] = Math.max(maxPostion[0], Math.round(currentPosition.x));
            maxPostion[1] = Math.max(maxPostion[1], Math.round(currentPosition.y));
        }
        if (minPostion == null) {
            minPostion = new int[]{0, 0};
            maxPostion = new int[]{0, 0};
        }
        void xOffset = minPostion[0] - this.xPadding;
        void yOffset = minPostion[1] - this.yPadding;
        void graphWidth = maxPostion[0] + this.xPadding - xOffset;
        int graphHeight = maxPostion[1] + this.yPadding - yOffset;
        return new Rectangle((int)xOffset, (int)yOffset, (int)graphWidth, graphHeight);
    }

    public void placeAllNodes(HashMap<UniqueIdentifier, Point> entityPositions) {
        ArrayList<UniqueIdentifier> removeNodeIds = new ArrayList<UniqueIdentifier>(entityPositions.keySet());
        for (EntityData currentNode : this.graphDataNodeArray) {
            removeNodeIds.remove(currentNode.getUniqueIdentifier());
            if (currentNode.isVisible) continue;
            entityPositions.remove(currentNode.getUniqueIdentifier());
        }
        for (UniqueIdentifier currentRemoveId : removeNodeIds) {
            if (currentRemoveId.isGraphicsIdentifier()) continue;
            entityPositions.remove(currentRemoveId);
        }
        if (this.knownSortingEntities != null) {
            for (SortingEntity currentSorter : this.knownSortingEntities.values()) {
                if (!currentSorter.mustBeBelow.isEmpty()) continue;
                boolean hasNoAncestors = true;
                currentSorter.addLabel("HasNoAncestors");
                for (SortingEntity spouseOrSibling : currentSorter.couldBeNextTo) {
                    if (spouseOrSibling.mustBeBelow.isEmpty()) continue;
                    hasNoAncestors = false;
                    currentSorter.addLabel("SpouseHasAncestors");
                    break;
                }
                if (!hasNoAncestors) continue;
                currentSorter.getRelatedPositions(entityPositions);
            }
            for (SortingEntity currentSorter : this.knownSortingEntities.values()) {
                currentSorter.getPosition(entityPositions);
                currentSorter.getRelatedPositions(entityPositions);
            }
        }
        for (UniqueIdentifier uniqueIdentifier : entityPositions.keySet()) {
            this.preferredLocations.put(uniqueIdentifier, entityPositions.get(uniqueIdentifier));
        }
    }

    public EntityData[] getDataNodes() {
        return this.graphDataNodeArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SortingEntity
    implements Comparable<SortingEntity> {
        UniqueIdentifier selfEntityId;
        ArrayList<SortingEntity> mustBeBelow;
        ArrayList<SortingEntity> mustBeAbove;
        ArrayList<SortingEntity> mustBeNextTo;
        ArrayList<SortingEntity> couldBeNextTo;
        EntityRelation[] allRelateNodes;
        Point calculatedPosition = null;
        EntityData entityData;

        public SortingEntity(EntityData entityData) {
            this.entityData = entityData;
            this.entityData.clearTempLabels();
            sortCounter = 0;
            this.selfEntityId = entityData.getUniqueIdentifier();
            this.allRelateNodes = entityData.getAllRelations();
            this.mustBeBelow = new ArrayList();
            this.mustBeAbove = new ArrayList();
            this.mustBeNextTo = new ArrayList();
            this.couldBeNextTo = new ArrayList();
        }

        @Override
        public int compareTo(SortingEntity o) {
            return this.entityData.getDateOfBirth().compareTo(o.entityData.getDateOfBirth());
        }

        private void addLabel(String labelString) {
        }

        public void calculateRelations(HashMap<UniqueIdentifier, SortingEntity> knownSortingEntities) {
            block6: for (EntityRelation entityRelation : this.allRelateNodes) {
                if (entityRelation.getAlterNode() == null || !entityRelation.getAlterNode().isVisible) continue;
                switch (entityRelation.getRelationType()) {
                    case ancestor: {
                        this.mustBeBelow.add(knownSortingEntities.get(entityRelation.alterUniqueIdentifier));
                        continue block6;
                    }
                    case descendant: {
                        this.mustBeAbove.add(knownSortingEntities.get(entityRelation.alterUniqueIdentifier));
                        continue block6;
                    }
                    case union: {
                        this.mustBeNextTo.add(knownSortingEntities.get(entityRelation.alterUniqueIdentifier));
                    }
                    case sibling: {
                        this.couldBeNextTo.add(knownSortingEntities.get(entityRelation.alterUniqueIdentifier));
                    }
                }
            }
            Collections.sort(this.mustBeAbove);
            Collections.sort(this.couldBeNextTo);
        }

        private boolean positionIsFree(UniqueIdentifier currentIdentifier, Point targetPosition, HashMap<UniqueIdentifier, Point> entityPositions) {
            Point entityPosition;
            int useCount = 0;
            for (Point currentPosition : entityPositions.values()) {
                if (currentPosition.x != targetPosition.x || currentPosition.y != targetPosition.y) continue;
                ++useCount;
            }
            if (useCount == 0) {
                return true;
            }
            return useCount == 1 && (entityPosition = entityPositions.get(currentIdentifier)) != null && entityPosition.x == targetPosition.x && entityPosition.y == targetPosition.y;
        }

        protected Point getPosition(HashMap<UniqueIdentifier, Point> entityPositions) {
            this.addLabel("Sorting:" + sortCounter++);
            this.calculatedPosition = entityPositions.get(this.selfEntityId);
            if (this.calculatedPosition == null) {
                float averageX;
                Iterator<SortingEntity> i$ = this.mustBeBelow.iterator();
                if (i$.hasNext()) {
                    SortingEntity sortingEntity = i$.next();
                    Point nextAbovePos = entityPositions.get(sortingEntity.selfEntityId);
                    if (this.calculatedPosition == null) {
                        averageX = 0.0f;
                        int maxParentY = nextAbovePos.y;
                        for (SortingEntity sortingEntityInner : this.mustBeBelow) {
                            Point parentPosition = entityPositions.get(sortingEntityInner.selfEntityId);
                            averageX += (float)parentPosition.x;
                            if (maxParentY >= parentPosition.y) continue;
                            maxParentY = parentPosition.y;
                        }
                        averageX /= (float)this.mustBeBelow.size();
                        HashSet<SortingEntity> unionOfSiblings = new HashSet<SortingEntity>();
                        for (SortingEntity sortingEntityInner : this.mustBeBelow) {
                            unionOfSiblings.addAll(sortingEntityInner.mustBeAbove);
                        }
                        this.addLabel("NumberOfSiblings:" + unionOfSiblings.size());
                        this.calculatedPosition = new Point((int)(averageX -= (float)(GraphSorter.this.xPadding * (unionOfSiblings.size() - 1) / 2)), maxParentY + GraphSorter.this.yPadding);
                        this.addLabel(":mustBeBelow");
                    }
                }
                if (this.calculatedPosition == null) {
                    for (SortingEntity sortingEntity : this.couldBeNextTo) {
                        Point nextToPos = entityPositions.get(sortingEntity.selfEntityId);
                        if (this.calculatedPosition != null || nextToPos == null) continue;
                        this.calculatedPosition = new Point(nextToPos.x, nextToPos.y);
                        this.addLabel(":couldBeNextTo");
                        break;
                    }
                }
                if (this.calculatedPosition == null) {
                    for (SortingEntity sortingEntity : this.mustBeAbove) {
                        Point nextBelowPos = entityPositions.get(sortingEntity.selfEntityId);
                        if (nextBelowPos == null) continue;
                        averageX = (float)nextBelowPos.x + (float)(GraphSorter.this.xPadding * (this.mustBeAbove.size() - 1)) / 2.0f;
                        if (this.calculatedPosition == null) {
                            this.calculatedPosition = new Point((int)averageX, nextBelowPos.y);
                            this.addLabel(":mustBeAbove");
                        }
                        if (nextBelowPos.y >= this.calculatedPosition.y + GraphSorter.this.yPadding) break;
                        this.calculatedPosition.setLocation(this.calculatedPosition.x, nextBelowPos.y - GraphSorter.this.yPadding);
                        this.addLabel(":U");
                        break;
                    }
                }
                if (this.calculatedPosition == null) {
                    this.calculatedPosition = GraphSorter.this.getDefaultPosition(entityPositions, this.selfEntityId);
                    this.addLabel(":defaultPosition");
                }
                while (!this.positionIsFree(this.selfEntityId, this.calculatedPosition, entityPositions)) {
                    this.calculatedPosition.setLocation(this.calculatedPosition.x + GraphSorter.this.xPadding, this.calculatedPosition.y);
                    this.addLabel(":R");
                }
                entityPositions.put(this.selfEntityId, this.calculatedPosition);
                this.addLabel("FinalX:" + this.calculatedPosition.x);
            }
            return this.calculatedPosition;
        }

        protected void getRelatedPositions(HashMap<UniqueIdentifier, Point> entityPositions) {
            ArrayList<SortingEntity> allRelations = new ArrayList<SortingEntity>();
            allRelations.addAll(this.mustBeBelow);
            allRelations.add(this);
            allRelations.addAll(this.couldBeNextTo);
            allRelations.addAll(this.mustBeNextTo);
            allRelations.addAll(this.mustBeAbove);
            for (SortingEntity sortingEntity : allRelations) {
                if (sortingEntity.calculatedPosition != null) continue;
                sortingEntity.addLabel("RelatedPositions");
                for (SortingEntity sortingEntityInner : sortingEntity.mustBeBelow) {
                    if (sortingEntityInner.calculatedPosition != null) continue;
                    sortingEntityInner.addLabel("RelatedPositionsInner");
                    sortingEntityInner.getRelatedPositions(entityPositions);
                }
                sortingEntity.getPosition(entityPositions);
                sortingEntity.getRelatedPositions(entityPositions);
            }
        }
    }
}

