/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import nl.mpi.arbil.help.HelpIndex;
import nl.mpi.arbil.help.HelpItem;
import nl.mpi.arbil.help.HelpItemsParser;
import nl.mpi.arbil.ui.ArbilHyperlinkListener;
import nl.mpi.arbil.util.BugCatcherManager;
import org.xml.sax.SAXException;

public class ArbilHelp
extends JPanel {
    public static final String SHOTCUT_KEYS_PAGE = "Shortcut Keys";
    public static final String INTRODUCTION_PAGE = "Overview";
    public static final String helpWindowTitle = "Help Viewer";
    private final HelpIndex helpIndex;
    private final String helpResourceBase;
    private final DefaultTreeModel helpTreeModel;
    private final DefaultMutableTreeNode rootContentsNode;
    private static ArbilHelp singleInstance = null;
    private JScrollPane indexScrollPane;
    private JScrollPane helpTextScrollPane;
    private JSplitPane jSplitPane1;
    private JTextPane helpTextPane;
    private JTree indexTree;

    public static synchronized ArbilHelp getArbilHelpInstance() throws IOException, SAXException {
        if (singleInstance == null) {
            String helpResourceBase = "/nl/mpi/arbil/resources/html/help/";
            singleInstance = new ArbilHelp(ArbilHelp.class, "/nl/mpi/arbil/resources/html/help/", "/nl/mpi/arbil/resources/html/help/arbil.xml");
        }
        return singleInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArbilHelp(Class resourcesClass, String helpResourceBase, String indexXml) throws IOException, SAXException {
        this.initComponents();
        this.helpResourceBase = helpResourceBase;
        HelpItemsParser parser = new HelpItemsParser();
        InputStream helpStream = this.getClass().getResourceAsStream(indexXml);
        if (helpStream != null) {
            try {
                this.helpIndex = parser.parse(helpStream);
            }
            finally {
                helpStream.close();
            }
        } else {
            this.helpIndex = new HelpIndex();
            HelpItem helpItem = new HelpItem();
            helpItem.setName("Help contents not found");
            this.helpIndex.addSubItem(helpItem);
        }
        this.helpTextPane.setContentType("text/html");
        ((HTMLDocument)this.helpTextPane.getDocument()).setBase(this.getClass().getResource(helpResourceBase));
        this.indexTree.getSelectionModel().setSelectionMode(1);
        this.rootContentsNode = new DefaultMutableTreeNode("Contents");
        this.helpTreeModel = new DefaultTreeModel(this.rootContentsNode, true);
        this.indexTree.setModel(this.helpTreeModel);
        this.populateIndex(this.rootContentsNode);
        this.indexTree.setSelectionRow(1);
    }

    public void setCurrentPage(String helpPage) {
        HelpItem helpFile = this.getHelpFileByName(this.helpIndex, helpPage);
        if (helpFile != null) {
            this.showHelpItem(helpFile.getFile());
        } else {
            BugCatcherManager.getBugCatcher().logError(new Exception("Help page not found: " + helpPage));
        }
    }

    private HelpItem getHelpFileByName(HelpIndex parentItem, String name) {
        for (HelpItem child : parentItem.getSubItems()) {
            if (child.getName().replaceAll("^\\d+\\.", "").trim().equals(name)) {
                return child;
            }
            HelpItem childResult = this.getHelpFileByName(child, name);
            if (childResult == null) continue;
            return childResult;
        }
        return null;
    }

    private void populateIndex(DefaultMutableTreeNode root) {
        for (HelpItem item : this.helpIndex.getSubItems()) {
            this.populateIndex(root, item);
        }
        this.helpTreeModel.reload(root);
    }

    private void populateIndex(DefaultMutableTreeNode parent, HelpItem item) {
        DefaultMutableTreeNode itemNode = new DefaultMutableTreeNode(item, item.getSubItems().size() > 0);
        parent.add(itemNode);
        for (HelpItem subItem : item.getSubItems()) {
            this.populateIndex(itemNode, subItem);
        }
    }

    private void initComponents() {
        this.indexTree = new JTree();
        this.indexTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                ArbilHelp.this.indexTreeValueChanged(evt);
            }
        });
        this.indexScrollPane = new JScrollPane();
        this.indexScrollPane.setViewportView(this.indexTree);
        this.helpTextPane = new JTextPane();
        this.helpTextPane.addHyperlinkListener(new ArbilHyperlinkListener());
        this.helpTextPane.setMinimumSize(new Dimension(100, 100));
        this.helpTextPane.setContentType("text/html;charset=UTF-8");
        this.helpTextPane.setEditable(false);
        this.helpTextScrollPane = new JScrollPane();
        this.helpTextScrollPane.setViewportView(this.helpTextPane);
        this.jSplitPane1 = new JSplitPane();
        this.jSplitPane1.setDividerLocation(250);
        this.jSplitPane1.setLeftComponent(this.indexScrollPane);
        this.jSplitPane1.setRightComponent(this.helpTextScrollPane);
        this.setLayout(new BorderLayout());
        this.add((Component)this.jSplitPane1, "Center");
    }

    private void indexTreeValueChanged(TreeSelectionEvent evt) {
        Object nodeInfo;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.indexTree.getLastSelectedPathComponent();
        if (node != null && (nodeInfo = node.getUserObject()) instanceof HelpItem) {
            this.showHelpItem(((HelpItem)nodeInfo).getFile());
        }
    }

    public boolean showHelpItem(URL itemURL) {
        try {
            URI baseUri = this.getClass().getResource(this.helpResourceBase).toURI();
            if (itemURL.toString().startsWith(baseUri.toString())) {
                URI relativeURI = baseUri.relativize(itemURL.toURI());
                return this.updateIndex(relativeURI.getPath().toString());
            }
        }
        catch (URISyntaxException usEx) {
            BugCatcherManager.getBugCatcher().logError(usEx);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showHelpItem(String itemResource) {
        StringBuilder completeHelpText = new StringBuilder();
        InputStream itemStream = this.getClass().getResourceAsStream(this.helpResourceBase + itemResource);
        if (itemStream == null) {
            completeHelpText.append("Page not found");
        } else {
            try {
                BufferedReader bufferedHelpReader = new BufferedReader(new InputStreamReader(itemStream, "UTF-8"));
                try {
                    String helpLine = bufferedHelpReader.readLine();
                    while (helpLine != null) {
                        completeHelpText.append(helpLine);
                        helpLine = bufferedHelpReader.readLine();
                    }
                }
                catch (IOException ioEx) {
                    completeHelpText.append("<p><strong>I/O exception while reading help contents</strong></p>");
                    BugCatcherManager.getBugCatcher().logError(ioEx);
                }
                finally {
                    try {
                        bufferedHelpReader.close();
                    }
                    catch (IOException ioEx) {
                        completeHelpText.append("<p><strong>I/O exception while close stream</strong></p>");
                        BugCatcherManager.getBugCatcher().logError(ioEx);
                    }
                }
            }
            catch (UnsupportedEncodingException ueEx) {
                completeHelpText.append("<p><strong>I/O exception while close stream</strong></p>");
                BugCatcherManager.getBugCatcher().logError(ueEx);
            }
        }
        this.helpTextPane.setText(completeHelpText.toString());
        this.helpTextPane.setCaretPosition(0);
        this.updateIndex(itemResource);
    }

    private boolean updateIndex(String itemResource) {
        HelpItem helpItem;
        if (itemResource == null) {
            return false;
        }
        DefaultMutableTreeNode lastPathComponent = (DefaultMutableTreeNode)this.indexTree.getSelectionPath().getLastPathComponent();
        if (lastPathComponent.getUserObject() instanceof HelpItem && itemResource.equals((helpItem = (HelpItem)lastPathComponent.getUserObject()).getFile())) {
            return true;
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.indexTree.getModel().getRoot();
        DefaultMutableTreeNode selectionItem = this.findChild(root, itemResource);
        if (selectionItem != null) {
            TreePath treePath = new TreePath(selectionItem.getPath());
            this.indexTree.setSelectionPath(treePath);
            this.indexTree.scrollPathToVisible(treePath);
            return true;
        }
        return false;
    }

    private DefaultMutableTreeNode findChild(DefaultMutableTreeNode root, String itemResource) {
        for (int i = 0; i < root.getChildCount(); ++i) {
            HelpItem helpItem;
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)root.getChildAt(i);
            Object userObject = childNode.getUserObject();
            if (userObject instanceof HelpItem && (helpItem = (HelpItem)userObject).getFile().equals(itemResource)) {
                return childNode;
            }
            DefaultMutableTreeNode findChild = this.findChild(childNode, itemResource);
            if (findChild == null) continue;
            return findChild;
        }
        return null;
    }
}

