/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.gedcomimport;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.kinnate.gedcomimport.EntityImporter;
import nl.mpi.kinnate.gedcomimport.GenericImporter;
import nl.mpi.kinnate.gedcomimport.ImportException;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindocument.EntityDocument;
import nl.mpi.kinnate.kindocument.ImportTranslator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvImporter
extends EntityImporter
implements GenericImporter {
    private SeparatorType separatorType;

    public CsvImporter(JProgressBar progressBarLocal, JTextArea importTextAreaLocal, boolean overwriteExistingLocal, SessionStorage sessionStorage) {
        super(progressBarLocal, importTextAreaLocal, overwriteExistingLocal, sessionStorage);
    }

    @Override
    public boolean canImport(String inputFileString) {
        if (inputFileString.toLowerCase().endsWith(".csv")) {
            this.separatorType = SeparatorType.csv;
            return true;
        }
        if (inputFileString.toLowerCase().endsWith(".txt")) {
            this.separatorType = SeparatorType.tab;
            return true;
        }
        if (inputFileString.toLowerCase().endsWith(".tab")) {
            this.separatorType = SeparatorType.tab;
            return true;
        }
        return false;
    }

    @Deprecated
    private String cleanCsvString(String valueString) {
        valueString = valueString.replaceAll("^\"", "");
        valueString = valueString.replaceAll("\"$", "");
        valueString = valueString.replaceAll("\"\"", "");
        return valueString;
    }

    private boolean isAnExcludedId(String idString, boolean firstLineIdZero) {
        if ("".equals(idString)) {
            return true;
        }
        if (firstLineIdZero) {
            return false;
        }
        return "0".equals(idString);
    }

    protected ArrayList<String> getFieldsForLineExcludingComments(BufferedReader bufferedReader, char fieldSeparator) throws IOException {
        ArrayList<String> fieldsForLine = null;
        while (fieldsForLine == null || fieldsForLine.size() > 0 && fieldsForLine.get(0).startsWith("*")) {
            fieldsForLine = this.getFieldsForLine(bufferedReader, fieldSeparator);
        }
        return fieldsForLine;
    }

    protected ArrayList<String> getFieldsForLine(BufferedReader bufferedReader, char fieldSeparator) throws IOException {
        ArrayList<String> lineFields = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int readChar = bufferedReader.read();
            while (readChar != -1) {
                switch (readChar) {
                    case 10: 
                    case 13: {
                        if (stringBuilder.length() > 0) {
                            lineFields.add(stringBuilder.toString());
                        }
                        if (lineFields.isEmpty()) break;
                    }
                    case -1: {
                        return lineFields;
                    }
                    case 34: {
                        boolean insideQuotes = true;
                        int quotedCharsCount = 0;
                        while (insideQuotes) {
                            int readQuoted = bufferedReader.read();
                            if (readQuoted == -1) {
                                this.appendToTaskOutput("Warning: file ended within a quoted section");
                                return lineFields;
                            }
                            ++quotedCharsCount;
                            insideQuotes = readQuoted != 34;
                            if (!insideQuotes) continue;
                            stringBuilder.append((char)readQuoted);
                        }
                        if (quotedCharsCount >= true) break;
                        stringBuilder.append((char)readChar);
                        break;
                    }
                    case 9: 
                    case 44: {
                        if (fieldSeparator == readChar) {
                            lineFields.add(stringBuilder.toString());
                            stringBuilder = new StringBuilder();
                            break;
                        }
                    }
                    default: {
                        stringBuilder.append((char)readChar);
                    }
                }
                readChar = bufferedReader.read();
            }
        }
        catch (IOException exception) {
            this.appendToTaskOutput("Failed to read lines of input file");
            throw exception;
        }
        if (stringBuilder.length() > 0) {
            lineFields.add(stringBuilder.toString());
        }
        return lineFields;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public URI[] importFile(InputStreamReader inputStreamReader, String profileId) {
        void var8_13;
        Object[] parentColumns;
        Object[] unionColumns;
        char fieldSeparator;
        switch (this.separatorType) {
            case csv: {
                this.appendToTaskOutput("reading file as comma separated values.");
                fieldSeparator = ',';
                break;
            }
            default: {
                this.appendToTaskOutput("reading file as tab separated values.");
                fieldSeparator = '\t';
            }
        }
        this.appendToTaskOutput("");
        this.appendToTaskOutput("If a column called 'ID' exists it will be used as the identifier for each line.");
        this.appendToTaskOutput("If the ID column contains the same value twice, then the preceding entity will be updated/appended to.");
        this.appendToTaskOutput("If the ID column contains a UniqueIdentifier already in the project then that entity will be updated/appended to.");
        this.appendToTaskOutput("");
        this.appendToTaskOutput("Lines starting with * will be treated as comments and ignored.");
        this.appendToTaskOutput("");
        this.appendToTaskOutput("Recommended data columns are:");
        this.appendToTaskOutput("Name");
        this.appendToTaskOutput("Gender");
        this.appendToTaskOutput("DateOfBirth");
        this.appendToTaskOutput("DateOfDeath");
        this.appendToTaskOutput("");
        this.appendToTaskOutput("Relation columns must map to the values in the ID column.");
        this.appendToTaskOutput("Recognised relation columns are:");
        for (String string : unionColumns = new String[]{"spouse", "union"}) {
            this.appendToTaskOutput(string);
        }
        Object[] arr$ = parentColumns = new String[]{"parent", "father", "mother"};
        int len$ = arr$.length;
        boolean bl = false;
        while (var8_13 < len$) {
            String string = arr$[var8_13];
            this.appendToTaskOutput(string);
            ++var8_13;
        }
        this.appendToTaskOutput("");
        this.appendToTaskOutput("Additional supported relation columns are:");
        this.appendToTaskOutput("Spouses<number>-ID");
        this.appendToTaskOutput("Parents<number>-ID");
        this.appendToTaskOutput("Children<number>-ID");
        this.appendToTaskOutput("");
        this.appendToTaskOutput("Any other columns will be added to the kindata but not automatically used in the subsequent diagrams.");
        this.appendToTaskOutput("");
        this.appendToTaskOutput("If the ID field exists and any row contains the text ID then the headers are replaced with current row values (for PUCK txt files).");
        this.appendToTaskOutput("If the first record does not start at zero then all relations to the ID of zero will be ignored.");
        this.appendToTaskOutput("");
        ArrayList<URI> createdNodes = new ArrayList<URI>();
        try {
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            ImportTranslator importTranslator = new ImportTranslator(true);
            importTranslator.addTranslationEntry("Gender", "0", "Gender", "Female");
            importTranslator.addTranslationEntry("Gender", "1", "Gender", "Male");
            importTranslator.addTranslationEntry("Gender", "f", "Gender", "Female");
            importTranslator.addTranslationEntry("Gender", "m", "Gender", "Male");
            importTranslator.addTranslationEntry("Sex", "m", "Gender", "Male");
            importTranslator.addTranslationEntry("Sex", "f", "Gender", "Female");
            importTranslator.addTranslationEntry("Sex", "h", "Gender", "Male");
            importTranslator.addTranslationEntry("Date_of_Birth", null, "DateOfBirth", null);
            importTranslator.addTranslationEntry("Date_of_Death", null, "DateOfDeath", null);
            ArrayList<String> arrayList = this.getFieldsForLineExcludingComments(bufferedReader, fieldSeparator);
            for (int columnCounter = 0; columnCounter < arrayList.size(); ++columnCounter) {
                String titleString = arrayList.get(columnCounter);
                if (titleString.equals("")) {
                    this.appendToTaskOutput("Warning: No title found for column. Inserting \"Untitled\" as the column name.");
                    arrayList.set(columnCounter, "Untitled");
                    continue;
                }
                if (titleString.matches("$0-9.*")) {
                    this.appendToTaskOutput("Warning: Column title \"" + titleString + "\" starts with a number.");
                }
                if (titleString.matches("[a-zA-Z0-9]+")) continue;
                this.appendToTaskOutput("Warning: Column title \"" + titleString + "\" contains invalid characters. Punctuation and white space are not allowed (so that the data is compatable with XML and other applications).");
            }
            super.incrementLineProgress();
            try {
                int lineCounter = -1;
                int idColumn = -1;
                ArrayList<Integer> unionColumnIndexes = new ArrayList<Integer>();
                ArrayList<Integer> parentColumnIndexs = new ArrayList<Integer>();
                for (int headingCounter = 0; headingCounter < arrayList.size(); ++headingCounter) {
                    String headingLowerCase = arrayList.get(headingCounter).toLowerCase();
                    if (headingLowerCase.equals("id")) {
                        idColumn = headingCounter;
                    }
                    if (Arrays.binarySearch(unionColumns, headingLowerCase) > -1) {
                        unionColumnIndexes.add(headingCounter);
                    }
                    if (Arrays.binarySearch(parentColumns, headingLowerCase) <= -1) continue;
                    parentColumnIndexs.add(headingCounter);
                }
                boolean firstLineIdZero = true;
                ArrayList<String> lineFields = this.getFieldsForLineExcludingComments(bufferedReader, fieldSeparator);
                while (!lineFields.isEmpty()) {
                    String recordID;
                    ++lineCounter;
                    EntityDocument currentEntity = null;
                    EntityDocument relatedEntity = null;
                    if (idColumn == -1) {
                        recordID = Integer.toString(lineCounter);
                    } else if (idColumn < lineFields.size()) {
                        recordID = lineFields.get(idColumn);
                    } else {
                        this.appendToTaskOutput("Error: No ID value for line " + lineCounter);
                        recordID = "-1";
                    }
                    if (lineCounter == 0) {
                        firstLineIdZero = recordID.equals("0");
                    }
                    currentEntity = this.getEntityDocument(createdNodes, profileId, recordID, importTranslator);
                    String relatedEntityPrefix = null;
                    for (int fieldCounter = 0; fieldCounter < lineFields.size(); ++fieldCounter) {
                        String headingString;
                        void var9_17;
                        String entityField = lineFields.get(fieldCounter);
                        if (var9_17.size() > fieldCounter) {
                            headingString = (String)var9_17.get(fieldCounter);
                        } else {
                            headingString = "-unnamed-field-";
                            this.appendToTaskOutput("Warning more values than headers, using " + headingString + " for value: " + entityField);
                        }
                        if (idColumn == fieldCounter) {
                            if (!entityField.toLowerCase().equals("id")) continue;
                            unionColumnIndexes.clear();
                            parentColumnIndexs.clear();
                            ArrayList<String> arrayList2 = lineFields;
                            break;
                        }
                        if (unionColumnIndexes.contains(fieldCounter)) {
                            if (this.isAnExcludedId(entityField, firstLineIdZero)) continue;
                            relatedEntity = this.getEntityDocument(createdNodes, profileId, entityField, importTranslator);
                            currentEntity.entityData.addRelatedNode(relatedEntity.entityData, DataTypes.RelationType.union, null, null, null, null);
                            continue;
                        }
                        if (parentColumnIndexs.contains(fieldCounter)) {
                            if (this.isAnExcludedId(entityField, firstLineIdZero)) continue;
                            relatedEntity = this.getEntityDocument(createdNodes, profileId, entityField, importTranslator);
                            currentEntity.entityData.addRelatedNode(relatedEntity.entityData, DataTypes.RelationType.ancestor, null, null, null, null);
                            continue;
                        }
                        if (headingString.matches("Spouses[\\d]*-ID")) {
                            if (this.isAnExcludedId(entityField, firstLineIdZero)) continue;
                            relatedEntity = this.getEntityDocument(createdNodes, profileId, entityField, importTranslator);
                            currentEntity.entityData.addRelatedNode(relatedEntity.entityData, DataTypes.RelationType.union, null, null, null, null);
                            relatedEntityPrefix = headingString.substring(0, headingString.length() - "ID".length());
                            continue;
                        }
                        if (headingString.matches("Parents[\\d]*-ID")) {
                            if (this.isAnExcludedId(entityField, firstLineIdZero)) continue;
                            relatedEntity = this.getEntityDocument(createdNodes, profileId, entityField, importTranslator);
                            currentEntity.entityData.addRelatedNode(relatedEntity.entityData, DataTypes.RelationType.ancestor, null, null, null, null);
                            relatedEntityPrefix = headingString.substring(0, headingString.length() - "ID".length());
                            continue;
                        }
                        if (headingString.matches("Children[\\d]*-ID")) {
                            if (this.isAnExcludedId(entityField, firstLineIdZero)) continue;
                            relatedEntity = this.getEntityDocument(createdNodes, profileId, entityField, importTranslator);
                            currentEntity.entityData.addRelatedNode(relatedEntity.entityData, DataTypes.RelationType.descendant, null, null, null, null);
                            relatedEntityPrefix = headingString.substring(0, headingString.length() - "ID".length());
                            continue;
                        }
                        if (relatedEntityPrefix != null && headingString.startsWith(relatedEntityPrefix)) {
                            relatedEntity.insertValue(headingString.substring(relatedEntityPrefix.length()), entityField);
                            continue;
                        }
                        currentEntity.insertValue(headingString, entityField);
                    }
                    super.incrementLineProgress();
                    lineFields = this.getFieldsForLineExcludingComments(bufferedReader, fieldSeparator);
                }
            }
            catch (ImportException exception) {
                this.appendToTaskOutput(exception.getMessage());
            }
            this.saveAllDocuments();
        }
        catch (IOException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)exception);
            this.appendToTaskOutput("Error: " + exception.getMessage());
        }
        return createdNodes.toArray(new URI[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum SeparatorType {
        tab,
        csv;

    }
}

