/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.kindata;

import java.awt.Component;
import java.util.HashSet;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import nl.mpi.kinnate.ui.HidePane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisiblePanelSetting
implements Comparable<VisiblePanelSetting> {
    @XmlAttribute(name="type", namespace="http://mpi.nl/tla/kin")
    PanelType panelType = null;
    @XmlAttribute(name="show", namespace="http://mpi.nl/tla/kin")
    boolean panelShown;
    @XmlAttribute(name="width", namespace="http://mpi.nl/tla/kin")
    int panelWidth;
    @XmlTransient
    boolean menuEnabled = true;
    @XmlTransient
    private String displayName = "";
    @XmlTransient
    private HidePane hidePane;
    @XmlTransient
    private HashSet<Component> targetPanel = new HashSet();

    public VisiblePanelSetting() {
    }

    public VisiblePanelSetting(PanelType panelType, boolean panelShown, int panelWidth) {
        this.panelType = panelType;
        this.panelShown = panelShown;
        this.panelWidth = panelWidth;
    }

    public void setHidePane(HidePane hidePane, String displayName) {
        this.hidePane = hidePane;
        this.displayName = displayName;
    }

    public void setMenuEnabled(boolean menuEnabled) {
        this.menuEnabled = menuEnabled;
    }

    public boolean isMenuEnabled() {
        return this.menuEnabled;
    }

    private void setUpdateUiState() {
        if (this.panelShown) {
            for (Component currentPanel : this.getTargetPanels()) {
                String tabStringName = currentPanel.getName();
                if (tabStringName == null || tabStringName.length() < 1) {
                    tabStringName = this.displayName;
                }
                this.hidePane.addTab(this, tabStringName, currentPanel);
            }
        } else {
            this.hidePane.remove(this);
        }
    }

    public void addTargetPanel(Component targetPanel, boolean setAsSelected) {
        this.targetPanel.add(targetPanel);
        this.setUpdateUiState();
        if (setAsSelected) {
            this.hidePane.setSelectedComponent(targetPanel);
        }
    }

    public void removeTargetPanel(Component targetPanel) {
        this.targetPanel.remove(targetPanel);
        this.hidePane.removeTab(targetPanel);
    }

    public boolean isPanelShown() {
        return this.panelShown;
    }

    @XmlTransient
    public void setPanelShown(boolean panelShown) {
        this.panelShown = panelShown;
        this.setUpdateUiState();
    }

    @XmlTransient
    public void setPanelWidth(int panelWidth) {
        this.panelWidth = panelWidth;
    }

    public int getPanelWidth() {
        return this.panelWidth;
    }

    @XmlTransient
    public Component[] getTargetPanels() {
        return this.targetPanel.toArray(new Component[0]);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public PanelType getPanelType() {
        return this.panelType;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VisiblePanelSetting other = (VisiblePanelSetting)obj;
        return this.panelType == other.panelType;
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + (this.panelType != null ? this.panelType.hashCode() : 0);
        return hash;
    }

    @Override
    public int compareTo(VisiblePanelSetting o) {
        if (this.getDisplayName() == null) {
            if (o.getDisplayName() == null) {
                return 0;
            }
            return -1;
        }
        if (o.getDisplayName() == null) {
            return -1;
        }
        return this.getDisplayName().compareToIgnoreCase(o.getDisplayName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PanelType {
        KinTypeStrings,
        KinTerms,
        ArchiveLinker,
        IndexerSettings,
        DiagramTree,
        EntitySearch,
        ExportPanel,
        PluginPanel;

    }
}

