/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.svg;

import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindata.RelationTypeDefinition;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;

public class RelationDragHandle {
    private DataTypes.RelationType relationType;
    private RelationTypeDefinition customTypeDefinition;
    protected float elementStartX;
    protected float elementStartY;
    protected float mouseStartX;
    protected float mouseStartY;
    protected float diagramScaleFactor;
    protected UniqueIdentifier targetIdentifier = null;

    public RelationDragHandle(RelationTypeDefinition customTypeDefinition, DataTypes.RelationType relationType, float elementStartX, float elementStartY, float mouseStartX, float mouseStartY, double diagramScaleFactor) {
        if (relationType == null) {
            throw new UnsupportedOperationException("relationType must be specified in RelationDragHandle");
        }
        this.customTypeDefinition = customTypeDefinition;
        this.relationType = relationType;
        this.elementStartX = elementStartX;
        this.elementStartY = elementStartY;
        this.mouseStartX = mouseStartX;
        this.mouseStartY = mouseStartY;
        this.diagramScaleFactor = (float)diagramScaleFactor;
    }

    protected float getTranslatedX(float localDragNodeX) {
        return this.elementStartX + (localDragNodeX - this.mouseStartX) * this.diagramScaleFactor;
    }

    protected float getTranslatedY(float localDragNodeY) {
        return this.elementStartY + (localDragNodeY - this.mouseStartY) * this.diagramScaleFactor;
    }

    public DataTypes.RelationType getRelationType() {
        return this.relationType;
    }

    public String getRelationColour() {
        if (this.customTypeDefinition != null) {
            return this.customTypeDefinition.getLineColour();
        }
        return "blue";
    }

    public String getDataCategory() {
        if (this.customTypeDefinition != null) {
            return this.customTypeDefinition.getDataCategory();
        }
        return null;
    }

    public String getDisplayName() {
        if (this.customTypeDefinition != null) {
            return this.customTypeDefinition.getDisplayName();
        }
        return null;
    }

    public RelationTypeDefinition.CurveLineOrientation getCurveLineOrientation() {
        if (this.customTypeDefinition != null) {
            return this.customTypeDefinition.getCurveLineOrientation();
        }
        return null;
    }
}

