/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import nl.mpi.arbil.data.ArbilDataNodeLoader;
import nl.mpi.arbil.data.ArbilTreeHelper;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.XsdChecker;
import nl.mpi.kinnate.SavePanel;
import nl.mpi.kinnate.entityindexer.EntityCollection;
import nl.mpi.kinnate.gedcomimport.CsvImporter;
import nl.mpi.kinnate.gedcomimport.GedcomImporter;
import nl.mpi.kinnate.gedcomimport.GenericImporter;
import nl.mpi.kinnate.gedcomimport.ImportException;
import nl.mpi.kinnate.gedcomimport.KinOathImporter;
import nl.mpi.kinnate.gedcomimport.TipImporter;
import nl.mpi.kinnate.svg.DataStoreSvg;
import nl.mpi.kinnate.ui.KinDiagramPanel;
import nl.mpi.kinnate.ui.entityprofiles.ProfileRecord;
import nl.mpi.kinnate.ui.menu.DocumentNewMenu;
import nl.mpi.kinnate.ui.window.AbstractDiagramManager;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;

public class GedcomImportPanel
extends JPanel {
    private EntityCollection entityCollection;
    private AbstractDiagramManager abstractDiagramManager;
    private Component parentComponent;
    private JTextArea importTextArea;
    private JProgressBar progressBar;
    private JCheckBox overwriteOnImport;
    private JCheckBox validateImportedXml;
    private JButton cancelButton;
    private JButton startButton;
    private JButton closeButton;
    private JPanel endPagePanel;
    private SessionStorage sessionStorage;
    private ArbilWindowManager dialogHandler;
    private ArbilDataNodeLoader dataNodeLoader;
    private ArbilTreeHelper treeHelper;
    private JDialog dialoguePanel;
    private Component errorPanel = null;

    public GedcomImportPanel(AbstractDiagramManager abstractDiagramManager, Component parentComponent, EntityCollection entityCollection, SessionStorage sessionStorage, ArbilWindowManager dialogHandler, ArbilDataNodeLoader dataNodeLoader, ArbilTreeHelper treeHelper) {
        this.setPreferredSize(new Dimension(500, 500));
        this.abstractDiagramManager = abstractDiagramManager;
        this.parentComponent = parentComponent;
        this.entityCollection = entityCollection;
        this.sessionStorage = sessionStorage;
        this.dialogHandler = dialogHandler;
        this.dataNodeLoader = dataNodeLoader;
        this.treeHelper = treeHelper;
    }

    protected String getCreatedNodesMessage(final GenericImporter gedcomImporter) {
        if (gedcomImporter.getCreatedNodeIds().isEmpty()) {
            return "No data was imported, nothing to show in the graph.";
        }
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                KinDiagramPanel kinDiagramPanel;
                SavePanel currentSavePanel = GedcomImportPanel.this.abstractDiagramManager.getCurrentSavePanel(GedcomImportPanel.this.parentComponent);
                if (currentSavePanel instanceof KinDiagramPanel) {
                    kinDiagramPanel = (KinDiagramPanel)currentSavePanel;
                } else {
                    kinDiagramPanel = new KinDiagramPanel(DocumentNewMenu.DocumentType.Simple, GedcomImportPanel.this.sessionStorage, GedcomImportPanel.this.dialogHandler, GedcomImportPanel.this.dataNodeLoader, GedcomImportPanel.this.treeHelper, GedcomImportPanel.this.entityCollection, GedcomImportPanel.this.abstractDiagramManager);
                    kinDiagramPanel.setName("Imported Entities");
                    GedcomImportPanel.this.abstractDiagramManager.createDiagramContainer(kinDiagramPanel, null);
                }
                HashSet<UniqueIdentifier> selectedIds = new HashSet<UniqueIdentifier>();
                for (HashSet<UniqueIdentifier> identifiers : gedcomImporter.getCreatedNodeIds().values()) {
                    selectedIds.addAll(identifiers);
                }
                kinDiagramPanel.addNodeCollection(selectedIds.toArray(new UniqueIdentifier[0]), "Imported Entities");
                kinDiagramPanel.loadAllTrees();
                GedcomImportPanel.this.dialoguePanel.dispose();
            }
        });
        this.closeButton.setEnabled(true);
        return "Import complete.";
    }

    public void startImport(File importFile) throws ImportException {
        this.startImport(importFile, null, importFile.getName());
    }

    public void startImport(String importUriString) throws ImportException {
        File cachedFile = this.sessionStorage.updateCache(importUriString, 30, true);
        this.startImport(cachedFile, null, importUriString);
    }

    public void startImportJar(String importFileString) throws ImportException {
        this.startImport(null, importFileString, importFileString);
    }

    private void startImport(final File importFile, final String importFileString, String importLabel) throws ImportException {
        if (importFile != null && !importFile.exists()) {
            throw new ImportException("The import file was not found.");
        }
        this.importTextArea = new JTextArea();
        JScrollPane importScrollPane = new JScrollPane(this.importTextArea);
        this.setLayout(new BorderLayout());
        this.add((Component)importScrollPane, "Center");
        String titleString = importFile != null ? "Import: " + importFile.getName() : "Import: " + importFileString.substring(importFileString.lastIndexOf("/") + 1);
        this.setName(titleString);
        this.progressBar = new JProgressBar(0, 100);
        this.endPagePanel = new JPanel(new BorderLayout());
        this.endPagePanel.add((Component)this.progressBar, "First");
        this.add((Component)this.endPagePanel, "Last");
        this.progressBar.setVisible(true);
        JPanel bottomPanel = new JPanel();
        JPanel topPanel = new JPanel();
        final JComboBox<ProfileRecord> profileSelectBox = new JComboBox<ProfileRecord>(new DataStoreSvg().selectedProfiles);
        ProfileRecord defaultImportProfile = ProfileRecord.getDefaultImportProfile();
        profileSelectBox.addItem(defaultImportProfile);
        profileSelectBox.setSelectedItem(defaultImportProfile);
        topPanel.add(profileSelectBox);
        this.overwriteOnImport = new JCheckBox("Overwrite Existing");
        this.overwriteOnImport.setEnabled(false);
        this.cancelButton = new JButton("Cancel");
        this.startButton = new JButton("Start Import");
        this.closeButton = new JButton("Close");
        this.closeButton.setEnabled(false);
        topPanel.add(this.overwriteOnImport);
        this.validateImportedXml = new JCheckBox("Validate Xml");
        topPanel.add(this.validateImportedXml);
        bottomPanel.add(this.cancelButton);
        bottomPanel.add(this.startButton);
        bottomPanel.add(this.closeButton);
        JPanel topOuterPanel = new JPanel(new BorderLayout());
        final JLabel messageLabel = new JLabel(importLabel, 0);
        this.endPagePanel.add((Component)messageLabel, "Center");
        topOuterPanel.add((Component)topPanel, "Center");
        this.endPagePanel.add((Component)bottomPanel, "Last");
        this.add((Component)topOuterPanel, "First");
        this.startButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GedcomImportPanel.this.cancelButton.setEnabled(false);
                GedcomImportPanel.this.startButton.setEnabled(false);
                GedcomImportPanel.this.overwriteOnImport.setEnabled(false);
                GedcomImportPanel.this.validateImportedXml.setEnabled(false);
                profileSelectBox.setEnabled(false);
                final String profileId = ((ProfileRecord)profileSelectBox.getSelectedItem()).profileId;
                new Thread(){

                    public void run() {
                        try {
                            boolean overwriteExisting = GedcomImportPanel.this.overwriteOnImport.isSelected();
                            GenericImporter genericImporter = null;
                            for (GenericImporter testImporter : new GenericImporter[]{new GedcomImporter(GedcomImportPanel.this.progressBar, GedcomImportPanel.this.importTextArea, overwriteExisting, GedcomImportPanel.this.sessionStorage), new CsvImporter(GedcomImportPanel.this.progressBar, GedcomImportPanel.this.importTextArea, overwriteExisting, GedcomImportPanel.this.sessionStorage), new KinOathImporter(GedcomImportPanel.this.progressBar, GedcomImportPanel.this.importTextArea, overwriteExisting, GedcomImportPanel.this.sessionStorage), new TipImporter(GedcomImportPanel.this.progressBar, GedcomImportPanel.this.importTextArea, overwriteExisting, GedcomImportPanel.this.sessionStorage)}) {
                                if (importFileString != null) {
                                    if (!testImporter.canImport(importFileString)) continue;
                                    genericImporter = testImporter;
                                    break;
                                }
                                if (!testImporter.canImport(importFile.toString())) continue;
                                genericImporter = testImporter;
                                break;
                            }
                            if (genericImporter == null) {
                                GedcomImportPanel.this.importTextArea.append("No importers found for this file\n");
                                return;
                            }
                            GedcomImportPanel.this.importTextArea.append("Importing the kinship data (step 1/4)\n");
                            GedcomImportPanel.this.importTextArea.setCaretPosition(GedcomImportPanel.this.importTextArea.getText().length());
                            URI[] treeNodesArray = importFileString != null ? genericImporter.importFile(importFileString, profileId) : genericImporter.importFile(importFile, profileId);
                            boolean checkFilesAfterImport = GedcomImportPanel.this.validateImportedXml.isSelected();
                            if (treeNodesArray != null && checkFilesAfterImport) {
                                int maxXsdErrorToShow = 3;
                                GedcomImportPanel.this.importTextArea.append("Checking XML of imported data  (step 3/4)\n");
                                GedcomImportPanel.this.importTextArea.setCaretPosition(GedcomImportPanel.this.importTextArea.getText().length());
                                final int maxProgress = treeNodesArray.length + 1;
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        GedcomImportPanel.this.progressBar.setValue(0);
                                        GedcomImportPanel.this.progressBar.setMaximum(maxProgress);
                                    }
                                });
                                for (final URI currentNodeUri : treeNodesArray) {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        public void run() {
                                            GedcomImportPanel.this.progressBar.setValue(GedcomImportPanel.this.progressBar.getValue() + 1);
                                        }
                                    });
                                    if (maxXsdErrorToShow <= 0) continue;
                                    SwingUtilities.invokeLater(new Runnable(){

                                        public void run() {
                                            XsdChecker xsdChecker = new XsdChecker();
                                            if (xsdChecker.simpleCheck(new File(currentNodeUri)) != null) {
                                                xsdChecker.checkXML(GedcomImportPanel.this.dataNodeLoader.getArbilDataNode(null, currentNodeUri));
                                                xsdChecker.setDividerLocation(0.5);
                                                if (GedcomImportPanel.this.errorPanel == null) {
                                                    xsdChecker.setName("XSD Error on Import");
                                                    GedcomImportPanel.this.errorPanel = GedcomImportPanel.this.abstractDiagramManager.createDiagramContainer((Component)xsdChecker, null);
                                                } else {
                                                    GedcomImportPanel.this.abstractDiagramManager.createDiagramSubPanel("XSD Error on Import", (Component)xsdChecker, GedcomImportPanel.this.errorPanel);
                                                }
                                            }
                                        }
                                    });
                                    if (--maxXsdErrorToShow > 0) continue;
                                    GedcomImportPanel.this.importTextArea.append("maximum xsd errors shown, no more files will be tested\n");
                                }
                                if (GedcomImportPanel.this.errorPanel instanceof JFrame) {
                                    ((JFrame)GedcomImportPanel.this.errorPanel).pack();
                                }
                            } else {
                                GedcomImportPanel.this.importTextArea.append("Skipping check XML of imported data  (step 3/4)\n");
                            }
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    GedcomImportPanel.this.progressBar.setIndeterminate(true);
                                }
                            });
                            GedcomImportPanel.this.importTextArea.append("Starting update of entity database (step 4/4)\n");
                            GedcomImportPanel.this.importTextArea.setCaretPosition(GedcomImportPanel.this.importTextArea.getText().length());
                            GedcomImportPanel.this.entityCollection.updateDatabase(treeNodesArray, GedcomImportPanel.this.progressBar);
                            GedcomImportPanel.this.importTextArea.append("Import complete\n");
                            GedcomImportPanel.this.importTextArea.setCaretPosition(GedcomImportPanel.this.importTextArea.getText().length());
                            GedcomImportPanel.this.progressBar.setIndeterminate(false);
                            messageLabel.setText(GedcomImportPanel.this.getCreatedNodesMessage(genericImporter));
                            GedcomImportPanel.this.revalidate();
                        }
                        catch (IOException exception) {
                            GedcomImportPanel.this.importTextArea.append("Import Failed: " + exception.getMessage() + "\n");
                        }
                        catch (ImportException exception) {
                            GedcomImportPanel.this.importTextArea.append("Import Failed:" + exception.getMessage() + "\n");
                        }
                        GedcomImportPanel.this.progressBar.setVisible(false);
                    }
                }.start();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GedcomImportPanel.this.dialoguePanel.dispose();
            }
        });
        this.dialoguePanel = this.abstractDiagramManager.createDialogueContainer(this, this.parentComponent);
        this.dialoguePanel.setVisible(true);
    }
}

