/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.svg;

import nl.mpi.kinnate.svg.RelationDragHandle;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;
import org.w3c.dom.Element;

public class GraphicsDragHandle
extends RelationDragHandle {
    protected UniqueIdentifier graphicsIdentifier;
    protected Element graphicsElement;
    protected Element highlightElement;
    protected Element highlightRectElement;
    private String xAttribute;
    private String yAttribute;

    public GraphicsDragHandle(Element graphicsElement, Element highlightElement, Element highlightRectElement, float elementStartX, float elementStartY, float mouseStartX, float mouseStartY, double diagramScaleFactor) {
        super(null, null, elementStartX, elementStartY, mouseStartX, mouseStartY, diagramScaleFactor);
        this.graphicsElement = graphicsElement;
        this.highlightElement = highlightElement;
        this.highlightRectElement = highlightRectElement;
        String elementType = graphicsElement.getTagName();
        if (elementType.equals("circle")) {
            this.xAttribute = "r";
            this.yAttribute = null;
        } else if (elementType.equals("rect")) {
            this.xAttribute = "width";
            this.yAttribute = "height";
        } else if (elementType.equals("ellipse")) {
            this.xAttribute = "rx";
            this.yAttribute = "ry";
        }
    }

    protected void updatedElement(float localDragNodeX, float localDragNodeY) {
        float dragNodeX = this.getTranslatedX(localDragNodeX);
        float dragNodeY = this.getTranslatedY(localDragNodeY);
        if (dragNodeX < 1.0f) {
            dragNodeX = 1.0f;
        }
        if (dragNodeY < 1.0f) {
            dragNodeY = 1.0f;
        }
        int highlightRectMultiplier = 2;
        this.graphicsElement.setAttribute(this.xAttribute, Float.toString(dragNodeX));
        if (this.yAttribute != null) {
            highlightRectMultiplier = 1;
            this.graphicsElement.setAttribute(this.yAttribute, Float.toString(dragNodeY));
        }
        this.highlightElement.setAttribute("cx", Float.toString(dragNodeX));
        this.highlightElement.setAttribute("cy", Float.toString(dragNodeY));
        this.highlightRectElement.setAttribute("width", Float.toString(dragNodeX * (float)highlightRectMultiplier));
        this.highlightRectElement.setAttribute("height", Float.toString(dragNodeY * (float)highlightRectMultiplier));
    }
}

