/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui.menu;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URI;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import nl.mpi.arbil.ArbilVersion;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.ApplicationVersion;
import nl.mpi.arbil.util.ApplicationVersionManager;
import nl.mpi.arbil.util.ArbilBugCatcher;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.kinnate.ui.KinOathHelp;
import nl.mpi.kinnate.ui.window.AbstractDiagramManager;
import org.xml.sax.SAXException;

public class HelpMenu
extends JMenu {
    JFrame helpWindow = null;

    public HelpMenu(final AbstractDiagramManager diagramWindowManager, final ArbilWindowManager dialogHandler, final SessionStorage sessionStorage, final ApplicationVersionManager versionManager) {
        this.setText("Help");
        JMenuItem aboutMenuItem = new JMenuItem("About");
        aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ApplicationVersion appVersion = versionManager.getApplicationVersion();
                String messageString = "KinOath is an application for  Kinship and Archiving.\nDesigned to be flexible and culturally nonspecific, such that\nculturally different social structures can equally be represented.\n\nBy linking archived data to kinship individuals, queries can be\nperformed to retrieve the archive data based on kinship relations.\n\nMax Planck Institute for Psycholinguistics Nijmegen\nApplication design and programming by Peter Withers\nKinOath also uses components of Arbil\n\nKinOath Version: " + appVersion.currentMajor + "." + appVersion.currentMinor + "." + appVersion.currentRevision + "\n" + appVersion.lastCommitDate + "\n" + "Compile Date: " + appVersion.compileDate + "\n" + "Arbil Version: " + new ArbilVersion().currentMajor + "." + new ArbilVersion().currentMinor + "." + new ArbilVersion().currentRevision + "\n" + "Java version: " + System.getProperty("java.version") + " by " + System.getProperty("java.vendor");
                dialogHandler.addMessageDialogToQueue(messageString, "About " + versionManager.getApplicationVersion().applicationTitle);
            }
        });
        this.add(aboutMenuItem);
        JMenuItem helpMenuItem = new JMenuItem("Internal Help");
        helpMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        helpMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (HelpMenu.this.helpWindow == null) {
                        HelpMenu.this.helpWindow = diagramWindowManager.createHelpWindow("Internal Help", (Component)((Object)new KinOathHelp()), null);
                    } else {
                        HelpMenu.this.helpWindow.setVisible(true);
                        HelpMenu.this.helpWindow.toFront();
                    }
                }
                catch (IOException ex) {
                    dialogHandler.addMessageDialogToQueue("Could not start the help system:\n" + ex.getMessage(), "Internal Help");
                    BugCatcherManager.getBugCatcher().logError((Exception)ex);
                }
                catch (SAXException ex) {
                    dialogHandler.addMessageDialogToQueue("Could not start the help system:\n" + ex.getMessage(), "Internal Help");
                    BugCatcherManager.getBugCatcher().logError((Exception)ex);
                }
            }
        });
        helpMenuItem.setEnabled(true);
        this.add(helpMenuItem);
        JMenuItem arbilWebsiteMenuItem = new JMenuItem("KinOath Website");
        arbilWebsiteMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    dialogHandler.openFileInExternalApplication(new URI("http://tla.mpi.nl/tools/tla-tools/kinoath"));
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.add(arbilWebsiteMenuItem);
        JMenuItem arbilOnlineManualMenuItem = new JMenuItem("KinOath Online Manual");
        arbilOnlineManualMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    dialogHandler.openFileInExternalApplication(new URI("http://www.mpi.nl/corpus/html/kinoath/index.html"));
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.add(arbilOnlineManualMenuItem);
        JMenuItem arbilForumMenuItem = new JMenuItem("KinOath Forum (Website)");
        arbilForumMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    dialogHandler.openFileInExternalApplication(new URI("http://tla.mpi.nl/forums/software/kinoath"));
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.add(arbilForumMenuItem);
        final JMenuItem viewErrorLogMenuItem = new JMenuItem("View Error Log");
        viewErrorLogMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    dialogHandler.openFileInExternalApplication(ArbilBugCatcher.getLogFile((SessionStorage)sessionStorage, (ApplicationVersion)versionManager.getApplicationVersion()).toURI());
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.add(viewErrorLogMenuItem);
        JMenuItem checkForUpdatesMenuItem = new JMenuItem("Check for Updates");
        checkForUpdatesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (!versionManager.forceUpdateCheck()) {
                        ApplicationVersion appVersion = versionManager.getApplicationVersion();
                        String versionString = appVersion.currentMajor + "." + appVersion.currentMinor + "." + appVersion.currentRevision;
                        dialogHandler.addMessageDialogToQueue("No updates found, current version is " + versionString, "Check for Updates");
                    }
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.add(checkForUpdatesMenuItem);
        this.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                viewErrorLogMenuItem.setEnabled(ArbilBugCatcher.getLogFile((SessionStorage)sessionStorage, (ApplicationVersion)versionManager.getApplicationVersion()).exists());
            }
        });
    }
}

