/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io;

import java.io.IOException;
import org.basex.io.IOContent;
import org.basex.io.IOFile;
import org.basex.io.IOUrl;
import org.basex.io.in.BufferInput;
import org.basex.util.Token;
import org.xml.sax.InputSource;

public abstract class IO {
    public static final String BASEXSUFFIX = ".basex";
    public static final String XQSUFFIX = ".xq";
    public static final String XMLSUFFIX = ".xml";
    public static final String ZIPSUFFIX = ".zip";
    public static final String CSVSUFFIX = ".csv";
    public static final String TXTSUFFIX = ".txt";
    public static final String GZSUFFIX = ".gz";
    public static final String FILEPREF = "file:";
    public static final String[] XQSUFFIXES = new String[]{".xq", ".xqm", ".xqy", ".xql", ".xquery"};
    public static final String[] ZIPSUFFIXES = new String[]{".zip", ".docx", ".pptx", ".xslx", ".odt", ".odp", ".ods", ".gz"};
    public static final String[] XMLSUFFIXES = new String[]{".xml", ".xsl", ".xslt"};
    public static final String[] HTMLSUFFIXES = new String[]{".xhtml", ".html", ".htm"};
    public static final int BLOCKSIZE = 4096;
    public static final int NODEPOWER = 4;
    public static final int NODESIZE = 16;
    public static final int ENTRIES = 256;
    public static final int MAXATTS = 31;
    public static final long OFFNUM = 0x8000000000L;
    public static final long OFFCOMP = 0x4000000000L;
    protected String path;
    protected byte[] cont;
    protected boolean more;
    protected String name;

    protected IO(String p) {
        this.init(p);
    }

    protected final void init(String p) {
        this.path = p;
        String n = p.substring(p.lastIndexOf(47) + 1);
        this.name = n.isEmpty() ? String.valueOf(Long.toString(System.currentTimeMillis())) + XMLSUFFIX : n;
    }

    public static IO get(String source) {
        if (source == null) {
            return new IOContent(Token.EMPTY);
        }
        String s = source.trim();
        if (s.startsWith("<")) {
            return new IOContent(Token.token(s));
        }
        if (!s.contains("://") || s.startsWith(FILEPREF)) {
            return new IOFile(s);
        }
        return new IOUrl(s);
    }

    public final byte[] content() throws IOException {
        if (this.cont == null) {
            this.cache();
        }
        return this.cont;
    }

    public abstract void cache() throws IOException;

    public boolean exists() {
        return true;
    }

    public boolean isDir() {
        return false;
    }

    public long date() {
        return System.currentTimeMillis();
    }

    public long length() {
        return this.cont != null ? this.cont.length : 0;
    }

    public boolean more() throws IOException {
        return this.more ^= true;
    }

    public abstract InputSource inputSource();

    public abstract BufferInput buffer() throws IOException;

    public abstract IO merge(String var1);

    public boolean archive() {
        return false;
    }

    public boolean xml() {
        return false;
    }

    public final String dbname() {
        String n = this.name();
        int i = n.lastIndexOf(".");
        return (i != -1 ? n.substring(0, i) : n).replaceAll("[^\\w-]", "");
    }

    public final String name() {
        return this.name;
    }

    public final void name(String n) {
        this.name = n;
        if (this.path.isEmpty()) {
            this.path = n;
        }
    }

    public final String path() {
        return this.path;
    }

    public String url() {
        return this.path;
    }

    public String dir() {
        return "";
    }

    public final boolean eq(IO io) {
        return this.path.equals(io.path);
    }

    public String toString() {
        return this.path;
    }
}

