/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.linked;

import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Builder;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.FingerprintedNode;
import net.sf.saxon.om.MutableNodeInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.NamespaceNode;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyAxisIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.linked.AncestorEnumeration;
import net.sf.saxon.tree.linked.AttributeEnumeration;
import net.sf.saxon.tree.linked.DescendantEnumeration;
import net.sf.saxon.tree.linked.DocumentImpl;
import net.sf.saxon.tree.linked.FollowingEnumeration;
import net.sf.saxon.tree.linked.FollowingSiblingEnumeration;
import net.sf.saxon.tree.linked.ParentNodeImpl;
import net.sf.saxon.tree.linked.PrecedingEnumeration;
import net.sf.saxon.tree.linked.PrecedingOrAncestorEnumeration;
import net.sf.saxon.tree.linked.PrecedingSiblingEnumeration;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.tree.wrapper.SiblingCountingNode;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NodeImpl
implements MutableNodeInfo,
FingerprintedNode,
SiblingCountingNode,
SourceLocator {
    private ParentNodeImpl parent;
    private int index;
    public static final char[] NODE_LETTER = new char[]{'x', 'e', 'a', 't', 'x', 'x', 'x', 'p', 'c', 'r', 'x', 'x', 'x', 'n'};

    @Override
    public CharSequence getStringValueCS() {
        return this.getStringValue();
    }

    @Override
    public int getTypeAnnotation() {
        return 630;
    }

    @Override
    public SchemaType getSchemaType() {
        return Untyped.getInstance();
    }

    @Override
    public int getColumnNumber() {
        if (this.parent == null) {
            return -1;
        }
        return this.parent.getColumnNumber();
    }

    @Override
    public String getPublicId() {
        return null;
    }

    @Override
    public long getDocumentNumber() {
        return this.getPhysicalRoot().getDocumentNumber();
    }

    @Override
    public final int getSiblingPosition() {
        return this.index;
    }

    protected final void setSiblingPosition(int index) {
        this.index = index;
    }

    @Override
    public SequenceIterator<? extends AtomicValue> getTypedValue() throws XPathException {
        SchemaType stype = this.getSchemaType();
        if (stype == Untyped.getInstance() || stype == BuiltInAtomicType.UNTYPED_ATOMIC) {
            return SingletonIterator.makeIterator(new UntypedAtomicValue(this.getStringValueCS()));
        }
        return stype.getTypedValue(this);
    }

    @Override
    public Value atomize() throws XPathException {
        SchemaType stype = this.getSchemaType();
        if (stype == Untyped.getInstance() || stype == BuiltInAtomicType.UNTYPED_ATOMIC) {
            return new UntypedAtomicValue(this.getStringValueCS());
        }
        return stype.atomize(this);
    }

    @Override
    public void setSystemId(String uri) {
        NodeInfo p = this.getParent();
        if (p != null) {
            p.setSystemId(uri);
        }
    }

    @Override
    public boolean isSameNodeInfo(NodeInfo other) {
        return this == other;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof NodeInfo && this.isSameNodeInfo((NodeInfo)other);
    }

    @Override
    public int getNameCode() {
        return -1;
    }

    @Override
    public int getFingerprint() {
        int nameCode = this.getNameCode();
        if (nameCode == -1) {
            return -1;
        }
        return nameCode & 0xFFFFF;
    }

    @Override
    public void generateId(FastStringBuffer buffer) {
        long seq = this.getSequenceNumber();
        if (seq == -1L) {
            this.getPhysicalRoot().generateId(buffer);
            buffer.append(NODE_LETTER[this.getNodeKind()]);
            buffer.append(Long.toString(seq) + "h" + this.hashCode());
        } else {
            this.parent.generateId(buffer);
            buffer.append(NODE_LETTER[this.getNodeKind()]);
            buffer.append(Integer.toString(this.index));
        }
    }

    @Override
    public String getSystemId() {
        return this.parent.getSystemId();
    }

    @Override
    public String getBaseURI() {
        return this.parent.getBaseURI();
    }

    protected long getSequenceNumber() {
        NodeImpl prev = this;
        int i = 0;
        while (true) {
            if (prev instanceof ParentNodeImpl) {
                long prevseq = prev.getSequenceNumber();
                return prevseq == -1L ? prevseq : prevseq + 65536L + (long)i;
            }
            assert (prev != null);
            prev = prev.getPreviousInDocument();
            ++i;
        }
    }

    @Override
    public final int compareOrder(NodeInfo other) {
        if (other instanceof NamespaceNode) {
            return 0 - other.compareOrder(this);
        }
        long a = this.getSequenceNumber();
        long b = ((NodeImpl)other).getSequenceNumber();
        if (a == -1L || b == -1L) {
            return Navigator.compareOrder(this, (NodeImpl)other);
        }
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        return 0;
    }

    @Override
    public Configuration getConfiguration() {
        return this.getPhysicalRoot().getConfiguration();
    }

    @Override
    public NamePool getNamePool() {
        return this.getPhysicalRoot().getNamePool();
    }

    @Override
    public String getPrefix() {
        int nameCode = this.getNameCode();
        if (nameCode == -1) {
            return "";
        }
        if (!NamePool.isPrefixed(nameCode)) {
            return "";
        }
        return this.getNamePool().getPrefix(nameCode);
    }

    @Override
    public String getURI() {
        int nameCode = this.getNameCode();
        if (nameCode == -1) {
            return "";
        }
        return this.getNamePool().getURI(nameCode);
    }

    @Override
    public String getDisplayName() {
        int nameCode = this.getNameCode();
        if (nameCode == -1) {
            return "";
        }
        return this.getNamePool().getDisplayName(nameCode);
    }

    @Override
    public String getLocalPart() {
        int nameCode = this.getNameCode();
        if (nameCode == -1) {
            return "";
        }
        return this.getNamePool().getLocalName(nameCode);
    }

    @Override
    public int getLineNumber() {
        return this.parent.getLineNumber();
    }

    @Override
    public final NodeInfo getParent() {
        if (this.parent instanceof DocumentImpl && ((DocumentImpl)this.parent).isImaginary()) {
            return null;
        }
        return this.parent;
    }

    protected final ParentNodeImpl getRawParent() {
        return this.parent;
    }

    protected final void setRawParent(ParentNodeImpl parent) {
        this.parent = parent;
    }

    public NodeInfo getPreviousSibling() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getNthChild(this.index - 1);
    }

    public NodeInfo getNextSibling() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getNthChild(this.index + 1);
    }

    public NodeInfo getFirstChild() {
        return null;
    }

    public NodeInfo getLastChild() {
        return null;
    }

    @Override
    public AxisIterator iterateAxis(byte axisNumber) {
        if (axisNumber == 3) {
            if (this instanceof ParentNodeImpl) {
                return ((ParentNodeImpl)this).enumerateChildren(null);
            }
            return EmptyAxisIterator.emptyAxisIterator();
        }
        return this.iterateAxis(axisNumber, AnyNodeTest.getInstance());
    }

    @Override
    public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
        switch (axisNumber) {
            case 0: {
                return new AncestorEnumeration(this, nodeTest, false);
            }
            case 1: {
                return new AncestorEnumeration(this, nodeTest, true);
            }
            case 2: {
                if (this.getNodeKind() != 1) {
                    return EmptyAxisIterator.emptyAxisIterator();
                }
                return new AttributeEnumeration(this, nodeTest);
            }
            case 3: {
                if (this instanceof ParentNodeImpl) {
                    return ((ParentNodeImpl)this).enumerateChildren(nodeTest);
                }
                return EmptyAxisIterator.emptyAxisIterator();
            }
            case 4: {
                if (this.getNodeKind() == 9 && nodeTest instanceof NameTest && nodeTest.getPrimitiveType() == 1) {
                    return ((DocumentImpl)this).getAllElements(nodeTest.getFingerprint());
                }
                if (this.hasChildNodes()) {
                    return new DescendantEnumeration(this, nodeTest, false);
                }
                return EmptyAxisIterator.emptyAxisIterator();
            }
            case 5: {
                return new DescendantEnumeration(this, nodeTest, true);
            }
            case 6: {
                return new FollowingEnumeration(this, nodeTest);
            }
            case 7: {
                return new FollowingSiblingEnumeration(this, nodeTest);
            }
            case 8: {
                if (this.getNodeKind() != 1) {
                    return EmptyAxisIterator.emptyAxisIterator();
                }
                return NamespaceNode.makeIterator(this, nodeTest);
            }
            case 9: {
                NodeInfo parent = this.getParent();
                if (parent == null) {
                    return EmptyAxisIterator.emptyAxisIterator();
                }
                return Navigator.filteredSingleton(parent, nodeTest);
            }
            case 10: {
                return new PrecedingEnumeration(this, nodeTest);
            }
            case 11: {
                return new PrecedingSiblingEnumeration(this, nodeTest);
            }
            case 12: {
                return Navigator.filteredSingleton(this, nodeTest);
            }
            case 13: {
                return new PrecedingOrAncestorEnumeration(this, nodeTest);
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + axisNumber);
    }

    @Override
    public String getAttributeValue(String uri, String localName) {
        return null;
    }

    @Override
    public String getAttributeValue(int fingerprint) {
        return null;
    }

    @Override
    public NodeInfo getRoot() {
        NodeInfo parent = this.getParent();
        if (parent == null) {
            return this;
        }
        return parent.getRoot();
    }

    @Override
    public DocumentInfo getDocumentRoot() {
        NodeInfo parent = this.getParent();
        if (parent == null) {
            return null;
        }
        return parent.getDocumentRoot();
    }

    public DocumentImpl getPhysicalRoot() {
        ParentNodeImpl up;
        for (up = this.parent; up != null && !(up instanceof DocumentImpl); up = up.getRawParent()) {
        }
        return (DocumentImpl)up;
    }

    public NodeImpl getNextInDocument(NodeImpl anchor) {
        NodeImpl next = (NodeImpl)this.getFirstChild();
        if (next != null) {
            return next;
        }
        if (this == anchor) {
            return null;
        }
        next = (NodeImpl)this.getNextSibling();
        if (next != null) {
            return next;
        }
        NodeImpl parent = this;
        do {
            if ((parent = (NodeImpl)parent.getParent()) == null) {
                return null;
            }
            if (parent != anchor) continue;
            return null;
        } while ((next = (NodeImpl)parent.getNextSibling()) == null);
        return next;
    }

    public NodeImpl getPreviousInDocument() {
        NodeImpl prev = (NodeImpl)this.getPreviousSibling();
        if (prev != null) {
            return prev.getLastDescendantOrSelf();
        }
        return (NodeImpl)this.getParent();
    }

    private NodeImpl getLastDescendantOrSelf() {
        NodeImpl last = (NodeImpl)this.getLastChild();
        if (last == null) {
            return this;
        }
        return last.getLastDescendantOrSelf();
    }

    @Override
    public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] buffer) {
        return null;
    }

    @Override
    public boolean hasChildNodes() {
        return this.getFirstChild() != null;
    }

    @Override
    public boolean isId() {
        return false;
    }

    @Override
    public boolean isIdref() {
        return false;
    }

    @Override
    public boolean isNilled() {
        return false;
    }

    @Override
    public void setTypeAnnotation(int typeCode) {
    }

    @Override
    public void delete() {
        if (this.parent != null) {
            this.parent.removeChild(this);
            DocumentImpl newRoot = new DocumentImpl();
            newRoot.setConfiguration(this.getConfiguration());
            newRoot.setImaginary(true);
            this.parent = newRoot;
        }
        this.index = -1;
    }

    @Override
    public boolean isDeleted() {
        return this.index == -1 || this.parent != null && this.parent.isDeleted();
    }

    @Override
    public void removeAttribute(NodeInfo attribute) {
    }

    @Override
    public void addAttribute(NodeName name, SimpleType attType, CharSequence value, int properties) {
    }

    @Override
    public void rename(NodeName newNameCode) {
    }

    @Override
    public void addNamespace(NamespaceBinding nscode, boolean inherit) {
    }

    @Override
    public void replace(NodeInfo[] replacement, boolean inherit) {
        if (this.isDeleted()) {
            throw new IllegalStateException("Cannot replace a deleted node");
        }
        if (this.getParent() == null) {
            throw new IllegalStateException("Cannot replace a parentless node");
        }
        assert (this.parent != null);
        this.parent.replaceChildrenAt(replacement, this.index, inherit);
        this.parent = null;
        this.index = -1;
    }

    @Override
    public void insertChildren(NodeInfo[] source, boolean atStart, boolean inherit) {
    }

    @Override
    public void insertSiblings(NodeInfo[] source, boolean before, boolean inherit) {
        if (this.parent == null) {
            throw new IllegalStateException("Cannot add siblings if there is no parent");
        }
        this.parent.insertChildrenAt(source, before ? this.index : this.index + 1, inherit);
    }

    @Override
    public void removeTypeAnnotation() {
    }

    @Override
    public Builder newBuilder() {
        return this.getPhysicalRoot().newBuilder();
    }
}

