/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib4;

public class XdrEncoder {
    private byte[] buf;
    private int pos = 0;
    private int maxpos = 0;
    public static final int UINT_SIZE = 4;
    public static final int INT_SIZE = 4;
    public static final int SHORT_SIZE = 4;
    public static final int LONG_SIZE = 8;

    public XdrEncoder(int maxMessageSize) {
        this.buf = new byte[maxMessageSize];
    }

    public static int calcArraySize(int arraySize) {
        if (arraySize <= 0) {
            return 4;
        }
        int mod = arraySize % 4;
        return 4 + arraySize + (mod == 0 ? 0 : 4 - mod);
    }

    public void writeUInt(long uint) {
        this.buf[this.pos++] = (byte)(uint >>> 24 & 0xFFL);
        this.buf[this.pos++] = (byte)(uint >>> 16 & 0xFFL);
        this.buf[this.pos++] = (byte)(uint >>> 8 & 0xFFL);
        this.buf[this.pos++] = (byte)(uint & 0xFFL);
    }

    public void writeShort(int s) {
        this.writeUInt(s);
    }

    public void writeLong(long l) {
        this.buf[this.pos++] = (byte)(l >> 56 & 0xFFL);
        this.buf[this.pos++] = (byte)(l >> 48 & 0xFFL);
        this.buf[this.pos++] = (byte)(l >> 40 & 0xFFL);
        this.buf[this.pos++] = (byte)(l >> 32 & 0xFFL);
        this.buf[this.pos++] = (byte)(l >> 24 & 0xFFL);
        this.buf[this.pos++] = (byte)(l >> 16 & 0xFFL);
        this.buf[this.pos++] = (byte)(l >> 8 & 0xFFL);
        this.buf[this.pos++] = (byte)(l & 0xFFL);
    }

    public void writeInt(int val) {
        this.buf[this.pos++] = (byte)(val >> 24 & 0xFF);
        this.buf[this.pos++] = (byte)(val >> 16 & 0xFF);
        this.buf[this.pos++] = (byte)(val >> 8 & 0xFF);
        this.buf[this.pos++] = (byte)(val & 0xFF);
    }

    public void writeBytes(byte[] bytes, int offset, int numBytes) {
        System.arraycopy(bytes, offset, this.buf, this.pos, numBytes);
        this.pos += numBytes;
        while (numBytes % 4 != 0) {
            this.buf[this.pos++] = 0;
            ++numBytes;
        }
    }

    public void writeBytes(byte[] bytes) {
        this.writeBytes(bytes, 0, bytes.length);
    }

    public void writeByteArray(byte[] array) {
        this.writeUInt(array.length);
        this.writeBytes(array);
    }

    public void writeUIntArray(long[] array) {
        this.writeUInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            this.writeUInt(array[i]);
        }
    }

    public int getPosition() {
        return this.pos;
    }

    public void setPosition(int newpos) {
        this.maxpos = Math.max(this.pos, this.maxpos);
        this.maxpos = Math.max(newpos, this.maxpos);
        this.pos = newpos;
    }

    public byte[] getCurrentBuffer() {
        int currLen = Math.max(this.pos, this.maxpos);
        byte[] retbuf = new byte[currLen];
        System.arraycopy(this.buf, 0, retbuf, 0, currLen);
        return retbuf;
    }

    public byte[] getCurrentBuffer(int offset, int length) {
        byte[] retbuf = new byte[length];
        System.arraycopy(this.buf, offset, retbuf, 0, length);
        return retbuf;
    }
}

