/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.entityindexer;

import java.io.File;
import nl.mpi.arbil.plugin.PluginBugCatcher;
import nl.mpi.arbil.plugin.PluginException;
import nl.mpi.arbil.plugin.PluginSessionStorage;
import nl.mpi.kinnate.entityindexer.CollectionExporter;
import nl.mpi.kinnate.entityindexer.QueryException;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.DropDB;
import org.basex.core.cmd.Open;
import org.basex.core.cmd.Set;
import org.basex.core.cmd.XQuery;

public class CollectionExport
implements CollectionExporter {
    static Context context = new Context();
    static final Object databaseLock = new Object();
    private final String databaseName = "SimpleExportTemp";
    final PluginBugCatcher bugCatcher;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CollectionExport(PluginBugCatcher bugCatcher, PluginSessionStorage sessionStorage) {
        this.bugCatcher = bugCatcher;
        try {
            Object object = databaseLock;
            synchronized (object) {
                new Set((Object)"dbpath", (Object)new File(sessionStorage.getApplicationSettingsDirectory(), "BaseXData")).execute(context);
                new Open("SimpleExportTemp").execute(context);
                new Close().execute(context);
            }
        }
        catch (BaseXException baseXException) {
            try {
                Object object = databaseLock;
                synchronized (object) {
                    new CreateDB("SimpleExportTemp").execute(context);
                }
            }
            catch (BaseXException baseXException2) {
                bugCatcher.logException(new PluginException("failed to create database: SimpleExportTemp : " + baseXException2.getMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropExportDatabase() throws BaseXException {
        Object object = databaseLock;
        synchronized (object) {
            new DropDB("SimpleExportTemp").execute(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createExportDatabase(File directoryOfInputFiles, String suffixFilter) throws QueryException {
        if (suffixFilter == null) {
            suffixFilter = "*.kmdi";
        }
        try {
            Object object = databaseLock;
            synchronized (object) {
                new DropDB("SimpleExportTemp").execute(context);
                new Set((Object)"CREATEFILTER", (Object)suffixFilter).execute(context);
                new CreateDB("SimpleExportTemp", directoryOfInputFiles.toString()).execute(context);
            }
        }
        catch (BaseXException exception) {
            throw new QueryException(exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dropAndImportCsv(File directoryOfInputFiles, String suffixFilter) throws QueryException {
        if (suffixFilter == null) {
            suffixFilter = "*.csv";
        }
        try {
            Object object = databaseLock;
            synchronized (object) {
                new DropDB("SimpleExportTemp").execute(context);
                new Set((Object)"CREATEFILTER", (Object)suffixFilter).execute(context);
                new CreateDB("SimpleExportTemp").execute(context);
                String importQuery = "declare option db:parser \"csv\";\ndeclare option db:parseropt \"header=yes\";\nfor $file in file:list(\"" + directoryOfInputFiles.toString() + "\", false(), \"" + suffixFilter + "\")\n" + "return db:add('" + "SimpleExportTemp" + "', $file)\n";
                return this.performExportQuery(importQuery);
            }
        }
        catch (BaseXException exception) {
            throw new QueryException(exception.getMessage());
        }
    }

    public String getDatabaseName() {
        return "SimpleExportTemp";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String performExportQuery(String exportQueryString) throws QueryException {
        String returnString = null;
        try {
            Object object = databaseLock;
            synchronized (object) {
                returnString = new XQuery(exportQueryString).execute(context);
            }
        }
        catch (BaseXException exception) {
            throw new QueryException(exception.getMessage());
        }
        return returnString;
    }
}

