/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Scanner;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import nl.mpi.arbil.plugin.PluginDialogHandler;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.kinnate.SavePanel;
import nl.mpi.kinnate.kintypestrings.KinTerm;
import nl.mpi.kinnate.kintypestrings.KinTermGroup;
import nl.mpi.kinnate.svg.DataStoreSvg;
import nl.mpi.kinnate.ui.KinTermTableModel;

public class KinTermPanel
extends JPanel {
    JTextField kinTypeGroupName;
    JTextField kinTypeGroupDescription;
    KinTermGroup kinTerms;
    SavePanel savePanel;
    JCheckBox autoGenerateCheckBox;
    JCheckBox showOnGraphCheckBox;
    JPanel outerPanel;
    KinTermTableModel kinTermTableModel;
    private MessageDialogHandler dialogHandler;
    final String csvHeaderString = "Kin Term, Alter Kin Type Strings, Propositus KinType Strings, Kin Term Description";

    public KinTermPanel(SavePanel savePanelLocal, KinTermGroup kinTermsLocal, MessageDialogHandler dialogHandler) {
        this.dialogHandler = dialogHandler;
        this.kinTerms = kinTermsLocal;
        this.savePanel = savePanelLocal;
        this.kinTypeGroupName = new JTextField(this.kinTerms.titleString);
        this.kinTypeGroupName.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                super.keyReleased(ke);
                KinTermPanel.this.kinTerms.titleString = ((JTextField)ke.getComponent()).getText();
                Container parentComponent = KinTermPanel.this.getParent();
                if (parentComponent instanceof JTabbedPane) {
                    ((JTabbedPane)parentComponent).setTitleAt(((JTabbedPane)parentComponent).getSelectedIndex(), KinTermPanel.this.kinTerms.titleString);
                }
                KinTermPanel.this.savePanel.setRequiresSave();
            }
        });
        this.kinTypeGroupDescription = new JTextField(this.kinTerms.descriptionString);
        this.kinTypeGroupDescription.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                super.keyReleased(ke);
                KinTermPanel.this.kinTerms.descriptionString = ((JTextField)ke.getComponent()).getText();
                KinTermPanel.this.savePanel.setRequiresSave();
            }
        });
        if (this.savePanel.getGraphPanel().dataStoreSvg.diagramMode == DataStoreSvg.DiagramMode.KinTypeQuery) {
            this.kinTerms.graphShow = false;
            this.kinTerms.graphGenerate = false;
        }
        this.showOnGraphCheckBox = new JCheckBox("Show On Graph");
        this.showOnGraphCheckBox.setSelected(this.kinTerms.graphShow);
        this.showOnGraphCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (KinTermPanel.this.savePanel.getGraphPanel().dataStoreSvg.diagramMode == DataStoreSvg.DiagramMode.KinTypeQuery) {
                    KinTermPanel.this.showOnGraphCheckBox.setSelected(false);
                    KinTermPanel.this.dialogHandler.addMessageDialogToQueue("At this stage Kin Terms can only be shown on freeform diagrams.", "Kin Terms");
                } else {
                    KinTermPanel.this.kinTerms.graphShow = KinTermPanel.this.showOnGraphCheckBox.isSelected();
                    KinTermPanel.this.savePanel.updateGraph();
                    KinTermPanel.this.savePanel.setRequiresSave();
                }
            }
        });
        this.autoGenerateCheckBox = new JCheckBox("Generate Example Entities");
        this.autoGenerateCheckBox.setSelected(this.kinTerms.graphGenerate);
        this.autoGenerateCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (KinTermPanel.this.savePanel.getGraphPanel().dataStoreSvg.diagramMode == DataStoreSvg.DiagramMode.KinTypeQuery) {
                    KinTermPanel.this.autoGenerateCheckBox.setSelected(false);
                    KinTermPanel.this.dialogHandler.addMessageDialogToQueue("Entities can only be generated on freeform diagrams.", "Kin Terms");
                } else {
                    KinTermPanel.this.kinTerms.graphGenerate = KinTermPanel.this.autoGenerateCheckBox.isSelected();
                    KinTermPanel.this.savePanel.updateGraph();
                    KinTermPanel.this.savePanel.setRequiresSave();
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.outerPanel = new JPanel();
        this.outerPanel.setLayout(new BoxLayout(this.outerPanel, 1));
        this.populateKinTermList();
        JPanel paddingPanel = new JPanel();
        paddingPanel.setLayout(new BorderLayout());
        paddingPanel.add((Component)this.outerPanel, "First");
        this.add((Component)paddingPanel, "Center");
    }

    public String getName() {
        return this.kinTerms.titleString;
    }

    private void populateKinTermList() {
        this.outerPanel.removeAll();
        this.outerPanel.add(this.kinTypeGroupName);
        this.outerPanel.add(this.kinTypeGroupDescription);
        this.outerPanel.add(this.getColourPanel());
        JPanel optionsPanel = new JPanel(new GridLayout(2, 2));
        optionsPanel.add(this.showOnGraphCheckBox);
        optionsPanel.add(this.autoGenerateCheckBox);
        optionsPanel.add(this.getDeleteKinTermGroupButton());
        JButton deleteSeletedButton = new JButton("Delete Selected");
        optionsPanel.add(deleteSeletedButton);
        this.outerPanel.add(optionsPanel);
        this.kinTermTableModel = new KinTermTableModel(this.savePanel, this.kinTerms, deleteSeletedButton);
        JTable kinTermTable = new JTable(this.kinTermTableModel);
        kinTermTable.setCellSelectionEnabled(true);
        kinTermTable.setAutoResizeMode(0);
        kinTermTable.setShowGrid(true);
        kinTermTable.setGridColor(Color.LIGHT_GRAY);
        this.outerPanel.add(new JScrollPane(kinTermTable));
    }

    private JButton getDeleteKinTermGroupButton() {
        JButton deleteGroupButton = new JButton("Delete Group");
        deleteGroupButton.setEnabled(false);
        deleteGroupButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        });
        return deleteGroupButton;
    }

    public void setDefaultKinType(String kinTypeString) {
        this.kinTermTableModel.setDefaultKinType(kinTypeString);
    }

    private JPanel getColourPanel() {
        Color initialColour;
        JPanel labelPanel = new JPanel(new GridLayout(1, 2));
        JPanel outerColourPanel = new JPanel(new BorderLayout());
        final JPanel pickerPanel = new JPanel(new BorderLayout());
        outerColourPanel.add((Component)labelPanel, "First");
        outerColourPanel.add((Component)pickerPanel, "Center");
        try {
            initialColour = Color.decode(this.kinTerms.graphColour);
        }
        catch (NumberFormatException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)exception);
            this.kinTerms.graphColour = "#0000FF";
            initialColour = Color.blue;
            this.savePanel.setRequiresSave();
        }
        labelPanel.add(new JLabel("Graph Colour"));
        final JPanel colourSquare = new JPanel();
        colourSquare.setBackground(initialColour);
        colourSquare.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                pickerPanel.removeAll();
                final JColorChooser colourChooser = new JColorChooser(colourSquare.getBackground());
                final Color revertColour = colourSquare.getBackground();
                JPanel buttonPanel = new JPanel();
                buttonPanel.setLayout(new BoxLayout(buttonPanel, 2));
                JButton cancelButton = new JButton("Cancel");
                buttonPanel.add(cancelButton);
                JButton revertButton = new JButton("Revert");
                buttonPanel.add(revertButton);
                JButton okButton = new JButton("OK");
                buttonPanel.add(okButton);
                cancelButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        colourSquare.setBackground(revertColour);
                        colourChooser.setColor(revertColour);
                        KinTermPanel.this.setColour(revertColour);
                        pickerPanel.removeAll();
                        KinTermPanel.this.revalidate();
                        KinTermPanel.this.repaint();
                    }
                });
                revertButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        colourSquare.setBackground(revertColour);
                        colourChooser.setColor(revertColour);
                        KinTermPanel.this.setColour(revertColour);
                    }
                });
                okButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        pickerPanel.removeAll();
                        KinTermPanel.this.revalidate();
                        KinTermPanel.this.repaint();
                    }
                });
                colourChooser.setPreviewPanel(new JPanel());
                colourChooser.getSelectionModel().addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent e) {
                        colourSquare.setBackground(colourChooser.getColor());
                        KinTermPanel.this.setColour(colourChooser.getColor());
                    }
                });
                pickerPanel.add((Component)colourChooser.getChooserPanels()[0], "Center");
                pickerPanel.add((Component)buttonPanel, "First");
                KinTermPanel.this.revalidate();
                KinTermPanel.this.repaint();
            }
        });
        labelPanel.add(colourSquare);
        return outerColourPanel;
    }

    private void setColour(Color desiredColour) {
        this.kinTerms.graphColour = "#" + Integer.toHexString(desiredColour.getRGB()).substring(2);
        this.savePanel.updateGraph();
        this.savePanel.setRequiresSave();
    }

    public void exportKinTerms() {
        File[] exportFile = this.dialogHandler.showFileSelectBox("Export Kin Terms", false, false, null, PluginDialogHandler.DialogueType.save, null);
        if (exportFile != null) {
            if (exportFile.length != 1) {
                this.dialogHandler.addMessageDialogToQueue("Export file not selected", "Export Kin Terms");
            } else {
                File outputFile = exportFile[0].getName().toLowerCase().endsWith(".csv") ? exportFile[0] : new File(exportFile[0].getParentFile(), exportFile[0].getName() + ".csv");
                if (exportFile[0].exists() && !this.dialogHandler.showConfirmDialogBox("Export file already exists, overwrite?", "Export Kin Terms")) {
                    return;
                }
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(outputFile);
                    OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
                    fileWriter.write("Kin Term, Alter Kin Type Strings, Propositus KinType Strings, Kin Term Description\n");
                    for (KinTerm kinTerm : this.kinTerms.getKinTerms()) {
                        fileWriter.write(this.cleanOutputValue(kinTerm.kinTerm) + "," + this.cleanOutputValue(kinTerm.alterKinTypeStrings) + "," + this.cleanOutputValue(kinTerm.propositusKinTypeStrings) + "," + this.cleanOutputValue(kinTerm.kinTermDescription) + "\n");
                    }
                    fileWriter.close();
                }
                catch (IOException exception) {
                    BugCatcherManager.getBugCatcher().logError((Exception)exception);
                }
            }
        }
    }

    String cleanOutputValue(String outputString) {
        return outputString == null ? "''" : "'" + outputString + "'";
    }

    String getCleanValue(Scanner stringTokenizer) {
        try {
            String tokenString = stringTokenizer.next();
            tokenString = tokenString.trim();
            return tokenString;
        }
        catch (NoSuchElementException exception) {
            return "";
        }
    }

    public void importKinTerms() {
        HashMap<String, 7> fileFilterMap = new HashMap<String, 7>(2);
        for (final String[] currentType : new String[][]{{"Comma-separated values", ".csv"}}) {
            fileFilterMap.put(currentType[0], new FileFilter(){

                public boolean accept(File selectedFile) {
                    String extensionLowerCase = currentType[1].toLowerCase();
                    return selectedFile.exists() && (selectedFile.isDirectory() || selectedFile.getName().toLowerCase().endsWith(extensionLowerCase));
                }

                public String getDescription() {
                    return currentType[0];
                }
            });
        }
        File[] importFiles = this.dialogHandler.showFileSelectBox("Import Kin Terms", false, true, fileFilterMap, PluginDialogHandler.DialogueType.open, null);
        if (importFiles != null) {
            if (importFiles.length == 0) {
                this.dialogHandler.addMessageDialogToQueue("No files selected for import", "Import Kin Terms");
            }
            for (File currentFile : importFiles) {
                int importCount = 0;
                try {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(currentFile), "UTF-8"));
                    String currentLine = bufferedReader.readLine();
                    if (!"Kin Term, Alter Kin Type Strings, Propositus KinType Strings, Kin Term Description".equals(currentLine)) {
                        this.dialogHandler.addMessageDialogToQueue("Incorrect csv format, nothing imported", "Import Kin Terms");
                        return;
                    }
                    while ((currentLine = bufferedReader.readLine()) != null) {
                        currentLine = currentLine.replaceFirst("^'", "");
                        currentLine = currentLine.replaceFirst("'$", "");
                        Scanner stringTokenizer = new Scanner(currentLine);
                        stringTokenizer.useDelimiter("','");
                        String kinTermString = this.getCleanValue(stringTokenizer);
                        String alterKinTypeStrings = this.getCleanValue(stringTokenizer);
                        String propositusKinTypeStrings = this.getCleanValue(stringTokenizer);
                        String kinTermDescription = this.getCleanValue(stringTokenizer);
                        KinTerm kinTerm = new KinTerm(kinTermString, kinTermDescription, alterKinTypeStrings, propositusKinTypeStrings);
                        this.kinTerms.addKinTerm(kinTerm);
                        ++importCount;
                    }
                    bufferedReader.close();
                    this.revalidate();
                    this.savePanel.updateGraph();
                    this.savePanel.setRequiresSave();
                }
                catch (IOException exception) {
                    BugCatcherManager.getBugCatcher().logError((Exception)exception);
                }
                this.kinTermTableModel.fireTableDataChanged();
                this.dialogHandler.addMessageDialogToQueue("Imported " + importCount + " kin terms", "Import Kin Terms");
            }
        }
    }
}

