/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.util.ArrayList;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.data.ContainerNode;
import nl.mpi.arbil.ui.ArbilTree;
import nl.mpi.kinnate.data.KinTreeNode;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.ui.KinDiagramPanel;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;

public class KinTree
extends ArbilTree {
    private KinDiagramPanel kinDiagramPanel;
    private GraphPanel graphPanel;
    private ArbilNode[] selectedNodeArray = new ArbilNode[0];
    private boolean updateGraphOnSelectionChange = false;

    public KinTree(KinDiagramPanel kinDiagramPanel, GraphPanel graphPanel, ContainerNode rootNode) {
        this.kinDiagramPanel = kinDiagramPanel;
        this.graphPanel = graphPanel;
        this.setModel(new DefaultTreeModel(new DefaultMutableTreeNode(rootNode), true));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
    }

    protected void putSelectionIntoPreviewTable() {
        this.selectedNodeArray = this.getAllSelectedNodes();
        ArrayList<UniqueIdentifier> identifierList = new ArrayList<UniqueIdentifier>();
        this.graphPanel.metadataPanel.removeAllArbilDataNodeRows();
        this.graphPanel.metadataPanel.removeAllEditors();
        for (ArbilNode arbilNode : this.selectedNodeArray) {
            if (arbilNode instanceof ArbilDataNode) {
                this.graphPanel.metadataPanel.addArbilDataNode((ArbilDataNode)arbilNode);
                continue;
            }
            if (!(arbilNode instanceof KinTreeNode)) continue;
            KinTreeNode kinTreeNode = (KinTreeNode)arbilNode;
            identifierList.add(kinTreeNode.getUniqueIdentifier());
            this.graphPanel.metadataPanel.addEntityDataNode(this.kinDiagramPanel, ((KinTreeNode)arbilNode).getEntityData());
        }
        this.graphPanel.metadataPanel.updateEditorPane();
        if (this.updateGraphOnSelectionChange) {
            this.kinDiagramPanel.drawGraph(identifierList.toArray(new UniqueIdentifier[0]));
        } else {
            this.graphPanel.setSelectedIds(identifierList.toArray(new UniqueIdentifier[0]));
        }
    }

    public void setUpdateGraphOnSelectionChange(boolean updateGraphOnSelectionChange) {
        this.updateGraphOnSelectionChange = updateGraphOnSelectionChange;
    }

    public ArbilNode[] getSelectedNodeArray() {
        return this.selectedNodeArray;
    }
}

