/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.svg;

import java.awt.Point;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kindata.EntityDate;
import nl.mpi.kinnate.kindata.GraphLabel;
import nl.mpi.kinnate.svg.DataStoreSvg;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.uniqueidentifiers.IdentifierException;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.svg.SVGDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntitySvg {
    protected HashMap<UniqueIdentifier, Point> entityPositions = new HashMap();
    public static final int symbolSize = 15;
    protected static final int strokeWidth = 2;
    private MessageDialogHandler dialogHandler;

    public EntitySvg(MessageDialogHandler dialogHandler) {
        this.dialogHandler = dialogHandler;
    }

    public void readEntityPositions(Node entityGroup) {
        if (entityGroup != null) {
            for (Node entityNode = entityGroup.getFirstChild(); entityNode != null; entityNode = entityNode.getNextSibling()) {
                try {
                    NamedNodeMap nodeMap = entityNode.getAttributes();
                    if (nodeMap == null) continue;
                    Node idNode = nodeMap.getNamedItem("id");
                    Node transformNode = nodeMap.getNamedItem("transform");
                    if (idNode == null || transformNode == null) continue;
                    UniqueIdentifier entityId = new UniqueIdentifier(idNode.getNodeValue());
                    String transformString = transformNode.getNodeValue();
                    transformString = transformString.replaceAll("\\s", "");
                    transformString = transformString.replace("translate(", "");
                    transformString = transformString.replace(")", "");
                    String[] stringPos = transformString.split(",");
                    this.entityPositions.put(entityId, new Point((int)Float.parseFloat(stringPos[0]), (int)Float.parseFloat(stringPos[1])));
                    continue;
                }
                catch (IdentifierException exception) {
                    this.dialogHandler.addMessageDialogToQueue("Failed to read an entity position, layout might not be preserved", "Restore Layout");
                }
            }
        }
    }

    public int insertSymbols(SVGDocument doc, String svgNameSpace) {
        Element svgRoot = doc.getDocumentElement();
        Element defsNode = doc.createElementNS(svgNameSpace, "defs");
        defsNode.setAttribute("id", "KinSymbols");
        Element blankGroup = doc.createElementNS(svgNameSpace, "g");
        blankGroup.setAttribute("id", "blank");
        Element blankNode = doc.createElementNS(svgNameSpace, "circle");
        blankNode.setAttribute("cx", Float.toString(15.5f));
        blankNode.setAttribute("cy", Float.toString(15.5f));
        blankNode.setAttribute("r", Integer.toString(14));
        blankNode.setAttribute("stroke", "none");
        blankNode.setAttribute("fill", "none");
        blankGroup.appendChild(blankNode);
        defsNode.appendChild(blankGroup);
        Element circleGroup = doc.createElementNS(svgNameSpace, "g");
        circleGroup.setAttribute("id", "circle");
        Element circleNode = doc.createElementNS(svgNameSpace, "circle");
        circleNode.setAttribute("cx", Float.toString(7.5f));
        circleNode.setAttribute("cy", Float.toString(7.5f));
        circleNode.setAttribute("r", Integer.toString(6));
        circleNode.setAttribute("stroke", "black");
        circleNode.setAttribute("stroke-width", Integer.toString(2));
        circleGroup.appendChild(circleNode);
        defsNode.appendChild(circleGroup);
        Element squareGroup = doc.createElementNS(svgNameSpace, "g");
        squareGroup.setAttribute("id", "square");
        Element squareNode = doc.createElementNS(svgNameSpace, "rect");
        squareNode.setAttribute("x", Integer.toString(2));
        squareNode.setAttribute("y", Integer.toString(2));
        squareNode.setAttribute("width", Integer.toString(11));
        squareNode.setAttribute("height", Integer.toString(11));
        squareNode.setAttribute("stroke", "black");
        squareNode.setAttribute("stroke-width", Integer.toString(2));
        squareGroup.appendChild(squareNode);
        defsNode.appendChild(squareGroup);
        svgRoot.appendChild(defsNode);
        Element squareGroup45 = doc.createElementNS(svgNameSpace, "g");
        squareGroup45.setAttribute("id", "square-45");
        Element squareNode45 = doc.createElementNS(svgNameSpace, "rect");
        squareNode45.setAttribute("transform", "rotate(-45 " + Integer.toString(7) + " " + Integer.toString(7) + ")");
        squareNode45.setAttribute("x", Integer.toString(2));
        squareNode45.setAttribute("y", Integer.toString(2));
        squareNode45.setAttribute("width", Integer.toString(11));
        squareNode45.setAttribute("height", Integer.toString(11));
        squareNode45.setAttribute("stroke", "black");
        squareNode45.setAttribute("stroke-width", Integer.toString(2));
        squareGroup45.appendChild(squareNode45);
        defsNode.appendChild(squareGroup45);
        svgRoot.appendChild(defsNode);
        Element rhombusGroup = doc.createElementNS(svgNameSpace, "g");
        rhombusGroup.setAttribute("id", "rhombus");
        Element rhombusNode = doc.createElementNS(svgNameSpace, "rect");
        rhombusNode.setAttribute("transform", "scale(1,0.5), rotate(-45 " + Integer.toString(7) + " " + Integer.toString(7) + ")");
        rhombusNode.setAttribute("x", Integer.toString(2));
        rhombusNode.setAttribute("y", Integer.toString(2));
        rhombusNode.setAttribute("width", Integer.toString(11));
        rhombusNode.setAttribute("height", Integer.toString(11));
        rhombusNode.setAttribute("stroke", "black");
        rhombusNode.setAttribute("stroke-width", Integer.toString(2));
        rhombusGroup.appendChild(rhombusNode);
        defsNode.appendChild(rhombusGroup);
        svgRoot.appendChild(defsNode);
        Element unionGroup = doc.createElementNS(svgNameSpace, "g");
        unionGroup.setAttribute("id", "union");
        Element upperNode = doc.createElementNS(svgNameSpace, "line");
        Element lowerNode = doc.createElementNS(svgNameSpace, "line");
        upperNode.setAttribute("x1", Integer.toString(0));
        upperNode.setAttribute("y1", Integer.toString(2));
        upperNode.setAttribute("x2", Integer.toString(15));
        upperNode.setAttribute("y2", Integer.toString(2));
        upperNode.setAttribute("stroke-width", Integer.toString(5));
        upperNode.setAttribute("stroke", "black");
        lowerNode.setAttribute("x1", Integer.toString(0));
        lowerNode.setAttribute("y1", Integer.toString(13));
        lowerNode.setAttribute("x2", Integer.toString(15));
        lowerNode.setAttribute("y2", Integer.toString(13));
        lowerNode.setAttribute("stroke-width", Integer.toString(5));
        lowerNode.setAttribute("stroke", "black");
        Element backgroundNode = doc.createElementNS(svgNameSpace, "rect");
        backgroundNode.setAttribute("x", "0");
        backgroundNode.setAttribute("y", "0");
        backgroundNode.setAttribute("width", Integer.toString(15));
        backgroundNode.setAttribute("height", Integer.toString(15));
        backgroundNode.setAttribute("stroke", "none");
        backgroundNode.setAttribute("fill", "white");
        unionGroup.appendChild(backgroundNode);
        unionGroup.appendChild(upperNode);
        unionGroup.appendChild(lowerNode);
        defsNode.appendChild(unionGroup);
        svgRoot.appendChild(defsNode);
        Element triangleGroup = doc.createElementNS(svgNameSpace, "g");
        triangleGroup.setAttribute("id", "triangle");
        Element triangleNode = doc.createElementNS(svgNameSpace, "polygon");
        int triangleSize = 14;
        int triangleHeight = (int)(Math.sqrt(3.0) * (double)triangleSize / 2.0);
        triangleNode.setAttribute("points", "7,1 1," + triangleHeight + " " + triangleSize + "," + triangleHeight);
        triangleNode.setAttribute("stroke", "black");
        triangleNode.setAttribute("stroke-width", Integer.toString(2));
        triangleGroup.appendChild(triangleNode);
        defsNode.appendChild(triangleGroup);
        svgRoot.appendChild(defsNode);
        Element triangleGroup1 = doc.createElementNS(svgNameSpace, "g");
        triangleGroup1.setAttribute("id", "triangle-270");
        Element triangleNode1 = doc.createElementNS(svgNameSpace, "polygon");
        triangleNode1.setAttribute("transform", "rotate(-90 " + Integer.toString(7) + " " + Integer.toString(7) + ")");
        triangleNode1.setAttribute("points", "7,1 1," + triangleHeight + " " + triangleSize + "," + triangleHeight);
        triangleNode1.setAttribute("stroke", "black");
        triangleNode1.setAttribute("stroke-width", Integer.toString(2));
        triangleGroup1.appendChild(triangleNode1);
        defsNode.appendChild(triangleGroup1);
        svgRoot.appendChild(defsNode);
        Element triangleGroup2 = doc.createElementNS(svgNameSpace, "g");
        triangleGroup2.setAttribute("id", "triangle-180");
        triangleGroup2.setAttribute("transform", "rotate(180 " + Integer.toString(7) + " " + Integer.toString(7) + ")");
        Element triangleNode2 = doc.createElementNS(svgNameSpace, "polygon");
        triangleNode2.setAttribute("points", "7,1 1," + triangleHeight + " " + triangleSize + "," + triangleHeight);
        triangleNode2.setAttribute("stroke", "black");
        triangleNode2.setAttribute("stroke-width", Integer.toString(2));
        triangleGroup2.appendChild(triangleNode2);
        defsNode.appendChild(triangleGroup2);
        svgRoot.appendChild(defsNode);
        Element triangleGroup3 = doc.createElementNS(svgNameSpace, "g");
        triangleGroup3.setAttribute("id", "triangle-90");
        triangleGroup3.setAttribute("transform", "rotate(90 " + Integer.toString(7) + " " + Integer.toString(7) + ")");
        Element triangleNode3 = doc.createElementNS(svgNameSpace, "polygon");
        triangleNode3.setAttribute("points", "7,1 1," + triangleHeight + " " + triangleSize + "," + triangleHeight);
        triangleNode3.setAttribute("stroke", "black");
        triangleNode3.setAttribute("stroke-width", Integer.toString(2));
        triangleGroup3.appendChild(triangleNode3);
        defsNode.appendChild(triangleGroup3);
        svgRoot.appendChild(defsNode);
        Element noneGroup = doc.createElementNS(svgNameSpace, "g");
        noneGroup.setAttribute("id", "error");
        Element noneNode = doc.createElementNS(svgNameSpace, "polyline");
        int posXnone = 7;
        int posYnone = 7;
        int offsetNoneAmount = 15;
        noneNode.setAttribute("points", posXnone - offsetNoneAmount + "," + (posYnone - offsetNoneAmount) + " " + (posXnone + offsetNoneAmount) + "," + (posYnone + offsetNoneAmount) + " " + posXnone + "," + posYnone + " " + (posXnone - offsetNoneAmount) + "," + (posYnone + offsetNoneAmount) + " " + (posXnone + offsetNoneAmount) + "," + (posYnone - offsetNoneAmount) + " " + (posXnone - offsetNoneAmount) + "," + (posYnone - offsetNoneAmount) + " " + (posXnone - offsetNoneAmount) + "," + (posYnone + offsetNoneAmount) + " " + (posXnone + offsetNoneAmount) + "," + (posYnone + offsetNoneAmount) + " " + (posXnone + offsetNoneAmount) + "," + (posYnone - offsetNoneAmount));
        noneNode.setAttribute("fill", "none");
        noneNode.setAttribute("stroke", "red");
        noneNode.setAttribute("stroke-width", Integer.toString(2));
        noneGroup.appendChild(noneNode);
        defsNode.appendChild(noneGroup);
        svgRoot.appendChild(defsNode);
        for (String markerColour : new String[]{"black", "orange", "cyan", "purple", "red", "green", "blue"}) {
            Element markerGroup = doc.createElementNS(svgNameSpace, "g");
            markerGroup.setAttribute("id", markerColour + "marker");
            Element markerNode = doc.createElementNS(svgNameSpace, "circle");
            markerNode.setAttribute("cx", Integer.toString(15));
            markerNode.setAttribute("cy", "0");
            markerNode.setAttribute("r", Integer.toString(3));
            markerNode.setAttribute("stroke", "none");
            markerNode.setAttribute("fill", markerColour);
            markerGroup.appendChild(markerNode);
            defsNode.appendChild(markerGroup);
            Element lineGroup = doc.createElementNS(svgNameSpace, "g");
            lineGroup.setAttribute("id", markerColour + "strikethrough");
            Element lineNode = doc.createElementNS(svgNameSpace, "polyline");
            lineNode.setAttribute("points", "0,15 15,0");
            lineNode.setAttribute("fill", "none");
            lineNode.setAttribute("stroke", markerColour);
            lineNode.setAttribute("stroke-width", Integer.toString(2));
            lineGroup.appendChild(lineNode);
            defsNode.appendChild(lineGroup);
            Element crossGroup = doc.createElementNS(svgNameSpace, "g");
            crossGroup.setAttribute("id", markerColour + "cross");
            Element crossNode = doc.createElementNS(svgNameSpace, "polyline");
            int posX = 7;
            int posY = 7;
            int offsetAmount = 7;
            crossNode.setAttribute("points", posX - offsetAmount + "," + (posY - offsetAmount) + " " + (posX + offsetAmount) + "," + (posY + offsetAmount) + " " + posX + "," + posY + " " + (posX - offsetAmount) + "," + (posY + offsetAmount) + " " + (posX + offsetAmount) + "," + (posY - offsetAmount));
            crossNode.setAttribute("fill", "none");
            crossNode.setAttribute("stroke", markerColour);
            crossNode.setAttribute("stroke-width", Integer.toString(2));
            crossGroup.appendChild(crossNode);
            defsNode.appendChild(crossGroup);
            svgRoot.appendChild(defsNode);
        }
        return 15;
    }

    public String[] listSymbolNames(SVGDocument doc, String svgNameSpace) {
        ArrayList<String> symbolArray = new ArrayList<String>();
        Element kinSymbols = doc.getElementById("KinSymbols");
        if (kinSymbols == null) {
            this.insertSymbols(doc, svgNameSpace);
            kinSymbols = doc.getElementById("KinSymbols");
        }
        for (Node kinSymbolNode = kinSymbols.getFirstChild(); kinSymbolNode != null; kinSymbolNode = kinSymbolNode.getNextSibling()) {
            Node idNode;
            NamedNodeMap attributesMap = kinSymbolNode.getAttributes();
            if (attributesMap == null || (idNode = attributesMap.getNamedItem("id")) == null) continue;
            symbolArray.add(idNode.getNodeValue());
        }
        return symbolArray.toArray(new String[0]);
    }

    public void clearEntityLocations(UniqueIdentifier[] selectedIdentifiers) {
        for (UniqueIdentifier currentIdentifier : selectedIdentifiers) {
            this.entityPositions.remove(currentIdentifier);
        }
    }

    public UniqueIdentifier getClosestEntity(float[] locationArray, int maximumDistance, ArrayList<UniqueIdentifier> excludeIdentifiers) {
        double closestDistance = -1.0;
        UniqueIdentifier closestIdentifier = null;
        for (Map.Entry<UniqueIdentifier, Point> currentEntry : this.entityPositions.entrySet()) {
            if (excludeIdentifiers.contains(currentEntry.getKey())) continue;
            float hDistance = locationArray[0] - (float)currentEntry.getValue().x;
            float vDistance = locationArray[1] - (float)currentEntry.getValue().y;
            double entityDistance = Math.sqrt(hDistance * hDistance + vDistance * vDistance);
            if (closestIdentifier == null) {
                closestDistance = entityDistance;
                closestIdentifier = currentEntry.getKey();
            }
            if (!(entityDistance < closestDistance)) continue;
            closestDistance = entityDistance;
            closestIdentifier = currentEntry.getKey();
        }
        if ((double)maximumDistance < closestDistance) {
            return null;
        }
        return closestIdentifier;
    }

    public Point[] getAllEntityLocations() {
        return this.entityPositions.values().toArray(new Point[0]);
    }

    public Point getEntityLocationOffset(UniqueIdentifier entityId) {
        Point returnLoc = this.entityPositions.get(entityId);
        if (returnLoc != null) {
            int xPos = returnLoc.x + 7;
            int yPos = returnLoc.y + 7;
            return new Point(xPos, yPos);
        }
        return null;
    }

    public Point getEntityLocation(UniqueIdentifier entityId) {
        Point returnLoc = this.entityPositions.get(entityId);
        return returnLoc;
    }

    public float[] moveEntity(GraphPanel graphPanel, UniqueIdentifier entityId, float shiftXfloat, float remainderAfterSnapX, float shiftYfloat, float remainderAfterSnapY, boolean snapToGrid, double scaleFactor, boolean allRealtionsSelected) {
        Element entitySymbol = graphPanel.doc.getElementById(entityId.getAttributeIdentifier());
        Element highlightGroup = null;
        if (entityId.isGraphicsIdentifier()) {
            highlightGroup = graphPanel.doc.getElementById("highlight_" + entityId.getAttributeIdentifier());
        }
        if (entitySymbol != null) {
            boolean allowYshift = true;
            double shiftXscaled = (double)shiftXfloat * scaleFactor;
            double shiftYscaled = (double)shiftYfloat * scaleFactor;
            Point entityPosition = this.entityPositions.get(entityId);
            float updatedPositionX = (float)((double)entityPosition.x + shiftXscaled + (double)remainderAfterSnapX);
            float updatedPositionY = entityPosition.y;
            if (allowYshift) {
                updatedPositionY = (float)((double)updatedPositionY + shiftYscaled + (double)remainderAfterSnapY);
            }
            if (snapToGrid) {
                double updatedSnapPositionX = Math.round(updatedPositionX / 50.0f) * 50;
                remainderAfterSnapX = updatedPositionX - (float)updatedSnapPositionX;
                updatedPositionX = (float)updatedSnapPositionX;
                if (allowYshift) {
                    float updatedSnapPositionY = Math.round(updatedPositionY / 50.0f) * 50;
                    remainderAfterSnapY = updatedPositionY - updatedSnapPositionY;
                    updatedPositionY = updatedSnapPositionY;
                }
            } else {
                updatedPositionX = (int)updatedPositionX;
                if (allowYshift) {
                    updatedPositionY = (int)updatedPositionY;
                }
            }
            boolean collisionFound = true;
            while (collisionFound) {
                collisionFound = false;
                for (Point currentEntity : this.entityPositions.values()) {
                    if (currentEntity.equals(entityPosition) || !(updatedPositionY > (float)(currentEntity.y - 15)) || !(updatedPositionY < (float)(currentEntity.y + 15))) continue;
                    if (updatedPositionX > (float)(currentEntity.x - 15) && updatedPositionX <= (float)currentEntity.x) {
                        collisionFound = true;
                        updatedPositionX = currentEntity.x - 15;
                        continue;
                    }
                    if (!(updatedPositionX < (float)(currentEntity.x + 15)) || !(updatedPositionX >= (float)currentEntity.x)) continue;
                    collisionFound = true;
                    updatedPositionX = currentEntity.x + 15;
                }
            }
            Point updatedLocationPoint = new Point((int)updatedPositionX, (int)updatedPositionY);
            this.entityPositions.put(entityId, updatedLocationPoint);
            graphPanel.dataStoreSvg.graphData.setPreferredEntityLocation(new UniqueIdentifier[]{entityId}, updatedLocationPoint);
            String translateString = "translate(" + String.valueOf(updatedPositionX) + ", " + String.valueOf(updatedPositionY) + ")";
            entitySymbol.setAttribute("transform", translateString);
            if (highlightGroup != null) {
                highlightGroup.setAttribute("transform", translateString);
            }
        }
        return new float[]{remainderAfterSnapX, remainderAfterSnapY};
    }

    private int addTextLabel(GraphPanel graphPanel, Element groupNode, String currentTextLable, String textColour, int textSpanCounter) {
        int lineSpacing = 15;
        Element labelText = graphPanel.doc.createElementNS(graphPanel.svgNameSpace, "text");
        labelText.setAttribute("x", Double.toString(22.5));
        labelText.setAttribute("y", Integer.toString(textSpanCounter));
        labelText.setAttribute("fill", textColour);
        labelText.setAttribute("stroke-width", "0");
        labelText.setAttribute("font-size", "14");
        Text textNode = graphPanel.doc.createTextNode(currentTextLable);
        labelText.appendChild(textNode);
        groupNode.appendChild(labelText);
        return textSpanCounter += lineSpacing;
    }

    protected Element createEntitySymbol(GraphPanel graphPanel, EntityData currentNode) {
        Point storedPosition;
        Element groupNode = graphPanel.doc.createElementNS(graphPanel.svgNameSpace, "g");
        groupNode.setAttribute("id", currentNode.getUniqueIdentifier().getAttributeIdentifier());
        groupNode.setAttributeNS(DataStoreSvg.kinDataNameSpaceLocation, "kin:path", currentNode.getEntityPath());
        groupNode.setAttributeNS(DataStoreSvg.kinDataNameSpaceLocation, "kin:kintype", currentNode.getKinTypeString());
        String[] symbolNames = currentNode.getSymbolNames();
        if (symbolNames == null || symbolNames.length == 0) {
            symbolNames = new String[]{"blank"};
        }
        if ((storedPosition = this.entityPositions.get(currentNode.getUniqueIdentifier())) == null) {
            BugCatcherManager.getBugCatcher().logError(new Exception("No storedPosition found for: " + currentNode.getUniqueIdentifier().getAttributeIdentifier()));
            storedPosition = new Point(0, 0);
            this.entityPositions.put(currentNode.getUniqueIdentifier(), storedPosition);
        }
        for (String currentSymbol : symbolNames) {
            Element symbolNode = graphPanel.doc.createElementNS(graphPanel.svgNameSpace, "use");
            symbolNode.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "#" + currentSymbol);
            groupNode.setAttribute("transform", "translate(" + Integer.toString(storedPosition.x) + ", " + Integer.toString(storedPosition.y) + ")");
            if (currentNode.isEgo) {
                symbolNode.setAttribute("fill", "black");
            } else {
                symbolNode.setAttribute("fill", "white");
            }
            symbolNode.setAttribute("stroke", "black");
            symbolNode.setAttribute("stroke-width", "2");
            groupNode.appendChild(symbolNode);
        }
        ArrayList<String> labelList = new ArrayList<String>();
        if (graphPanel.dataStoreSvg.showIdLabels && currentNode.customIdentifier != null) {
            labelList.add(currentNode.customIdentifier);
        }
        if (graphPanel.dataStoreSvg.showLabels) {
            labelList.addAll(Arrays.asList(currentNode.getLabel()));
        }
        if (graphPanel.dataStoreSvg.showKinTypeLabels) {
            labelList.addAll(Arrays.asList(currentNode.getKinTypeStringArray()));
        }
        int textSpanCounter = 0;
        if (currentNode.metadataRequiresSave) {
            textSpanCounter = this.addTextLabel(graphPanel, groupNode, "modified", "red", textSpanCounter);
        }
        for (String currentTextLable : labelList) {
            if (currentTextLable.isEmpty()) continue;
            textSpanCounter = this.addTextLabel(graphPanel, groupNode, currentTextLable, "black", textSpanCounter);
        }
        for (GraphLabel currentTextLable : currentNode.getKinTermStrings()) {
            textSpanCounter = this.addTextLabel(graphPanel, groupNode, currentTextLable.getLabelString(), currentTextLable.getColourString(), textSpanCounter);
        }
        if (graphPanel.dataStoreSvg.showDateLabels) {
            String dateColur = "blue";
            String dateString = "";
            EntityDate dob = currentNode.getDateOfBirth();
            EntityDate dod = currentNode.getDateOfDeath();
            if (dob != null && !dob.getDateString().isEmpty()) {
                dateString = dateString + dob.getDateString();
                if (!dob.dateIsValid()) {
                    dateColur = "red";
                }
            }
            if (dod != null && !dod.getDateString().isEmpty()) {
                dateString = dateString + " - " + dod.getDateString();
                if (!dod.dateIsValid()) {
                    dateColur = "red";
                }
            }
            if (dateString.length() > 0) {
                textSpanCounter = this.addTextLabel(graphPanel, groupNode, dateString, dateColur, textSpanCounter);
            }
        }
        int linkCounter = 0;
        if (graphPanel.dataStoreSvg.showArchiveLinks && currentNode.archiveLinkArray != null) {
            Element labelText = graphPanel.doc.createElementNS(graphPanel.svgNameSpace, "text");
            labelText.setAttribute("x", Double.toString(22.5));
            labelText.setAttribute("y", Integer.toString(textSpanCounter));
            labelText.setAttribute("fill", "black");
            labelText.setAttribute("stroke-width", "0");
            labelText.setAttribute("font-size", "14");
            Text textNode = graphPanel.doc.createTextNode("archive ref: ");
            labelText.appendChild(textNode);
            for (URI linkURI : currentNode.archiveLinkArray) {
                Element labelTagA = graphPanel.doc.createElementNS(graphPanel.svgNameSpace, "a");
                labelTagA.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", linkURI.toASCIIString());
                labelTagA.setAttribute("target", "_blank");
                if (++linkCounter == 1) {
                    labelTagA.appendChild(graphPanel.doc.createTextNode("" + linkCounter));
                } else {
                    labelTagA.appendChild(graphPanel.doc.createTextNode(", " + linkCounter));
                }
                labelText.appendChild(labelTagA);
            }
            groupNode.appendChild(labelText);
        }
        ((EventTarget)((Object)groupNode)).addEventListener("mousedown", graphPanel.mouseListenerSvg, false);
        return groupNode;
    }
}

