/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.kindata;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindata.EntityDate;
import nl.mpi.kinnate.kindata.EntityRelation;
import nl.mpi.kinnate.kindata.GraphLabel;
import nl.mpi.kinnate.kintypestrings.LabelStringsParser;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;

@XmlRootElement(name="Entity", namespace="http://mpi.nl/tla/kin")
public class EntityData {
    @XmlElement(name="Identifier", namespace="http://mpi.nl/tla/kin")
    private UniqueIdentifier uniqueIdentifier;
    @XmlElement(name="CustomIdentifier", namespace="http://mpi.nl/tla/kin")
    public String customIdentifier;
    @XmlElement(name="KinType", namespace="http://mpi.nl/tla/kin")
    private String[] kinTypeArray = new String[0];
    @XmlElement(name="KinTerm", namespace="http://mpi.nl/tla/kin")
    private GraphLabel[] kinTermArray = new GraphLabel[0];
    @XmlElement(name="Symbol", namespace="http://mpi.nl/tla/kin")
    private String[] symbolNames = new String[0];
    @XmlElement(name="DateOfBirth", namespace="http://mpi.nl/tla/kin")
    private EntityDate dateOfBirth = null;
    @XmlElement(name="DateOfDeath", namespace="http://mpi.nl/tla/kin")
    private EntityDate dateOfDeath = null;
    @XmlElement(name="Ego", namespace="http://mpi.nl/tla/kin")
    public boolean isEgo = false;
    @XmlElement(name="Visible", namespace="http://mpi.nl/tla/kin")
    public boolean isVisible = false;
    @XmlElement(name="Label", namespace="http://mpi.nl/tla/kin")
    private String[] labelStringArray = new String[0];
    @XmlTransient
    ArrayList<String> tempLabelsList = null;
    @XmlElementWrapper(name="Relations", namespace="http://mpi.nl/tla/kin")
    @XmlElement(name="Relation", namespace="http://mpi.nl/tla/kin")
    private EntityRelation[] relatedNodes;
    @XmlElement(name="ArchiveLink", namespace="http://mpi.nl/tla/kin")
    public URI[] archiveLinkArray = null;
    @XmlTransient
    public boolean metadataRequiresSave = false;
    @XmlTransient
    private EntityData[] visiblyRelateNodes = null;
    @XmlTransient
    private EntityData[] distinctRelateNodes = null;

    private EntityData() {
    }

    public EntityData(LabelStringsParser labelStringsParser, EntityData parentEntity, String kinTypeStringLocal, SymbolType symbolIndex, boolean isEgoLocal) {
        this.uniqueIdentifier = labelStringsParser.getUniqueIdentifier(parentEntity, kinTypeStringLocal, symbolIndex);
        this.kinTypeArray = new String[]{kinTypeStringLocal};
        this.symbolNames = new String[]{symbolIndex.name()};
        this.labelStringArray = labelStringsParser.labelsStrings;
        this.isEgo = isEgoLocal;
        this.dateOfBirth = labelStringsParser.dateOfBirth;
        this.dateOfDeath = labelStringsParser.dateOfDeath;
        this.customIdentifier = labelStringsParser.uidString;
    }

    public EntityData(UniqueIdentifier uniqueIdentifierLocal, String[] errorMessage) {
        this.uniqueIdentifier = uniqueIdentifierLocal;
        this.symbolNames = new String[]{SymbolType.error.name()};
        this.labelStringArray = errorMessage;
        this.isEgo = false;
    }

    public EntityData(UniqueIdentifier uniqueIdentifierLocal) {
        this.uniqueIdentifier = uniqueIdentifierLocal;
        this.symbolNames = new String[0];
        this.labelStringArray = null;
        this.isEgo = false;
    }

    public void addArchiveLink(URI resourceUri) {
        ArrayList<Object> linksList = this.archiveLinkArray != null ? new ArrayList<URI>(Arrays.asList(this.archiveLinkArray)) : new ArrayList<URI>();
        linksList.add(resourceUri);
        this.archiveLinkArray = linksList.toArray(new URI[0]);
    }

    public String[] getSymbolNames(String defaultSymbol) {
        if (this.symbolNames != null && this.symbolNames.length > 0) {
            return this.symbolNames;
        }
        return new String[]{defaultSymbol};
    }

    public String getFirstSymbolName() {
        String firstSymbolName = null;
        if (this.symbolNames != null && this.symbolNames.length > 0) {
            firstSymbolName = this.symbolNames[0];
        }
        return firstSymbolName;
    }

    @XmlTransient
    public EntityDate getDateOfBirth() {
        return this.dateOfBirth;
    }

    @XmlTransient
    public EntityDate getDateOfDeath() {
        return this.dateOfDeath;
    }

    public void addKinTypeString(String kinTypeString) {
        ArrayList<String> tempList = new ArrayList<String>(Arrays.asList(this.kinTypeArray));
        if (!tempList.contains(kinTypeString)) {
            tempList.add(kinTypeString);
            this.kinTypeArray = tempList.toArray(new String[0]);
        }
    }

    public String[] getKinTypeStringArray() {
        return this.kinTypeArray;
    }

    public String getKinTypeString() {
        String returnString = "";
        if (this.kinTypeArray.length > 0) {
            for (String kinType : this.kinTypeArray) {
                returnString = returnString + kinType + ",";
            }
            returnString = returnString.substring(0, returnString.length() - 1);
        }
        return returnString;
    }

    public void addKinTermString(String kinTermString, String colourString) {
        for (GraphLabel currentLabel : this.kinTermArray) {
            if (!currentLabel.getLabelString().equals(kinTermString) || !currentLabel.getColourString().equals(colourString)) continue;
            return;
        }
        ArrayList<GraphLabel> tempList = new ArrayList<GraphLabel>(Arrays.asList(this.kinTermArray));
        tempList.add(new GraphLabel(kinTermString, colourString));
        this.kinTermArray = tempList.toArray(new GraphLabel[0]);
    }

    public GraphLabel[] getKinTermStrings() {
        return this.kinTermArray;
    }

    public String[] getLabel() {
        if (this.tempLabelsList != null) {
            return this.tempLabelsList.toArray(new String[0]);
        }
        return this.labelStringArray;
    }

    public void clearTempLabels() {
        this.tempLabelsList = null;
    }

    public void appendTempLabel(String labelString) {
        if (this.tempLabelsList == null) {
            this.tempLabelsList = new ArrayList<String>(Arrays.asList(this.labelStringArray));
        }
        if (!this.tempLabelsList.contains(labelString)) {
            this.tempLabelsList.add(labelString);
        }
    }

    private void insertUnionRelations(EntityData childEntity, String dcrType, String customType) {
        for (EntityRelation entityRelation : childEntity.getAllRelations()) {
            if (!entityRelation.getRelationType().equals((Object)DataTypes.RelationType.ancestor) || entityRelation.getAlterNode().equals(this)) continue;
            entityRelation.getAlterNode().addRelatedNode(this, DataTypes.RelationType.union, null, null, dcrType, customType);
            this.addRelatedNode(entityRelation.getAlterNode(), DataTypes.RelationType.union, null, null, dcrType, customType);
        }
    }

    private void insertSiblingRelations(EntityData parentEntity, String dcrType, String customType) {
        for (EntityRelation entityRelation : parentEntity.getAllRelations()) {
            if (!entityRelation.getRelationType().equals((Object)DataTypes.RelationType.descendant) || entityRelation.getAlterNode().equals(this)) continue;
            entityRelation.getAlterNode().addRelatedNode(this, DataTypes.RelationType.sibling, null, null, dcrType, customType);
            this.addRelatedNode(entityRelation.getAlterNode(), DataTypes.RelationType.sibling, null, null, dcrType, customType);
        }
    }

    public void removeRelationsWithNode(EntityData alterNodeLocal) {
        ArrayList<EntityRelation> uniqueNodes = new ArrayList<EntityRelation>();
        if (this.relatedNodes != null) {
            for (EntityRelation nodeRelation : this.relatedNodes) {
                if (alterNodeLocal.uniqueIdentifier.equals(nodeRelation.alterUniqueIdentifier)) continue;
                uniqueNodes.add(nodeRelation);
            }
        }
        this.relatedNodes = uniqueNodes.toArray(new EntityRelation[0]);
        this.distinctRelateNodes = null;
    }

    public EntityRelation addRelatedNode(EntityData alterNodeLocal, DataTypes.RelationType relationType, String lineColour, String labelString, String dcrType, String customType) {
        EntityRelation nodeRelation = new EntityRelation(dcrType, customType, lineColour, relationType, labelString);
        nodeRelation.setAlterNode(alterNodeLocal);
        if (this.relatedNodes != null) {
            for (EntityRelation entityRelation : this.relatedNodes) {
                if (!entityRelation.equals(nodeRelation)) continue;
                return entityRelation;
            }
            ArrayList<EntityRelation> relatedNodesList = new ArrayList<EntityRelation>();
            relatedNodesList.addAll(Arrays.asList(this.relatedNodes));
            relatedNodesList.add(nodeRelation);
            this.relatedNodes = relatedNodesList.toArray(new EntityRelation[0]);
        } else {
            this.relatedNodes = new EntityRelation[]{nodeRelation};
        }
        this.distinctRelateNodes = null;
        DataTypes.RelationType opposingRelationType = DataTypes.getOpposingRelationType(relationType);
        alterNodeLocal.addRelatedNode(this, opposingRelationType, null, null, dcrType, customType);
        if (relationType.equals((Object)DataTypes.RelationType.ancestor)) {
            this.insertSiblingRelations(alterNodeLocal, dcrType, customType);
            alterNodeLocal.insertUnionRelations(this, dcrType, customType);
        } else if (relationType.equals((Object)DataTypes.RelationType.descendant)) {
            alterNodeLocal.insertSiblingRelations(this, dcrType, customType);
            this.insertUnionRelations(alterNodeLocal, dcrType, customType);
        }
        return nodeRelation;
    }

    public void clearVisibility() {
        this.isVisible = false;
        this.isEgo = false;
        this.visiblyRelateNodes = null;
        this.distinctRelateNodes = null;
    }

    public EntityData[] getVisiblyRelated() {
        if (this.visiblyRelateNodes == null) {
            ArrayList<EntityData> visiblyRelatedNodes = new ArrayList<EntityData>();
            for (EntityData entityData : this.getDistinctRelateNodes()) {
                if (entityData == null || !entityData.isVisible) continue;
                visiblyRelatedNodes.add(entityData);
            }
            this.visiblyRelateNodes = visiblyRelatedNodes.toArray(new EntityData[0]);
        }
        return this.visiblyRelateNodes;
    }

    public EntityRelation[] getAllRelations() {
        if (this.relatedNodes == null) {
            return new EntityRelation[0];
        }
        return this.relatedNodes;
    }

    public EntityData[] getDistinctRelateNodes() {
        if (this.distinctRelateNodes == null) {
            ArrayList<UniqueIdentifier> processedIds = new ArrayList<UniqueIdentifier>();
            ArrayList<EntityData> uniqueNodes = new ArrayList<EntityData>();
            if (this.relatedNodes != null) {
                for (EntityRelation nodeRelation : this.relatedNodes) {
                    if (processedIds.contains(nodeRelation.alterUniqueIdentifier)) continue;
                    uniqueNodes.add(nodeRelation.getAlterNode());
                    processedIds.add(nodeRelation.alterUniqueIdentifier);
                }
            }
            this.distinctRelateNodes = uniqueNodes.toArray(new EntityData[0]);
        }
        return this.distinctRelateNodes;
    }

    public EntityRelation[] getRelatedNodesToBeLoaded() {
        ArrayList<EntityRelation> entityRelationsToLoad = new ArrayList<EntityRelation>();
        for (EntityRelation relatedNode : this.getAllRelations()) {
            if (relatedNode.getAlterNode() != null) continue;
            entityRelationsToLoad.add(relatedNode);
        }
        return entityRelationsToLoad.toArray(new EntityRelation[0]);
    }

    public UniqueIdentifier getUniqueIdentifier() {
        return this.uniqueIdentifier;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SymbolType {
        square,
        triangle,
        circle,
        union,
        resource,
        none,
        error;

    }
}

