/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.svg.relationlines;

import java.awt.Point;
import java.util.HashSet;
import nl.mpi.kinnate.svg.relationlines.LineRecord;

public class LineLookUpTable {
    HashSet<LineRecord> lineRecords = new HashSet();
    boolean excludeFirstLastSegments = true;

    protected LineLookUpTable() {
    }

    public void getIntersectsEntity() {
    }

    public void getOverlapsOtherLine() {
    }

    protected Point[] getLineDirected(Point[] undirectedLine) {
        Point[] lineDirected = undirectedLine[0].y == undirectedLine[1].y ? (undirectedLine[0].x <= undirectedLine[1].x ? undirectedLine : new Point[]{undirectedLine[1], undirectedLine[0]}) : (undirectedLine[0].y <= undirectedLine[1].y ? undirectedLine : new Point[]{undirectedLine[1], undirectedLine[0]});
        return lineDirected;
    }

    protected boolean intersectsPoint(Point entityPoint, Point[] relationLine) {
        boolean startsBefore = relationLine[0].x <= entityPoint.x + 15;
        boolean endsBefore = relationLine[1].x <= entityPoint.x;
        boolean startsAbove = relationLine[0].y <= entityPoint.y + 15;
        boolean endsAbove = relationLine[1].y <= entityPoint.y;
        boolean intersectsResult = startsBefore != endsBefore && startsAbove != endsAbove;
        return intersectsResult;
    }

    protected boolean intersects(Point[] horizontalLine, Point[] verticalLine) {
        Point[] horizontalLineDirected = this.getLineDirected(horizontalLine);
        boolean startsBefore = horizontalLineDirected[0].x < verticalLine[0].x;
        boolean endsBefore = horizontalLineDirected[1].x <= verticalLine[0].x;
        boolean startsAbove = verticalLine[0].y < horizontalLineDirected[0].y;
        boolean endsAbove = verticalLine[1].y < horizontalLineDirected[0].y;
        boolean intersectsResult = startsBefore != endsBefore && startsAbove != endsAbove;
        return intersectsResult;
    }

    protected boolean overlaps(Point[] lineA, Point[] lineB) {
        boolean zeroLength;
        Point[] lineDirectedA = this.getLineDirected(lineA);
        Point[] lineDirectedB = this.getLineDirected(lineB);
        boolean verticalMatch = lineDirectedA[0].x == lineDirectedB[0].x && lineDirectedA[0].x == lineDirectedB[1].x && lineDirectedA[0].x == lineDirectedA[1].x;
        boolean horizontalMatch = lineDirectedA[0].y == lineDirectedB[0].y && lineDirectedA[0].y == lineDirectedB[1].y && lineDirectedA[0].y == lineDirectedA[1].y;
        int startA = lineDirectedA[0].x;
        int startB = lineDirectedB[0].x;
        int endA = lineDirectedA[1].x;
        int endB = lineDirectedB[1].x;
        if (verticalMatch) {
            startA = lineDirectedA[0].y;
            startB = lineDirectedB[0].y;
            endA = lineDirectedA[1].y;
            endB = lineDirectedB[1].y;
        }
        boolean bl = zeroLength = startA == endA || startB == endB;
        if (zeroLength) {
            return false;
        }
        if (horizontalMatch || verticalMatch) {
            if (startA <= startB && startA > endB) {
                return true;
            }
            if (startA >= startB && startA < endB) {
                return true;
            }
            if (startB <= startA && startB > endA) {
                return true;
            }
            if (startB >= startA && startB < endA) {
                return true;
            }
        }
        return false;
    }

    public void separateLinesOverlappingEntities(Point[] allEntityLocations) {
        int offset = 0;
        if (this.excludeFirstLastSegments) {
            offset = 1;
        }
        LineRecord[] lineRecordArray = this.lineRecords.toArray(new LineRecord[0]);
        for (int lineRecordCount = 0; lineRecordCount < lineRecordArray.length; ++lineRecordCount) {
            LineRecord lineRecordOuter = lineRecordArray[lineRecordCount];
            for (int currentIndexA = 0 + offset; currentIndexA <= lineRecordOuter.getLastSegment() - offset; ++currentIndexA) {
                Point[] currentSegmentA = lineRecordOuter.getSegment(currentIndexA);
                for (Point entityLocation : allEntityLocations) {
                    if (!this.intersectsPoint(entityLocation, currentSegmentA)) continue;
                    lineRecordOuter.moveAside(currentIndexA, 6);
                }
            }
        }
    }

    public void separateOverlappingLines() {
        int offset = 0;
        if (this.excludeFirstLastSegments) {
            offset = 1;
        }
        LineRecord[] lineRecordArray = this.lineRecords.toArray(new LineRecord[0]);
        for (int lineRecordCount = 0; lineRecordCount < lineRecordArray.length; ++lineRecordCount) {
            LineRecord lineRecordOuter = lineRecordArray[lineRecordCount];
            for (int currentIndexA = 0 + offset; currentIndexA <= lineRecordOuter.getLastSegment() - offset; ++currentIndexA) {
                Point[] currentSegmentA = lineRecordOuter.getSegment(currentIndexA);
                for (int lineRecordInnerCount = lineRecordCount + 1; lineRecordInnerCount < lineRecordArray.length; ++lineRecordInnerCount) {
                    LineRecord lineRecordInner;
                    if (lineRecordCount == lineRecordInnerCount || lineRecordOuter.sharesSameGroup(lineRecordInner = lineRecordArray[lineRecordInnerCount])) continue;
                    for (int currentIndexB = 0 + offset; currentIndexB <= lineRecordInner.getLastSegment() - offset; ++currentIndexB) {
                        Point[] otherHorizontalLine = lineRecordInner.getSegment(currentIndexB);
                        if (!this.overlaps(currentSegmentA, otherHorizontalLine)) continue;
                        lineRecordInner.moveAside(currentIndexB, 6);
                    }
                }
            }
        }
    }

    public void addLoops() {
        for (LineRecord lineRecordForLoops : this.lineRecords) {
            int currentHorizontal = lineRecordForLoops.getLastHorizontal();
            while (currentHorizontal > -1) {
                Point[] currentHorizontalLine = lineRecordForLoops.getSegment(currentHorizontal);
                for (LineRecord lineRecord : this.lineRecords) {
                    if (lineRecord == lineRecordForLoops || lineRecord.sharesSameGroup(lineRecordForLoops)) continue;
                    int currentVertical = lineRecord.getFirstVertical();
                    while (currentVertical > -1) {
                        Point[] currentVerticalLine = lineRecord.getSegment(currentVertical);
                        if (this.intersects(currentHorizontalLine, currentVerticalLine)) {
                            boolean isLeftHand = currentHorizontalLine[0].x > currentHorizontalLine[1].x;
                            lineRecordForLoops.insertLoop(currentHorizontal, currentVerticalLine[0].x, isLeftHand);
                        }
                        currentVertical = lineRecord.getNextVertical(currentVertical);
                    }
                }
                currentHorizontal = lineRecordForLoops.getPrevHorizontal(currentHorizontal);
            }
            lineRecordForLoops.sortLoops();
        }
    }

    public void addRecord(LineRecord lineRecord) {
        this.lineRecords.add(lineRecord);
    }
}

