/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.EventQueue;
import java.awt.Rectangle;
import java.io.File;
import javax.swing.JFrame;
import nl.mpi.arbil.util.ApplicationVersion;
import nl.mpi.arbil.util.ApplicationVersionManager;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.flap.plugin.PluginBugCatcher;
import nl.mpi.flap.plugin.PluginDialogHandler;
import nl.mpi.flap.plugin.PluginSessionStorage;
import nl.mpi.kinnate.KinOathVersion;
import nl.mpi.kinnate.KinnateArbilInjector;
import nl.mpi.kinnate.gedcomimport.ImportException;
import nl.mpi.kinnate.plugins.export.MigrationWizard;
import nl.mpi.kinnate.ui.window.AbstractDiagramManager;
import nl.mpi.kinnate.ui.window.WindowedDiagramManager;

public class MainFrame
extends JFrame {
    public MainFrame() {
        this.initComponents();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(3);
        this.pack();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ApplicationVersionManager versionManager = new ApplicationVersionManager((ApplicationVersion)new KinOathVersion());
                final KinnateArbilInjector injector = new KinnateArbilInjector();
                injector.injectHandlers(versionManager);
                final WindowedDiagramManager abstractDiagramManager = new WindowedDiagramManager(versionManager, injector.getWindowManager(), injector.getSessionStorage(), injector.getDataNodeLoader(), injector.getTreeHelper(), injector.getEntityCollection());
                abstractDiagramManager.newDiagram(new Rectangle(0, 0, 640, 480));
                ((AbstractDiagramManager)abstractDiagramManager).createApplicationWindow();
                injector.getWindowManager().setMessagesCanBeShown(true);
                new Thread(){

                    public void run() {
                        File oldAppExportFile = new MigrationWizard((PluginBugCatcher)BugCatcherManager.getBugCatcher(), (PluginDialogHandler)injector.getWindowManager(), (PluginSessionStorage)injector.getSessionStorage()).checkAndOfferMigration();
                        if (oldAppExportFile != null) {
                            try {
                                abstractDiagramManager.openImportPanel(oldAppExportFile, null);
                            }
                            catch (ImportException exception1) {
                                injector.getWindowManager().addMessageDialogToQueue(exception1.getMessage() + "\n" + oldAppExportFile.getAbsolutePath(), "Import File");
                            }
                        }
                    }
                }.start();
                versionManager.checkForUpdate();
            }
        });
    }
}

