/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.TransferHandler;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilDataNodeLoader;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.data.ContainerNode;
import nl.mpi.arbil.ui.ArbilTable;
import nl.mpi.arbil.ui.ArbilTableModel;
import nl.mpi.arbil.ui.ArbilTree;
import nl.mpi.arbil.ui.ArbilTreeController;
import nl.mpi.arbil.ui.ImageBoxRenderer;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.arbil.util.TreeHelper;
import nl.mpi.kinnate.entityindexer.EntityCollection;
import nl.mpi.kinnate.entityindexer.EntityServiceException;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.ui.HidePane;
import nl.mpi.kinnate.ui.KinDiagramPanel;
import nl.mpi.kinnate.ui.SvgElementEditor;
import nl.mpi.kinnate.ui.TableCellDragHandler;
import nl.mpi.kinnate.ui.menu.TableMenu;

public class MetadataPanel
extends JPanel {
    private ArbilTree arbilTree;
    private ArbilTableModel kinTableModel;
    private ArbilTableModel archiveTableModel;
    private JScrollPane kinTableScrollPane;
    private HidePane editorHidePane;
    private ArrayList<ArbilDataNode> metadataNodes = new ArrayList();
    private ArrayList<ArbilDataNode> archiveTreeNodes = new ArrayList();
    private ArrayList<ArbilDataNode> archiveRootNodes = new ArrayList();
    private ArrayList<SvgElementEditor> elementEditors = new ArrayList();
    private ArbilDataNodeLoader dataNodeLoader;
    private final KinDiagramPanel kinDiagramPanel;
    private ContainerNode rootNode;
    private EntityCollection entityCollection;
    private final MessageDialogHandler dialogHandler;

    public MetadataPanel(GraphPanel graphPanel, final EntityCollection entityCollection, final KinDiagramPanel kinDiagramPanel, HidePane editorHidePane, TableCellDragHandler tableCellDragHandler, ArbilDataNodeLoader dataNodeLoader, ImageBoxRenderer imageBoxRenderer, final SessionStorage sessionStorage, final MessageDialogHandler dialogHandler, ArbilTreeController treeController, TreeHelper treeHelper) {
        this.arbilTree = new ArbilTree(treeController, treeHelper, dialogHandler);
        this.kinDiagramPanel = kinDiagramPanel;
        this.entityCollection = entityCollection;
        this.dialogHandler = dialogHandler;
        this.rootNode = new ContainerNode(null, "links", null, new ArbilNode[0]);
        this.arbilTree.setModel((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode(this.rootNode)));
        this.kinTableModel = new ArbilTableModel(imageBoxRenderer);
        this.archiveTableModel = new ArbilTableModel(imageBoxRenderer);
        this.dataNodeLoader = dataNodeLoader;
        ArbilTable kinTable = new ArbilTable(this.kinTableModel, "Selected Nodes"){

            public void checkPopup(MouseEvent evt, boolean checkSelection) {
                if (evt.isPopupTrigger()) {
                    Point p = evt.getPoint();
                    int clickedRow = this.rowAtPoint(p);
                    int clickedColumn = this.columnAtPoint(p);
                    boolean clickedRowAlreadySelected = this.isRowSelected(clickedRow);
                    if (!(!checkSelection || evt.isShiftDown() || evt.isControlDown() || evt.isPopupTrigger() && clickedRowAlreadySelected || !(clickedRow > -1 & clickedRow > -1))) {
                        this.getSelectionModel().clearSelection();
                        this.changeSelection(clickedRow, clickedColumn, false, evt.isShiftDown());
                    }
                }
                if (evt.isPopupTrigger()) {
                    TableCellEditor tableCellEditor = this.getCellEditor();
                    if (tableCellEditor != null) {
                        tableCellEditor.stopCellEditing();
                    }
                    new TableMenu(sessionStorage, dialogHandler, entityCollection, kinDiagramPanel, this.getSelectedRowsFromTable(), this.getSelectedFields()).show((Component)((Object)this), evt.getX(), evt.getY());
                }
            }
        };
        ArbilTable archiveTable = new ArbilTable(this.archiveTableModel, "Selected Nodes"){};
        this.arbilTree.setCustomPreviewTable(archiveTable);
        kinTable.setTransferHandler((TransferHandler)tableCellDragHandler);
        kinTable.setDragEnabled(true);
        this.editorHidePane = editorHidePane;
        this.setLayout(new BorderLayout());
        this.kinTableScrollPane = new JScrollPane((Component)kinTable);
        JScrollPane archiveTableScrollPane = new JScrollPane((Component)archiveTable);
        this.add((Component)archiveTableScrollPane, "Center");
        this.add((Component)this.arbilTree, "Before");
    }

    public void removeAllEditors() {
        while (!this.elementEditors.isEmpty()) {
            this.editorHidePane.removeTab(this.elementEditors.remove(0));
        }
    }

    public void removeAllArbilDataNodeRows() {
        this.kinTableModel.removeAllArbilDataNodeRows();
        this.archiveTableModel.removeAllArbilDataNodeRows();
        for (ArbilDataNode arbilDataNode : this.metadataNodes) {
            if (!arbilDataNode.getParentDomNode().getNeedsSaveToDisk(false)) continue;
            this.dataNodeLoader.requestReload(arbilDataNode.getParentDomNode());
        }
        this.metadataNodes.clear();
    }

    public void addArbilDataNode(ArbilDataNode arbilDataNode) {
        this.archiveTableModel.addSingleArbilDataNode(arbilDataNode);
        this.archiveRootNodes.clear();
        this.metadataNodes.add(arbilDataNode);
    }

    public void addEntityDataNode(EntityData entityData) {
        block8: {
            try {
                String entityPath = this.entityCollection.getEntityPath(entityData.getUniqueIdentifier());
                System.out.println("entity path: " + entityPath);
                boolean metadataFileMissing = false;
                if (entityPath == null || entityPath.length() <= 0) break block8;
                try {
                    ArbilDataNode arbilDataNode = this.dataNodeLoader.getArbilDataNode(null, new URI(entityPath));
                    if (arbilDataNode.fileNotFound) {
                        metadataFileMissing = true;
                    } else {
                        this.kinDiagramPanel.registerArbilNode(entityData.getUniqueIdentifier(), arbilDataNode);
                        this.kinTableModel.addSingleArbilDataNode(arbilDataNode);
                        this.metadataNodes.add(arbilDataNode);
                        if (entityData.archiveLinkArray != null) {
                            for (URI archiveLink : entityData.archiveLinkArray) {
                                ArbilDataNode archiveLinkNode = this.dataNodeLoader.getArbilDataNode(null, archiveLink);
                                this.archiveTableModel.addSingleArbilDataNode(archiveLinkNode);
                                this.archiveTreeNodes.add(archiveLinkNode);
                                this.archiveRootNodes.add(archiveLinkNode.getParentDomNode());
                                this.metadataNodes.add(archiveLinkNode);
                            }
                        }
                    }
                }
                catch (URISyntaxException exception) {
                    BugCatcherManager.getBugCatcher().logError((Exception)exception);
                    this.dialogHandler.addMessageDialogToQueue(exception.getMessage(), "Get Entity URI");
                }
            }
            catch (EntityServiceException exception) {
                BugCatcherManager.getBugCatcher().logError((Exception)exception);
                this.dialogHandler.addMessageDialogToQueue(exception.getMessage(), "Get Entity Path");
            }
        }
    }

    public void addTab(String labelString, SvgElementEditor elementEditor) {
        this.editorHidePane.addTab(labelString, elementEditor);
        this.elementEditors.add(elementEditor);
    }

    public void removeTab(Component elementEditor) {
        this.editorHidePane.removeTab(elementEditor);
    }

    public void updateEditorPane() {
        if (this.archiveTableModel.getArbilDataNodeCount() > 0) {
            this.editorHidePane.addTab("External Links", this);
        } else {
            this.removeTab(this);
        }
        if (this.kinTableModel.getArbilDataNodeCount() > 0) {
            this.editorHidePane.addTab("Kinship Data", this.kinTableScrollPane);
            this.editorHidePane.setSelectedComponent(this.kinTableScrollPane);
        } else {
            this.removeTab(this.kinTableScrollPane);
        }
        if (!this.archiveRootNodes.isEmpty()) {
            this.rootNode.setChildNodes(this.archiveRootNodes.toArray(new ArbilNode[0]));
            this.arbilTree.requestResort();
        }
        this.arbilTree.setVisible(!this.archiveRootNodes.isEmpty());
        this.editorHidePane.setHiddeState();
    }
}

