/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui.menu;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilField;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.kinnate.entityindexer.EntityCollection;
import nl.mpi.kinnate.entityindexer.EntityServiceException;
import nl.mpi.kinnate.gedcomimport.ImportException;
import nl.mpi.kinnate.kindocument.EntityDocument;
import nl.mpi.kinnate.kindocument.ImportTranslator;
import nl.mpi.kinnate.ui.KinDiagramPanel;

public class TableMenu
extends JPopupMenu
implements ActionListener {
    private final SessionStorage sessionStorage;
    private final MessageDialogHandler dialogHandler;
    private final ArbilField[] arbilFields;
    private final ArbilDataNode[] arbilDataNodes;
    private final EntityCollection entityCollection;
    private final KinDiagramPanel kinDiagramPanel;
    final String deleteCommand = "delete";
    final String addCustomCommand = "addcustom";
    final String addCommand = "addknown";
    HashMap<ArbilDataNode, EntityDocument> documentMap = new HashMap();

    public TableMenu(SessionStorage sessionStorage, MessageDialogHandler dialogHandler, EntityCollection entityCollection, KinDiagramPanel kinDiagramPanel, ArbilDataNode[] arbilDataNodes, ArbilField[] arbilFields) {
        this.sessionStorage = sessionStorage;
        this.dialogHandler = dialogHandler;
        this.entityCollection = entityCollection;
        this.kinDiagramPanel = kinDiagramPanel;
        this.arbilDataNodes = arbilDataNodes;
        this.arbilFields = arbilFields;
        if (arbilDataNodes != null && arbilDataNodes.length > 0) {
            this.getAddMenu();
        }
        if (arbilFields != null && arbilFields.length > 0) {
            this.add(this.getDeleteMenuItem(arbilFields));
        }
    }

    private void getAddMenu() {
        int addedCounter = 0;
        JMenu addMenu = new JMenu("Add");
        try {
            for (String fieldName : this.entityCollection.getAllFieldNames()) {
                if (addedCounter > 20) {
                    this.add(addMenu);
                    addMenu = new JMenu("Add (" + fieldName.substring(0, 1) + ")");
                    addedCounter = 0;
                }
                JMenuItem addMenuItem = new JMenuItem(fieldName);
                addMenuItem.setActionCommand("addknown" + fieldName);
                addMenuItem.addActionListener(this);
                addMenu.add(addMenuItem);
                ++addedCounter;
            }
        }
        catch (EntityServiceException exception) {
            this.dialogHandler.addMessageDialogToQueue(exception.getMessage(), "Get All Field Names");
        }
        this.add(addMenu);
        JMenuItem addCustomMenuItem = new JMenuItem("Add <custom field>");
        addCustomMenuItem.setActionCommand("addcustom");
        addCustomMenuItem.addActionListener(this);
        this.add(addCustomMenuItem);
    }

    private JMenuItem getDeleteMenuItem(ArbilField[] arbilFields) {
        String deleteFieldLabel = arbilFields.length == 1 ? "Delete Field \"" + arbilFields[0].getTranslateFieldName() + "\"" : "Delete  " + arbilFields.length + " Field(s)";
        JMenuItem deleteMenuItem = new JMenuItem(deleteFieldLabel);
        deleteMenuItem.setActionCommand("delete");
        deleteMenuItem.addActionListener(this);
        return deleteMenuItem;
    }

    public void show(Component cmpnt, int i, int i1) {
        if (this.arbilDataNodes != null && this.arbilDataNodes.length > 0 || this.arbilFields != null && this.arbilFields.length > 0) {
            super.show(cmpnt, i, i1);
        }
    }

    public void actionPerformed(ActionEvent ae) {
        final String actionCommand = ae.getActionCommand();
        new Thread(){

            public void run() {
                TableMenu.this.kinDiagramPanel.showProgressBar();
                try {
                    if (actionCommand.equals("delete")) {
                        TableMenu.this.performDeleteFields();
                    } else if (actionCommand.startsWith("addknown")) {
                        TableMenu.this.performAddField(actionCommand.substring("addknown".length()));
                    } else if (actionCommand.equals("addcustom")) {
                        String userInput = null;
                        while ((userInput = JOptionPane.showInputDialog(TableMenu.this, "only alphanumeric characters are recommended", "Add Custom Field", -1)) != null && userInput.length() < 1) {
                        }
                        if (userInput != null) {
                            TableMenu.this.performAddField(userInput);
                        }
                    }
                }
                catch (ImportException exception) {
                    BugCatcherManager.getBugCatcher().logError((Exception)exception);
                    TableMenu.this.dialogHandler.addMessageDialogToQueue(exception.getMessage(), "Add/Remove Fields");
                }
                try {
                    TableMenu.this.saveAllDocuments();
                }
                catch (ImportException exception) {
                    BugCatcherManager.getBugCatcher().logError((Exception)exception);
                    TableMenu.this.dialogHandler.addMessageDialogToQueue(exception.getMessage(), "Add/Remove Fields");
                }
                TableMenu.this.kinDiagramPanel.clearProgressBar();
            }
        }.start();
    }

    private void performDeleteFields() throws ImportException {
        for (ArbilField arbilField : this.arbilFields) {
            EntityDocument entityDocument = this.getEntityDocument(arbilField.getParentDataNode());
            String tagName = arbilField.getFullXmlPath().replaceAll("\\(\\d*?\\)$", "").substring(".Kinnate.CustomData.".length());
            entityDocument.removeValue(tagName, arbilField.getFieldValue());
        }
    }

    private void performAddField(String validatedFieldName) throws ImportException {
        for (ArbilDataNode arbilDataNode : this.arbilDataNodes) {
            EntityDocument entityDocument = this.getEntityDocument(arbilDataNode);
            entityDocument.insertValue(validatedFieldName, "");
        }
    }

    private EntityDocument getEntityDocument(ArbilDataNode arbilDataNode) throws ImportException {
        if (!this.documentMap.containsKey(arbilDataNode)) {
            this.documentMap.put(arbilDataNode, new EntityDocument(arbilDataNode.getURI(), new ImportTranslator(true), this.sessionStorage));
        }
        return this.documentMap.get(arbilDataNode);
    }

    private void saveAllDocuments() throws ImportException {
        try {
            for (EntityDocument entityDocument : this.documentMap.values()) {
                entityDocument.saveDocument();
                this.entityCollection.updateDatabase(entityDocument.getFile().toURI(), entityDocument.getUniqueIdentifier());
            }
        }
        catch (EntityServiceException exception) {
            this.dialogHandler.addMessageDialogToQueue(exception.getMessage(), "Update Database");
        }
        for (ArbilDataNode arbilDataNode : this.documentMap.keySet()) {
            arbilDataNode.reloadNode();
        }
    }
}

