/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build.xml;

import java.io.IOException;
import org.basex.build.BuildException;
import org.basex.build.BuildText;
import org.basex.build.SingleParser;
import org.basex.build.xml.XMLScanner;
import org.basex.core.Prop;
import org.basex.io.IO;
import org.basex.util.Token;
import org.basex.util.list.TokenList;

public class XMLParser
extends SingleParser {
    private final boolean stripNS;
    private final XMLScanner scanner;
    private final TokenList tags = new TokenList();
    private boolean closed;

    public XMLParser(IO source, Prop pr) throws IOException {
        super(source, pr);
        this.scanner = new XMLScanner(source, pr);
        this.stripNS = pr.is(Prop.STRIPNS);
    }

    @Override
    public final void parse() throws IOException {
        this.scanner.more();
        while (true) {
            if (this.scanner.type == BuildText.Type.TEXT) {
                byte[] text = this.scanner.token.finish();
                if (!this.tags.isEmpty() || !Token.ws(text)) {
                    this.builder.text(this.scanner.token.finish());
                }
            } else if (this.scanner.type == BuildText.Type.COMMENT) {
                this.builder.comment(this.scanner.token.finish());
            } else if (this.scanner.type == BuildText.Type.PI) {
                this.builder.pi(this.scanner.token.finish());
            } else {
                if (this.scanner.type == BuildText.Type.EOF) break;
                if (this.scanner.type != BuildText.Type.DTD) {
                    if (this.closed) {
                        throw new BuildException("%: No elements allowed after closed root element.", this.det());
                    }
                    if (this.parseTag()) continue;
                    break;
                }
            }
            if (!this.scanner.more()) break;
        }
        this.scanner.close();
        this.builder.encoding(this.scanner.encoding);
        if (!this.tags.isEmpty()) {
            throw new BuildException("%: Closing element </%> expected.", this.det(), this.tags.pop());
        }
    }

    @Override
    public void close() throws IOException {
        this.scanner.close();
    }

    private boolean parseTag() throws IOException {
        if (this.scanner.type == BuildText.Type.L_BR_CLOSE) {
            this.scanner.more();
            byte[] tag = this.consumeToken(BuildText.Type.TAGNAME);
            this.skipSpace();
            byte[] open = this.tags.pop();
            if (!Token.eq(open, tag)) {
                throw new BuildException("%: </%> found, </%> expected.", this.det(), tag, open);
            }
            this.builder.endElem();
            if (this.tags.isEmpty()) {
                this.closed = true;
            }
            return this.consume(BuildText.Type.R_BR);
        }
        this.consume(BuildText.Type.L_BR);
        this.atts.reset();
        byte[] en = this.consumeToken(BuildText.Type.TAGNAME);
        if (this.stripNS) {
            en = Token.local(en);
        }
        this.skipSpace();
        while (this.scanner.type != BuildText.Type.R_BR && this.scanner.type != BuildText.Type.CLOSE_R_BR) {
            byte[] an = this.consumeToken(BuildText.Type.ATTNAME);
            this.skipSpace();
            this.consume(BuildText.Type.EQ);
            this.skipSpace();
            this.consume(BuildText.Type.QUOTE);
            byte[] av = Token.EMPTY;
            if (this.scanner.type == BuildText.Type.ATTVALUE) {
                av = this.scanner.token.finish();
                this.scanner.more();
            }
            this.consume(BuildText.Type.QUOTE);
            if (Token.startsWith(an, Token.XMLNSC)) {
                if (!this.stripNS) {
                    this.builder.startNS(Token.local(an), av);
                }
            } else if (Token.eq(an, Token.XMLNS)) {
                if (!this.stripNS) {
                    this.builder.startNS(Token.EMPTY, av);
                }
            } else {
                this.atts.add(this.stripNS ? Token.local(an) : an, av);
            }
            if (this.scanner.type == BuildText.Type.R_BR || this.scanner.type == BuildText.Type.CLOSE_R_BR) continue;
            this.consume(BuildText.Type.WS);
        }
        if (this.scanner.type == BuildText.Type.CLOSE_R_BR) {
            this.builder.emptyElem(en, this.atts);
            if (this.tags.isEmpty()) {
                this.closed = true;
            }
            return this.scanner.more();
        }
        this.builder.startElem(en, this.atts);
        this.tags.add(en);
        return this.consume(BuildText.Type.R_BR);
    }

    private boolean consume(BuildText.Type t) throws IOException {
        if (this.scanner.type == t) {
            return this.scanner.more();
        }
        throw new BuildException("%: % expected, % found.", this.det(), t.string, this.scanner.type.string);
    }

    private byte[] consumeToken(BuildText.Type t) throws IOException {
        if (this.scanner.type == t) {
            byte[] tok = this.scanner.token.finish();
            this.scanner.more();
            return tok;
        }
        throw new BuildException("%: % expected, % found.", this.det(), t.string, this.scanner.type.string);
    }

    private void skipSpace() throws IOException {
        if (this.scanner.type == BuildText.Type.WS) {
            this.scanner.more();
        }
    }

    @Override
    protected final String det() {
        return this.scanner.det();
    }

    @Override
    public final double prog() {
        return this.scanner.prog();
    }
}

