/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.parse;

import org.basex.core.Text;

public interface Commands {
    public static final String COMMANDS = "commands";
    public static final String ADD = "add";
    public static final String ALTER_DB = "alter-db";
    public static final String ALTER_USER = "alter-user";
    public static final String CHECK = "check";
    public static final String CLOSE = "close";
    public static final String COPY = "copy";
    public static final String CREATE_BACKUP = "create-backup";
    public static final String CREATE_DB = "create-db";
    public static final String CREATE_EVENT = "create-event";
    public static final String CREATE_INDEX = "create-index";
    public static final String CREATE_USER = "create-user";
    public static final String CS = "cs";
    public static final String DELETE = "delete";
    public static final String DROP_BACKUP = "drop-backup";
    public static final String DROP_DB = "drop-db";
    public static final String DROP_EVENT = "drop-event";
    public static final String DROP_INDEX = "drop-index";
    public static final String DROP_USER = "drop-user";
    public static final String EXIT = "exit";
    public static final String EXPORT = "export";
    public static final String FIND = "find";
    public static final String FLUSH = "flush";
    public static final String GET = "get";
    public static final String GRANT = "grant";
    public static final String HELP = "help";
    public static final String INFO = "info";
    public static final String INFO_DB = "info-db";
    public static final String INFO_INDEX = "info-index";
    public static final String INFO_STORAGE = "info-storage";
    public static final String KILL = "kill";
    public static final String LIST = "list";
    public static final String OPEN = "open";
    public static final String OPTIMIZE = "optimize";
    public static final String OPTIMIZE_ALL = "optimize-all";
    public static final String PASSWORD = "password";
    public static final String RENAME = "rename";
    public static final String REPLACE = "replace";
    public static final String REPO_DELETE = "repo-delete";
    public static final String REPO_INSTALL = "repo-install";
    public static final String REPO_LIST = "repo-list";
    public static final String RESTORE = "restore";
    public static final String RETRIEVE = "retrieve";
    public static final String RUN = "run";
    public static final String INSPECT = "inspect";
    public static final String SET = "set";
    public static final String SHOW_BACKUPS = "show-backups";
    public static final String SHOW_DATABASES = "show-databases";
    public static final String SHOW_EVENTS = "show-events";
    public static final String SHOW_SESSIONS = "show-sessions";
    public static final String SHOW_USERS = "show-users";
    public static final String STORE = "store";
    public static final String XQUERY = "xquery";
    public static final String PATH = "path";
    public static final String NAME = "name";
    public static final String NEWNAME = "newname";
    public static final String INPUT = "input";
    public static final String QUERY = "query";
    public static final String TYPE = "type";
    public static final String DATABASE = "database";
    public static final String OPTION = "option";
    public static final String PERMISSION = "permission";
    public static final String TARGET = "target";
    public static final String NEWPATH = "newpath";
    public static final String FILE = "file";
    public static final String VALUE = "value";
    public static final String COMMAND = "command";

    public static enum Cmd {
        ADD(Text.HELPADD),
        ALTER(Text.HELPALTER),
        CHECK(Text.HELPCHECK),
        CLOSE(Text.HELPCLOSE),
        COPY(Text.HELPCOPY),
        CREATE(Text.HELPCREATE),
        CS(Text.HELPCS),
        DELETE(Text.HELPDELETE),
        DROP(Text.HELPDROP),
        EXIT(Text.HELPEXIT),
        EXPORT(Text.HELPEXPORT),
        FIND(Text.HELPFIND),
        FLUSH(Text.HELPFLUSH),
        GET(Text.HELPGET),
        GRANT(Text.HELPGRANT),
        HELP(Text.HELPHELP),
        INFO(Text.HELPINFO),
        KILL(Text.HELPKILL),
        LIST(Text.HELPLIST),
        OPEN(Text.HELPOPEN),
        OPTIMIZE(Text.HELPOPTIMIZE),
        PASSWORD(Text.HELPPASSWORD),
        RENAME(Text.HELPRENAME),
        REPLACE(Text.HELPREPLACE),
        REPO(Text.HELPREPO),
        RESTORE(Text.HELPRESTORE),
        RETRIEVE(Text.HELPRETRIEVE),
        RUN(Text.HELPRUN),
        INSPECT(null),
        SET(Text.HELPSET),
        SHOW(Text.HELPSHOW),
        STORE(Text.HELPSTORE),
        XQUERY(Text.HELPXQUERY);

        private final String[] help;

        private Cmd(String ... h) {
            this.help = h;
        }

        public final String help(boolean detail) {
            StringBuilder sb = new StringBuilder();
            if (this.help == null) {
                if (detail) {
                    sb.append(Text.NOHELP).append(Text.NL);
                }
            } else {
                sb.append((Object)((Object)this) + " " + this.help[0] + Text.NL + "  " + this.help[1] + Text.NL);
                if (detail) {
                    sb.append(Text.NL + this.help[2] + Text.NL);
                }
            }
            return sb.toString();
        }
    }

    public static enum CmdRepo {
        INSTALL,
        DELETE,
        LIST;

    }

    public static enum CmdAlter {
        DATABASE,
        DB,
        USER;

    }

    public static enum CmdIndexInfo {
        NULL,
        TEXT,
        ATTRIBUTE,
        FULLTEXT,
        PATH,
        TAG,
        ATTNAME;

    }

    public static enum CmdIndex {
        TEXT,
        ATTRIBUTE,
        FULLTEXT;

    }

    public static enum CmdPerm {
        NONE,
        READ,
        WRITE,
        CREATE,
        ADMIN;

    }

    public static enum CmdShow {
        DATABASES,
        SESSIONS,
        USERS,
        BACKUPS,
        EVENTS;

    }

    public static enum CmdOptimize {
        NULL,
        ALL;

    }

    public static enum CmdDrop {
        DATABASE,
        DB,
        INDEX,
        USER,
        BACKUP,
        EVENT;

    }

    public static enum CmdInfo {
        NULL,
        DATABASE,
        DB,
        INDEX,
        STORAGE;

    }

    public static enum CmdCreate {
        DATABASE,
        DB,
        INDEX,
        USER,
        BACKUP,
        EVENT;

    }
}

