/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Locale;
import org.basex.build.file.CSVParser;
import org.basex.build.file.HTMLParser;
import org.basex.build.file.ParserProp;
import org.basex.build.xml.CatalogWrapper;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIProp;
import org.basex.gui.dialog.DialogExport;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXCheckBox;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXFileChooser;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXTabs;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.TableLayout;
import org.basex.io.IOFile;
import org.basex.util.Token;
import org.basex.util.list.StringList;

final class DialogParsing
extends BaseXBack {
    private final BaseXLabel label;
    private final BaseXTabs tabs;
    private final BaseXCheckBox intparse;
    private final BaseXCheckBox dtd;
    private final BaseXCheckBox chopWS;
    private final BaseXCheckBox stripNS;
    private final BaseXCheckBox usecat;
    private final BaseXTextField cfile;
    private final BaseXButton browsec;
    private final BaseXBack jsonopts;
    private final BaseXCheckBox jsonml;
    private final BaseXCombo jencoding;
    private final BaseXBack htmlopts;
    private final BaseXTextField params;
    private final BaseXBack csvopts;
    private final BaseXCheckBox header;
    private final BaseXBack separator;
    private final BaseXCombo sepcombo;
    private final BaseXTextField sepchar;
    private final BaseXCombo format;
    private final BaseXCombo cencoding;
    private final BaseXBack textopts;
    private final BaseXCheckBox lines;
    private final BaseXCombo tencoding;
    private final BaseXBack main = new BaseXBack(new TableLayout(2, 1)).border(8);
    private final GUI gui;
    private BaseXBack parseropts;
    private final BaseXBack xmlopts;
    private ParserProp props;

    public DialogParsing(BaseXDialog d, BaseXTabs t) {
        this.gui = d.gui;
        this.tabs = t;
        this.label = new BaseXLabel(" ").border(0, 0, 12, 0).large();
        Prop prop = this.gui.context.prop;
        try {
            this.props = new ParserProp(prop.get(Prop.PARSEROPT));
        }
        catch (IOException ex) {
            this.props = new ParserProp();
        }
        this.intparse = new BaseXCheckBox(Text.INT_PARSER, prop.is(Prop.INTPARSE), 0, d);
        this.dtd = new BaseXCheckBox(Text.PARSE_DTDS, prop.is(Prop.DTD), 0, d);
        this.chopWS = new BaseXCheckBox(Text.CHOP_WS, prop.is(Prop.CHOP), 0, d);
        this.stripNS = new BaseXCheckBox(Text.STRIP_NS, prop.is(Prop.STRIPNS), 0, d);
        this.cfile = new BaseXTextField(prop.get(Prop.CATFILE), d);
        this.browsec = new BaseXButton(Text.BROWSE_D, d);
        this.usecat = new BaseXCheckBox(Text.USE_CATALOG_FILE, !prop.get(Prop.CATFILE).isEmpty(), 0, d);
        this.jsonml = new BaseXCheckBox(Text.PARSE_AS_JSONML, this.props.is(ParserProp.JSONML), 0, d);
        this.params = new BaseXTextField(prop.get(Prop.HTMLOPT), d);
        this.lines = new BaseXCheckBox(Text.SPLIT_INPUT_LINES, this.props.is(ParserProp.LINES), 0, d);
        this.header = new BaseXCheckBox(Text.FIRST_LINE_HEADER, this.props.is(ParserProp.HEADER), 0, d);
        this.separator = new BaseXBack().layout(new TableLayout(1, 2, 6, 0));
        StringList sl = new StringList();
        sl.add(CSVParser.SEPARATORS).add("");
        this.sepcombo = new BaseXCombo(d, sl.toArray());
        this.separator.add(this.sepcombo);
        String f = "";
        String s = this.props.get(ParserProp.SEPARATOR);
        if (Token.eq(s, CSVParser.SEPARATORS)) {
            this.sepcombo.setSelectedItem(s);
        } else {
            this.sepcombo.setSelectedIndex(CSVParser.SEPARATORS.length);
            int ch = Token.toInt(s);
            f = ch > 0 ? String.valueOf((char)ch) : "";
        }
        this.sepchar = new BaseXTextField(f, d);
        this.separator.add(this.sepchar);
        BaseXLayout.setWidth(this.sepchar, 35);
        this.format = new BaseXCombo(d, CSVParser.FORMATS);
        this.format.setSelectedItem(this.props.get(ParserProp.FORMAT));
        String enc = this.props.get(ParserProp.ENCODING);
        this.cencoding = DialogExport.encoding(d, enc);
        this.tencoding = DialogExport.encoding(d, enc);
        this.jencoding = DialogExport.encoding(d, enc);
        this.xmlopts = new BaseXBack(new TableLayout(9, 1));
        this.htmlopts = new BaseXBack(new TableLayout(2, 1));
        this.jsonopts = new BaseXBack(new TableLayout(2, 1));
        this.csvopts = new BaseXBack(new TableLayout(2, 1));
        this.textopts = new BaseXBack(new TableLayout(2, 1));
        this.createOptionsPanels();
        this.setLayout(new TableLayout(1, 1));
        this.add(this.main);
    }

    private void createOptionsPanels() {
        BaseXBack p;
        boolean avl;
        this.xmlopts.add(this.intparse);
        this.xmlopts.add(new BaseXLabel(Text.H_INT_PARSER, true, false));
        this.xmlopts.add(this.dtd);
        this.xmlopts.add(this.stripNS);
        this.xmlopts.add(this.chopWS);
        this.xmlopts.add(new BaseXLabel(Text.H_CHOP_WS, false, false).border(0, 0, 8, 0));
        this.xmlopts.add(new BaseXLabel());
        boolean rsen = CatalogWrapper.available();
        BaseXBack fl = new BaseXBack(new TableLayout(2, 2, 8, 0));
        this.usecat.setEnabled(rsen);
        fl.add(this.usecat);
        fl.add(new BaseXLabel());
        this.cfile.setEnabled(rsen);
        fl.add(this.cfile);
        this.browsec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogParsing.this.catchoose();
            }
        });
        this.browsec.setEnabled(rsen);
        fl.add(this.browsec);
        this.xmlopts.add(fl);
        if (!rsen) {
            BaseXBack rs = new BaseXBack(new TableLayout(2, 1));
            rs.add(new BaseXLabel(Text.HELP1_USE_CATALOG).color(GUIConstants.DGRAY));
            rs.add(new BaseXLabel(Text.HELP2_USE_CATALOG).color(GUIConstants.DGRAY));
            this.xmlopts.add(rs);
        }
        this.htmlopts.add(new BaseXLabel((avl = HTMLParser.available()) ? Text.H_HTML_PARSER : Text.H_NO_HTML_PARSER).border(0, 0, 12, 0));
        if (avl) {
            p = new BaseXBack(new TableLayout(1, 2, 8, 0));
            p.add(new BaseXLabel(Text.PARAMETERS + ":", true, true));
            p.add(this.params);
            this.htmlopts.add(p);
        }
        p = new BaseXBack(new TableLayout(1, 2, 8, 4));
        p.add(new BaseXLabel(Text.ENCODING + ":", true, true));
        p.add(this.jencoding);
        this.jsonopts.add(p);
        this.jsonopts.add(this.jsonml);
        p = new BaseXBack(new TableLayout(3, 2, 8, 4));
        p.add(new BaseXLabel(Text.ENCODING + ":", true, true));
        p.add(this.cencoding);
        p.add(new BaseXLabel(Text.SEPARATOR, true, true));
        p.add(this.separator);
        p.add(new BaseXLabel(Text.XML_FORMAT, true, true));
        p.add(this.format);
        this.csvopts.add(p);
        this.csvopts.add(this.header);
        p = new BaseXBack(new TableLayout(1, 2, 8, 4));
        p.add(new BaseXLabel(Text.ENCODING + ":", true, true));
        p.add(this.tencoding);
        this.textopts.add(p);
        this.textopts.add(this.lines);
        boolean ip = this.intparse.isSelected();
        boolean uc = this.usecat.isSelected();
        this.intparse.setEnabled(!uc);
        this.usecat.setEnabled(!ip && CatalogWrapper.available());
        this.cfile.setEnabled(uc);
        this.browsec.setEnabled(uc);
    }

    void catchoose() {
        GUIProp gprop = this.gui.gprop;
        BaseXFileChooser fc = new BaseXFileChooser(Text.FILE_OR_DIR, gprop.get(GUIProp.CREATEPATH), this.gui);
        fc.addFilter("XML Documents", ".xml");
        IOFile file = fc.select(BaseXFileChooser.Mode.FDOPEN);
        if (file != null) {
            this.cfile.setText(file.path());
        }
    }

    void updateType(String type) {
        this.label.setText(type.toUpperCase(Locale.ENGLISH) + " Parser");
        if (type.equals("xml")) {
            this.parseropts = this.xmlopts;
        } else if (type.equals("html")) {
            this.parseropts = this.htmlopts;
        } else if (type.equals("json")) {
            this.parseropts = this.jsonopts;
        } else if (type.equals("csv")) {
            this.parseropts = this.csvopts;
        } else if (type.equals("text")) {
            this.parseropts = this.textopts;
        }
        this.main.removeAll();
        this.main.add(this.label);
        if (this.parseropts != null) {
            this.main.add(this.parseropts);
        }
        this.main.revalidate();
        this.tabs.setEnabledAt(1, !type.equals("raw"));
    }

    boolean action() {
        boolean ip = this.intparse.isSelected();
        boolean uc = this.usecat.isSelected();
        this.intparse.setEnabled(!uc);
        this.usecat.setEnabled(!ip && CatalogWrapper.available());
        this.cfile.setEnabled(uc);
        this.browsec.setEnabled(uc);
        int s = this.sepcombo.getSelectedIndex();
        boolean customsep = s == CSVParser.SEPARATORS.length;
        this.sepchar.setEnabled(customsep);
        return !customsep || this.sepchar.getText().length() == 1;
    }

    public void setOptions(String type) {
        BaseXCombo cb = type.equals("text") ? this.tencoding : (type.equals("json") ? this.jencoding : this.cencoding);
        this.props.set(ParserProp.ENCODING, cb.getSelectedItem().toString());
        this.props.set(ParserProp.FORMAT, this.format.getSelectedItem().toString());
        this.props.set(ParserProp.HEADER, this.header.isSelected());
        this.props.set(ParserProp.LINES, this.lines.isSelected());
        this.props.set(ParserProp.JSONML, this.jsonml.isSelected());
        this.props.set(ParserProp.SEPARATOR, this.sepcombo.getSelectedIndex() < CSVParser.SEPARATORS.length ? this.sepcombo.getSelectedItem().toString() : String.valueOf((int)this.sepchar.getText().charAt(0)));
        this.gui.set(Prop.PARSER, type);
        this.gui.set(Prop.PARSEROPT, this.props.toString());
        this.gui.set(Prop.CHOP, this.chopWS.isSelected());
        this.gui.set(Prop.STRIPNS, this.stripNS.isSelected());
        this.gui.set(Prop.DTD, this.dtd.isSelected());
        this.gui.set(Prop.INTPARSE, this.intparse.isSelected());
        this.gui.set(Prop.CATFILE, this.usecat.isSelected() ? this.cfile.getText() : "");
        this.gui.set(Prop.HTMLOPT, this.params.getText());
    }
}

