/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.table;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import org.basex.gui.GUIConstants;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXPanel;
import org.basex.util.Performance;

final class TableInput
implements Runnable {
    String text;
    private final BaseXPanel panel;
    private boolean flashing;
    private int pos;

    TableInput(BaseXPanel p, String t) {
        this.panel = p;
        this.text = t;
        this.pos = this.text.length();
        new Thread(this).start();
    }

    void stop() {
        this.text = null;
    }

    void paint(Graphics g, int x, int y, int w, int h) {
        g.setColor(GUIConstants.color4);
        g.drawRect(x, y - 1, w - 1, h);
        g.setColor(Color.black);
        g.setFont(GUIConstants.font);
        g.drawString(this.text, x + 5, y + h - 7);
        int xx = x + BaseXLayout.width(g, this.text.substring(0, this.pos)) + 5;
        if (this.flashing) {
            g.drawLine(xx, y + 1, xx, y + h - 5);
        }
    }

    void code(KeyEvent e) {
        if (BaseXKeys.ENTER.is(e) || this.text == null) {
            this.stop();
        }
        this.flashing = true;
        if (BaseXKeys.LINESTART.is(e)) {
            this.pos = 0;
        } else if (BaseXKeys.LINEEND.is(e)) {
            this.pos = this.text.length();
        } else if (BaseXKeys.PREV.is(e)) {
            this.pos = Math.max(0, this.pos - 1);
        } else if (BaseXKeys.NEXT.is(e)) {
            this.pos = Math.min(this.text.length(), this.pos + 1);
        } else if (BaseXKeys.DELPREV.is(e)) {
            if (this.pos > 0) {
                this.text = this.text.substring(0, this.pos - 1) + this.text.substring(this.pos--);
            }
        } else if (BaseXKeys.DELNEXT.is(e) && this.pos < this.text.length()) {
            this.text = this.text.substring(0, this.pos) + this.text.substring(this.pos + 1);
        }
    }

    boolean add(KeyEvent e) {
        if (BaseXKeys.DELNEXT.is(e) || BaseXKeys.DELPREV.is(e)) {
            return true;
        }
        char ch = e.getKeyChar();
        if (ch < ' ') {
            return false;
        }
        this.flashing = true;
        this.text = this.text.substring(0, this.pos) + ch + this.text.substring(this.pos);
        ++this.pos;
        return true;
    }

    @Override
    public void run() {
        while (this.text != null) {
            this.flashing ^= true;
            this.panel.repaint();
            Performance.sleep(500L);
        }
        this.flashing = false;
        this.panel.repaint();
    }
}

