/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.tree;

import java.awt.Graphics;
import org.basex.core.Context;
import org.basex.data.Data;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.view.ViewData;
import org.basex.gui.view.tree.TreeConstants;
import org.basex.gui.view.tree.TreeRect;
import org.basex.gui.view.tree.TreeSubtree;

final class TreeRects
implements TreeConstants {
    private TreeRect[][][] rects;

    TreeRects() {
    }

    double generateRects(TreeSubtree sub, Graphics g, Context c, int ds, int dw, boolean slim) {
        int[] roots = c.current().pres;
        int rl = roots.length;
        if (rl == 0) {
            return 0.0;
        }
        double w = (double)(dw - 2 - ds) / (double)rl;
        if (w < 2.0) {
            return -1.0;
        }
        this.rects = new TreeRect[rl][][];
        for (int i = 0; i < rl; ++i) {
            this.generateRects(sub, c, g, i, ds, w, slim);
        }
        return w;
    }

    private void generateRects(TreeSubtree sub, Context c, Graphics g, int rn, int ds, double dw, boolean slim) {
        int h = sub.subtreeHeight(rn);
        this.rects[rn] = new TreeRect[h][];
        for (int lv = 0; lv < h; ++lv) {
            double w = dw / (double)sub.levelSize(rn, lv);
            if (w < 2.0) {
                this.bigRectangle(rn, lv, ds, dw);
                continue;
            }
            this.normalRectangle(sub, c, g, rn, lv, ds, w, slim);
        }
    }

    private void bigRectangle(int rn, int lv, int ds, double w) {
        this.rects[rn][lv] = new TreeRect[1];
        this.rects[rn][lv][0] = new TreeRect((int)(w * (double)rn) + 2 + ds, (int)w - 2);
    }

    private void normalRectangle(TreeSubtree sub, Context c, Graphics g, int rn, int lv, int ds, double w, boolean slim) {
        int subSi = sub.levelSize(rn, lv);
        this.rects[rn][lv] = new TreeRect[subSi];
        double xx = (double)rn * w * (double)subSi + (double)ds;
        double ww = w;
        for (int i = 0; i < subSi; ++i) {
            if (slim) {
                double boxMiddle = xx + ww / 2.0;
                byte[] b = TreeRects.getText(c, rn, sub.prePerIndex(rn, lv, i));
                int o = TreeRects.calcOptimalRectWidth(g, b) + 10;
                if (o < 4) {
                    o = 4;
                }
                if (w > (double)o) {
                    xx = boxMiddle - (double)o / 2.0;
                    ww = o;
                }
            }
            this.rects[rn][lv][i] = new TreeRect((int)xx + 2, (int)ww - 2);
            xx += w;
        }
    }

    TreeRect[] getTreeRectsPerLevel(int rn, int lv) {
        return this.rects[rn][lv];
    }

    TreeRect getTreeRectPerIndex(int rn, int lv, int ix) {
        return this.rects[rn][lv][ix];
    }

    static byte[] getText(Context c, int rn, int pre) {
        Data d = c.data();
        if (pre == c.current().pres[rn]) {
            return ViewData.path(d, pre);
        }
        return ViewData.content(d, pre, false);
    }

    private static int calcOptimalRectWidth(Graphics g, byte[] b) {
        return BaseXLayout.width(g, b);
    }

    boolean bigRect(TreeSubtree sub, int rn, int lv) {
        return sub.levelSize(rn, lv) != this.rects[rn][lv].length;
    }

    int getPrePerXPos(TreeSubtree sub, int rn, int lv, int x) {
        TreeRect r = this.getTreeRectsPerLevel(rn, lv)[0];
        double ratio = (double)(x - r.x) / (double)r.w;
        int idx = (int)(ratio * (double)sub.levelSize(rn, lv));
        return sub.prePerIndex(rn, lv, idx);
    }

    TreeRect searchRect(TreeSubtree sub, int rn, int lv, int pre) {
        int i = sub.searchPreArrayPos(rn, lv, pre);
        return i < 0 ? null : (this.bigRect(sub, rn, lv) ? this.rects[rn][lv][0] : this.rects[rn][lv][i]);
    }
}

