/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.query;

import org.basex.data.FTMatch;
import org.basex.data.FTMatches;
import org.basex.index.query.IndexIterator;

public abstract class FTIndexIterator
extends IndexIterator {
    public int toknum;
    public static final FTIndexIterator FTEMPTY = new FTIndexIterator(){

        @Override
        public boolean more() {
            return false;
        }

        @Override
        public int next() {
            return 0;
        }

        @Override
        public FTMatches matches() {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }
    };

    public abstract FTMatches matches();

    public void tokenNum(byte tn) {
        this.toknum = tn;
    }

    public static FTIndexIterator union(final FTIndexIterator i1, final FTIndexIterator i2) {
        return new FTIndexIterator(){
            FTIndexIterator n;
            FTIndexIterator r;
            FTIndexIterator s;
            int c;

            @Override
            public boolean more() {
                if (this.c <= 0) {
                    FTIndexIterator fTIndexIterator = this.r = i1.more() ? i1 : null;
                }
                if (this.c >= 0) {
                    FTIndexIterator fTIndexIterator = this.s = i2.more() ? i2 : null;
                }
                this.c = this.r != null && this.s != null ? this.r.next() - this.s.next() : (this.r != null ? -1 : 1);
                this.n = this.c <= 0 ? this.r : this.s;
                return this.n != null;
            }

            @Override
            public FTMatches matches() {
                FTMatches m = this.n.matches();
                if (this.c == 0) {
                    for (FTMatch sm : this.s.matches()) {
                        m.add(sm);
                    }
                }
                return m;
            }

            @Override
            public int next() {
                return this.n.next();
            }

            @Override
            public void tokenNum(byte tn) {
                i1.toknum = tn;
                i2.toknum = tn;
            }

            @Override
            public synchronized int size() {
                return i1.size() + i2.size();
            }

            public String toString() {
                return "(" + i1 + " | " + i2 + ')';
            }
        };
    }

    public static FTIndexIterator intersect(final FTIndexIterator i1, final FTIndexIterator i2, final int dis) {
        return new FTIndexIterator(){
            FTIndexIterator r;
            FTIndexIterator s;

            @Override
            public boolean more() {
                int c = 0;
                do {
                    if (c <= 0) {
                        FTIndexIterator fTIndexIterator = this.r = i1.more() ? i1 : null;
                    }
                    if (c >= 0) {
                        FTIndexIterator fTIndexIterator = this.s = i2.more() ? i2 : null;
                    }
                    if (this.r != null && this.s != null) continue;
                    return false;
                } while ((c = this.r.next() - this.s.next()) != 0 || dis != 0 && !this.r.matches().phrase(this.s.matches(), dis));
                return true;
            }

            @Override
            public FTMatches matches() {
                return this.r.matches();
            }

            @Override
            public int next() {
                return this.r.next();
            }

            @Override
            public void tokenNum(byte tn) {
                i1.toknum = tn;
                i2.toknum = tn;
            }

            @Override
            public synchronized int size() {
                return Math.min(i1.size(), i2.size());
            }

            public String toString() {
                return "(" + i1 + " & " + i2 + ')';
            }
        };
    }
}

