/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.value;

import org.basex.core.Text;
import org.basex.data.MemData;
import org.basex.index.IndexType;
import org.basex.index.query.IndexIterator;
import org.basex.index.query.IndexToken;
import org.basex.index.stats.IndexStats;
import org.basex.index.value.MemValues;
import org.basex.util.Array;
import org.basex.util.TokenBuilder;

public final class UpdatableMemValues
extends MemValues {
    public UpdatableMemValues(MemData d) {
        super(d);
    }

    @Override
    public IndexIterator iter(IndexToken tok) {
        int[] pres;
        int s;
        final byte k = tok.type() == IndexType.TEXT ? (byte)2 : 3;
        int i = this.id(tok.get());
        if (i > 0 && (s = (pres = this.data.pre(this.ids[i], 0, this.len[i])).length) > 0) {
            return new IndexIterator(){
                int p;

                @Override
                public boolean more() {
                    return this.p < s;
                }

                @Override
                public int next() {
                    while (this.more() && UpdatableMemValues.this.data.kind(pres[this.p++]) != k) {
                    }
                    return pres[this.p - 1];
                }
            };
        }
        return IndexIterator.EMPTY;
    }

    @Override
    public byte[] info() {
        TokenBuilder tb = new TokenBuilder("- Structure: ").add("Sorted List").add(Text.NL);
        IndexStats stats = new IndexStats(this.data);
        for (int m = 1; m < this.size; ++m) {
            int oc = this.len[m];
            if (!stats.adding(oc)) continue;
            stats.add(this.key(m));
        }
        stats.print(tb);
        return tb.finish();
    }

    @Override
    public void delete(byte[] key, int id) {
        int i = this.id(key);
        if (i == 0 || this.len[i] == 0) {
            return;
        }
        int p = -1;
        while (++p < this.len[i] && this.ids[i][p] != id) {
        }
        if (p < this.len[i] - 1) {
            Array.move(this.ids[i], p + 1, -1, this.len[i] - (p + 1));
        }
        int n = i;
        this.len[n] = this.len[n] - 1;
    }
}

