/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.in;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipInputStream;
import org.basex.io.IO;
import org.basex.util.list.ByteList;

public class BufferInput
extends InputStream {
    protected final byte[] buffer;
    protected int bpos;
    protected int bsize;
    protected long length;
    protected IO input;
    private final InputStream in;
    private int bmark;
    private int read;

    public BufferInput(IO io) throws IOException {
        this(io.inputStream());
        this.length = io.length();
        this.input = io;
    }

    public BufferInput(InputStream is) {
        this(is, 4096);
    }

    public BufferInput(InputStream is, int bs) {
        this.buffer = new byte[bs];
        this.in = is;
    }

    BufferInput(byte[] buf) {
        this.buffer = buf;
        this.bsize = buf.length;
        this.length = this.bsize;
        this.in = null;
    }

    public IO io() {
        return this.input;
    }

    @Override
    public int read() throws IOException {
        return this.next();
    }

    protected int next() throws IOException {
        int blen = this.buffer.length;
        byte[] buf = this.buffer;
        if (this.bpos >= this.bsize) {
            int r;
            if (this.bsize == 0 || this.bsize == blen) {
                if (this.bsize == blen) {
                    this.bmark = -1;
                }
                this.bsize = 0;
                this.bpos = 0;
            }
            while ((r = this.in.read(buf, this.bsize, blen - this.bsize)) == 0) {
            }
            if (r < 0) {
                return -1;
            }
            this.bsize += r;
            this.read += r;
        }
        return buf[this.bpos++] & 0xFF;
    }

    public final String readString() throws IOException {
        int l;
        ByteList bl = new ByteList();
        while ((l = this.next()) > 0) {
            bl.add(l);
        }
        return bl.toString();
    }

    public final byte[] readBytes() throws IOException {
        int l;
        ByteList bl = new ByteList();
        while ((l = this.next()) > 0) {
            bl.add(l);
        }
        return bl.toArray();
    }

    @Override
    public final void close() throws IOException {
        if (this.in != null && !(this.in instanceof ZipInputStream)) {
            this.in.close();
        }
    }

    public final int size() {
        return this.read + this.bpos;
    }

    public final long length() {
        return this.length;
    }

    @Override
    public final boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int m) {
        this.bmark = this.bpos;
    }

    @Override
    public final synchronized void reset() throws IOException {
        if (this.bmark == -1) {
            throw new IOException("Mark cannot be reset.");
        }
        this.bpos = this.bmark;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] content() throws IOException {
        try {
            int ch;
            if (this.length > 0L) {
                int sl = (int)Math.min(Integer.MAX_VALUE, this.length);
                byte[] bytes = new byte[sl];
                for (int c = 0; c < sl; ++c) {
                    bytes[c] = (byte)this.next();
                }
                byte[] byArray = bytes;
                return byArray;
            }
            ByteList bl = new ByteList();
            while ((ch = this.next()) != -1) {
                bl.add(ch);
            }
            byte[] byArray = bl.toArray();
            return byArray;
        }
        finally {
            this.close();
        }
    }
}

