/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.math.BigDecimal;
import org.basex.query.QueryException;
import org.basex.query.util.Err;
import org.basex.query.value.item.ADate;
import org.basex.query.value.item.DTd;
import org.basex.query.value.item.Dat;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Dtm;
import org.basex.query.value.item.Dur;
import org.basex.query.value.item.Flt;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Tim;
import org.basex.query.value.item.YMDur;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;

public enum Calc {
    PLUS("+"){

        @Override
        public Item ev(InputInfo ii, Item a, Item b) throws QueryException {
            boolean t2;
            Type ta = a.type;
            Type tb = b.type;
            boolean t1 = ta.isNumber() || ta.isUntyped();
            boolean bl = t2 = tb.isNumber() || tb.isUntyped();
            if (t1 ^ t2) {
                this.errNum(ii, !t1 ? a : b);
            }
            if (t1 && t2) {
                Type t = 1.type(ta, tb);
                if (t == AtomType.ITR) {
                    long l1 = a.itr(ii);
                    long l2 = b.itr(ii);
                    1.checkRange(ii, (double)l1 + (double)l2);
                    return Int.get(l1 + l2);
                }
                if (t == AtomType.DBL) {
                    return Dbl.get(a.dbl(ii) + b.dbl(ii));
                }
                if (t == AtomType.FLT) {
                    return Flt.get(a.flt(ii) + b.flt(ii));
                }
                return Dec.get(a.dec(ii).add(b.dec(ii)));
            }
            if (ta == tb) {
                if (!ta.isDuration()) {
                    this.errNum(ii, !t1 ? a : b);
                }
                if (ta == AtomType.YMD) {
                    return new YMDur((YMDur)a, (YMDur)b, true);
                }
                if (ta == AtomType.DTD) {
                    return new DTd((DTd)a, (DTd)b, true);
                }
            }
            if (ta == AtomType.DTM) {
                return new Dtm((ADate)a, this.checkDur(ii, b), true, ii);
            }
            if (tb == AtomType.DTM) {
                return new Dtm((ADate)b, this.checkDur(ii, a), true, ii);
            }
            if (ta == AtomType.DAT) {
                return new Dat((ADate)a, this.checkDur(ii, b), true, ii);
            }
            if (tb == AtomType.DAT) {
                return new Dat((ADate)b, this.checkDur(ii, a), true, ii);
            }
            if (ta == AtomType.TIM && tb == AtomType.DTD) {
                return new Tim((Tim)a, (DTd)b, true, ii);
            }
            if (tb == AtomType.TIM && ta == AtomType.DTD) {
                return new Tim((Tim)b, (DTd)a, true, ii);
            }
            throw this.errType(ii, ta, tb);
        }
    }
    ,
    MINUS("-"){

        @Override
        public Item ev(InputInfo ii, Item a, Item b) throws QueryException {
            boolean t2;
            Type ta = a.type;
            Type tb = b.type;
            boolean t1 = ta.isNumber() || ta.isUntyped();
            boolean bl = t2 = tb.isNumber() || tb.isUntyped();
            if (t1 ^ t2) {
                this.errNum(ii, !t1 ? a : b);
            }
            if (t1 && t2) {
                Type t = 2.type(ta, tb);
                if (t == AtomType.ITR) {
                    long l1 = a.itr(ii);
                    long l2 = b.itr(ii);
                    2.checkRange(ii, (double)l1 - (double)l2);
                    return Int.get(l1 - l2);
                }
                if (t == AtomType.DBL) {
                    return Dbl.get(a.dbl(ii) - b.dbl(ii));
                }
                if (t == AtomType.FLT) {
                    return Flt.get(a.flt(ii) - b.flt(ii));
                }
                return Dec.get(a.dec(ii).subtract(b.dec(ii)));
            }
            if (ta == tb) {
                if (ta == AtomType.DTM || ta == AtomType.DAT || ta == AtomType.TIM) {
                    return new DTd((ADate)a, (ADate)b);
                }
                if (ta == AtomType.YMD) {
                    return new YMDur((YMDur)a, (YMDur)b, false);
                }
                if (ta == AtomType.DTD) {
                    return new DTd((DTd)a, (DTd)b, false);
                }
                this.errNum(ii, !t1 ? a : b);
            }
            if (ta == AtomType.DTM) {
                return new Dtm((ADate)a, this.checkDur(ii, b), false, ii);
            }
            if (ta == AtomType.DAT) {
                return new Dat((ADate)a, this.checkDur(ii, b), false, ii);
            }
            if (ta == AtomType.TIM && tb == AtomType.DTD) {
                return new Tim((Tim)a, (DTd)b, false, ii);
            }
            throw this.errType(ii, ta, tb);
        }
    }
    ,
    MULT("*"){

        @Override
        public Item ev(InputInfo ii, Item a, Item b) throws QueryException {
            boolean t2;
            Type ta = a.type;
            Type tb = b.type;
            if (ta == AtomType.YMD) {
                if (!tb.isNumber()) {
                    this.errNum(ii, b);
                }
                return new YMDur((Dur)a, b.dbl(ii), true, ii);
            }
            if (tb == AtomType.YMD) {
                if (!ta.isNumber()) {
                    this.errNum(ii, a);
                }
                return new YMDur((Dur)b, a.dbl(ii), true, ii);
            }
            if (ta == AtomType.DTD) {
                if (!tb.isNumber()) {
                    this.errNum(ii, b);
                }
                return new DTd((Dur)a, b.dbl(ii), true, ii);
            }
            if (tb == AtomType.DTD) {
                if (!ta.isNumber()) {
                    this.errNum(ii, a);
                }
                return new DTd((Dur)b, a.dbl(ii), true, ii);
            }
            boolean t1 = ta.isNumber() || ta.isUntyped();
            boolean bl = t2 = tb.isNumber() || tb.isUntyped();
            if (t1 ^ t2) {
                this.errType(ii, ta, tb);
            }
            if (t1 && t2) {
                Type t = 3.type(ta, tb);
                if (t == AtomType.ITR) {
                    long l1 = a.itr(ii);
                    long l2 = b.itr(ii);
                    3.checkRange(ii, (double)l1 * (double)l2);
                    return Int.get(l1 * l2);
                }
                if (t == AtomType.DBL) {
                    return Dbl.get(a.dbl(ii) * b.dbl(ii));
                }
                if (t == AtomType.FLT) {
                    return Flt.get(a.flt(ii) * b.flt(ii));
                }
                return Dec.get(a.dec(ii).multiply(b.dec(ii)));
            }
            throw this.errNum(ii, !t1 ? a : b);
        }
    }
    ,
    DIV("div"){

        @Override
        public Item ev(InputInfo ii, Item a, Item b) throws QueryException {
            Type ta = a.type;
            Type tb = b.type;
            if (ta == tb) {
                if (ta == AtomType.YMD) {
                    BigDecimal bd = BigDecimal.valueOf(((YMDur)b).ymd());
                    if (bd.equals(BigDecimal.ZERO)) {
                        Err.DATEZERO.thrw(ii, this.info());
                    }
                    return Dec.get(BigDecimal.valueOf(((YMDur)a).ymd()).divide(bd, 20, 6));
                }
                if (ta == AtomType.DTD) {
                    BigDecimal bd = ((DTd)b).dtd();
                    if (bd.equals(BigDecimal.ZERO)) {
                        Err.DATEZERO.thrw(ii, this.info());
                    }
                    return Dec.get(((DTd)a).dtd().divide(bd, 20, 6));
                }
            }
            if (ta == AtomType.YMD) {
                if (!tb.isNumber()) {
                    this.errNum(ii, b);
                }
                return new YMDur((Dur)a, b.dbl(ii), false, ii);
            }
            if (ta == AtomType.DTD) {
                if (!tb.isNumber()) {
                    this.errNum(ii, b);
                }
                return new DTd((Dur)a, b.dbl(ii), false, ii);
            }
            this.checkNum(ii, a, b);
            Type t = 4.type(ta, tb);
            if (t == AtomType.DBL) {
                return Dbl.get(a.dbl(ii) / b.dbl(ii));
            }
            if (t == AtomType.FLT) {
                return Flt.get(a.flt(ii) / b.flt(ii));
            }
            BigDecimal b1 = a.dec(ii);
            BigDecimal b2 = b.dec(ii);
            if (b2.signum() == 0) {
                Err.DIVZERO.thrw(ii, a);
            }
            int s = Math.max(18, Math.max(b1.scale(), b2.scale()));
            return Dec.get(b1.divide(b2, s, 6));
        }
    }
    ,
    IDIV("idiv"){

        @Override
        public Item ev(InputInfo ii, Item a, Item b) throws QueryException {
            double d;
            this.checkNum(ii, a, b);
            double d1 = a.dbl(ii);
            double d2 = b.dbl(ii);
            if (d2 == 0.0) {
                Err.DIVZERO.thrw(ii, a);
            }
            if (Double.isNaN(d = d1 / d2) || Double.isInfinite(d)) {
                Err.DIVFLOW.thrw(ii, d1, d2);
            }
            return Int.get(5.type(a.type, b.type) == AtomType.ITR ? a.itr(ii) / b.itr(ii) : (long)d);
        }
    }
    ,
    MOD("mod"){

        @Override
        public Item ev(InputInfo ii, Item a, Item b) throws QueryException {
            this.checkNum(ii, a, b);
            Type t = 6.type(a.type, b.type);
            if (t == AtomType.DBL) {
                return Dbl.get(a.dbl(ii) % b.dbl(ii));
            }
            if (t == AtomType.FLT) {
                return Flt.get(a.flt(ii) % b.flt(ii));
            }
            if (t == AtomType.ITR) {
                long b1 = a.itr(ii);
                long b2 = b.itr(ii);
                if (b2 == 0L) {
                    Err.DIVZERO.thrw(ii, a);
                }
                return Int.get(b1 % b2);
            }
            BigDecimal b1 = a.dec(ii);
            BigDecimal b2 = b.dec(ii);
            if (b2.signum() == 0) {
                Err.DIVZERO.thrw(ii, a);
            }
            BigDecimal q = b1.divide(b2, 0, 1);
            return Dec.get(b1.subtract(q.multiply(b2)));
        }
    };

    final String name;

    private Calc(String n2) {
        this.name = n2;
    }

    public abstract Item ev(InputInfo var1, Item var2, Item var3) throws QueryException;

    static Type type(Type a, Type b) {
        if (a == AtomType.DBL || b == AtomType.DBL || a.isUntyped() || b.isUntyped()) {
            return AtomType.DBL;
        }
        if (a == AtomType.FLT || b == AtomType.FLT) {
            return AtomType.FLT;
        }
        if (a == AtomType.DEC || b == AtomType.DEC) {
            return AtomType.DEC;
        }
        return AtomType.ITR;
    }

    final QueryException errType(InputInfo ii, Type ta, Type tb) throws QueryException {
        throw Err.CALCTYPE.thrw(ii, this.info(), ta, tb);
    }

    final QueryException errNum(InputInfo ii, Item it) throws QueryException {
        throw Err.XPTYPENUM.thrw(ii, this.info(), it.type);
    }

    final Dur checkDur(InputInfo ii, Item it) throws QueryException {
        Type ip = it.type;
        if (!ip.isDuration()) {
            Err.XPDUR.thrw(ii, this.info(), ip);
        }
        if (ip == AtomType.DUR) {
            throw Err.SIMPLDUR.thrw(ii, this.info(), it);
        }
        return (Dur)it;
    }

    final void checkNum(InputInfo ii, Item a, Item b) throws QueryException {
        Type ta = a.type;
        Type tb = b.type;
        if (!ta.isUntyped() && !ta.isNumber()) {
            this.errNum(ii, a);
        }
        if (!tb.isUntyped() && !tb.isNumber()) {
            this.errNum(ii, b);
        }
    }

    static final void checkRange(InputInfo ii, double d) throws QueryException {
        if (d < -9.223372036854776E18 || d > 9.223372036854776E18) {
            Err.RANGE.thrw(ii, d);
        }
    }

    final String info() {
        return '\'' + this.name + "' operator";
    }

    public String toString() {
        return this.name;
    }
}

