/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.io.serial.SerializerProp;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.iter.AxisMoreIter;
import org.basex.query.path.ExtTest;
import org.basex.query.util.Err;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.map.Map;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.TokenMap;

public final class FuncParams {
    public static final QNm Q_SPARAM = new QNm("serialization-parameters", QueryText.OUTPUTURI);
    private static final QNm A_VALUE = new QNm("value");
    private final QNm root;
    private final ExtTest test;
    private final InputInfo info;

    public FuncParams(QNm name, InputInfo ii) {
        this.test = new ExtTest(NodeType.ELM, name);
        this.root = name;
        this.info = ii;
    }

    public TokenMap parse(Item it) throws QueryException {
        ANode n;
        if (it instanceof Map) {
            return ((Map)it).tokenJavaMap(this.info);
        }
        TokenMap tm = new TokenMap();
        if (it == null) {
            return tm;
        }
        if (!this.test.eq(it)) {
            Err.ELMMAPTYPE.thrw(this.info, this.root, it.type);
        }
        AxisMoreIter ai = ((ANode)it).children();
        while ((n = ai.next()) != null) {
            byte[] o;
            if (n.type != NodeType.ELM) continue;
            QNm qn = n.qname();
            if (!Token.eq(qn.uri(), this.root.uri())) {
                Err.ELMOPTION.thrw(this.info, n);
            }
            byte[] key = qn.local();
            byte[] val = n.attribute(A_VALUE);
            if (val == null) {
                val = n.string();
            }
            if ((o = tm.get(key)) != null) {
                val = new TokenBuilder(o).add(44).add(val).finish();
            }
            tm.add(key, val);
        }
        return tm;
    }

    public static SerializerProp serializerProp(Item it) throws QueryException {
        TokenBuilder tb = new TokenBuilder();
        if (it != null) {
            TokenMap map = new FuncParams(Q_SPARAM, null).parse(it);
            for (byte[] key : map) {
                tb.add(key).add(61).add(map.get(key)).add(44);
            }
        }
        return new SerializerProp(tb.toString());
    }
}

