/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.iter;

import java.util.Arrays;
import org.basex.data.Data;
import org.basex.query.iter.AxisIter;
import org.basex.query.value.Value;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.type.NodeType;
import org.basex.util.Array;
import org.basex.util.Util;

public final class NodeSeqBuilder
extends AxisIter {
    public ANode[] item;
    private int size;
    private int pos = -1;
    private boolean sort;
    private boolean check;

    public NodeSeqBuilder() {
        this.item = new ANode[1];
    }

    public NodeSeqBuilder(ANode[] it, int s) {
        this.item = it;
        this.size = s;
    }

    public NodeSeqBuilder check() {
        this.check = true;
        return this;
    }

    public ANode get(int i) {
        return this.item[i];
    }

    public void delete(int p) {
        Array.move(this.item, p + 1, -1, --this.size - p);
    }

    public void add(ANode n) {
        if (this.size == this.item.length) {
            ANode[] tmp = new ANode[Array.newSize(this.size)];
            System.arraycopy(this.item, 0, tmp, 0, this.size);
            this.item = tmp;
        }
        if (this.check && !this.sort && this.size != 0) {
            this.sort = this.item[this.size - 1].diff(n) > 0;
        }
        this.item[this.size++] = n;
    }

    @Override
    public boolean reset() {
        this.pos = -1;
        return true;
    }

    @Override
    public ANode next() {
        if (this.check) {
            this.sort(this.sort);
        }
        return ++this.pos < this.size ? this.item[this.pos] : null;
    }

    @Override
    public ANode get(long i) {
        return i < (long)this.size ? this.item[(int)i] : null;
    }

    @Override
    public long size() {
        return this.size;
    }

    public void size(int s) {
        this.size = s;
    }

    @Override
    public Value value() {
        if (this.check) {
            this.sort(this.sort);
        }
        return Seq.get(this.item, this.size, NodeType.NOD);
    }

    public boolean dbnodes() {
        Data data;
        if (this.check) {
            this.sort(this.sort);
        }
        Data data2 = data = this.size > 0 ? this.item[0].data() : null;
        if (data == null) {
            return false;
        }
        for (int s = 1; s < this.size; ++s) {
            if (data == this.item[s].data()) continue;
            return false;
        }
        return true;
    }

    public int indexOf(ANode node, boolean db) {
        if (db) {
            return node instanceof DBNode ? Math.max(this.binarySearch((DBNode)node, 0, this.size), -1) : -1;
        }
        int s = 0;
        while ((long)s < this.size()) {
            if (this.item[s].is(node)) {
                return s;
            }
            ++s;
        }
        return -1;
    }

    public int binarySearch(DBNode nd, int start, int length) {
        if (this.size == 0 || nd.data != this.item[0].data()) {
            return -start - 1;
        }
        int l = start;
        int r = start + length - 1;
        while (l <= r) {
            int m = l + r >>> 1;
            int npre = ((DBNode)this.item[m]).pre;
            if (npre == nd.pre) {
                return m;
            }
            if (npre < nd.pre) {
                l = m + 1;
                continue;
            }
            r = m - 1;
        }
        return -(l + 1);
    }

    public NodeSeqBuilder sort() {
        if (this.check) {
            this.sort(this.sort);
        }
        return this;
    }

    private void sort(boolean force) {
        this.check = false;
        if (this.size > 1) {
            if (force) {
                this.sort(0, this.size);
            }
            int i = 1;
            for (int j = 1; j < this.size; ++j) {
                while (j < this.size && this.item[i - 1].is(this.item[j])) {
                    this.item[i - 1].score(Math.max(this.item[j++].score(), this.item[i - 1].score()));
                }
                if (j == this.size) break;
                this.item[i++] = this.item[j];
            }
            this.size = i;
        }
    }

    private void sort(int s, int e) {
        int c;
        int a;
        if (e < 7) {
            for (int i = s; i < e + s; ++i) {
                for (int j = i; j > s && this.item[j - 1].diff(this.item[j]) > 0; --j) {
                    this.s(j, j - 1);
                }
            }
            return;
        }
        int m = s + (e >> 1);
        if (e > 7) {
            int l = s;
            int n = s + e - 1;
            if (e > 40) {
                int k = e >>> 3;
                l = this.m(l, l + k, l + (k << 1));
                m = this.m(m - k, m, m + k);
                n = this.m(n - (k << 1), n - k, n);
            }
            m = this.m(l, m, n);
        }
        ANode v = this.item[m];
        int b = a = s;
        int d = c = s + e - 1;
        while (true) {
            int h;
            if (b <= c && (h = this.item[b].diff(v)) <= 0) {
                if (h == 0) {
                    this.s(a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (h = this.item[c].diff(v)) >= 0) {
                if (h == 0) {
                    this.s(c, d--);
                }
                --c;
            }
            if (b > c) break;
            this.s(b++, c--);
        }
        int n = s + e;
        int k = Math.min(a - s, b - a);
        this.s(s, b - k, k);
        k = Math.min(d - c, n - d - 1);
        this.s(b, n - k, k);
        k = b - a;
        if (k > 1) {
            this.sort(s, k);
        }
        if ((k = d - c) > 1) {
            this.sort(n - k, k);
        }
    }

    private void s(int a, int b, int n) {
        for (int i = 0; i < n; ++i) {
            this.s(a + i, b + i);
        }
    }

    private int m(int a, int b, int c) {
        return this.item[a].diff(this.item[b]) < 0 ? (this.item[b].diff(this.item[c]) < 0 ? b : (this.item[a].diff(this.item[c]) < 0 ? c : a)) : (this.item[b].diff(this.item[c]) > 0 ? b : (this.item[a].diff(this.item[c]) > 0 ? c : a));
    }

    private void s(int a, int b) {
        ANode tmp = this.item[a];
        this.item[a] = this.item[b];
        this.item[b] = tmp;
    }

    public String toString() {
        return Util.name(this) + Arrays.toString(Arrays.copyOf(this.item, this.size));
    }
}

