/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.crypto;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.keyinfo.X509IssuerSerial;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.crypto.dsig.spec.XPathFilterParameterSpec;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.basex.io.out.ArrayOutput;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerProp;
import org.basex.query.QueryException;
import org.basex.query.util.Err;
import org.basex.query.util.crypto.MyKeySelector;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.TokenMap;
import org.basex.util.hash.TokenSet;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class DigitalSignature {
    private static final TokenMap CANONICALIZATIONS = new TokenMap();
    private static final TokenMap DIGESTS = new TokenMap();
    private static final TokenMap SIGNATURES = new TokenMap();
    private static final TokenSet TYPES = new TokenSet();
    private static final byte[] DEFC = Token.token("inclusive-with-comments");
    private static final byte[] DEFD = Token.token("sha1");
    private static final byte[] DEFS = Token.token("rsa_sha1");
    private static final byte[] DEFT = Token.token("enveloped");
    private static final byte[] ENVT = Token.token("enveloping");
    private final InputInfo info;

    public DigitalSignature(InputInfo ii) {
        this.info = ii;
    }

    public Item generateSignature(ANode node, byte[] c, byte[] d, byte[] sig, byte[] ns, byte[] t, byte[] expr, ANode ce, InputInfo ii) throws QueryException {
        byte[] b = c;
        if (b.length == 0) {
            b = DEFC;
        }
        if ((b = CANONICALIZATIONS.get(Token.lc(b))) == null) {
            Err.CX_CANINV.thrw(this.info, new Object[]{c});
        }
        String canonicalization = Token.string(b);
        b = d;
        if (b.length == 0) {
            b = DEFD;
        }
        if ((b = DIGESTS.get(Token.lc(b))) == null) {
            Err.CX_DIGINV.thrw(this.info, new Object[]{d});
        }
        String digest = Token.string(b);
        b = sig;
        if (b.length == 0) {
            b = DEFS;
        }
        byte[] tsig = b;
        if ((b = SIGNATURES.get(Token.lc(b))) == null) {
            Err.CX_SIGINV.thrw(this.info, new Object[]{sig});
        }
        String signature = Token.string(b);
        String keytype = Token.string(tsig).substring(0, 3);
        b = t;
        if (b.length == 0) {
            b = DEFT;
        }
        if (!TYPES.contains(Token.lc(b))) {
            Err.CX_SIGTYPINV.thrw(this.info, new Object[]{t});
        }
        byte[] type = b;
        Item signedNode = null;
        try {
            XMLSignature xmlSig;
            DOMSignContext signContext;
            List<Transform> tfList;
            KeyInfo ki;
            PrivateKey pk;
            XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
            if (ce != null) {
                String ksTY = null;
                String ksPW = null;
                String kAlias = null;
                String pkPW = null;
                String ksURI = null;
                Document ceDOM = DigitalSignature.toDOMNode(ce);
                if (!ceDOM.getDocumentElement().getNodeName().equals("digital-certificate")) {
                    Err.CX_INVNM.thrw(this.info, ceDOM);
                }
                NodeList ceChildren = ceDOM.getDocumentElement().getChildNodes();
                int s = ceChildren.getLength();
                int ci = 0;
                while (ci < s) {
                    Node cn;
                    String name;
                    if ((name = (cn = ceChildren.item(ci++)).getNodeName()).equals("keystore-type")) {
                        ksTY = cn.getTextContent();
                        continue;
                    }
                    if (name.equals("keystore-password")) {
                        ksPW = cn.getTextContent();
                        continue;
                    }
                    if (name.equals("key-alias")) {
                        kAlias = cn.getTextContent();
                        continue;
                    }
                    if (name.equals("private-key-password")) {
                        pkPW = cn.getTextContent();
                        continue;
                    }
                    if (!name.equals("keystore-uri")) continue;
                    ksURI = cn.getTextContent();
                }
                KeyStore ks = null;
                try {
                    ks = KeyStore.getInstance(ksTY);
                }
                catch (KeyStoreException ex) {
                    Err.CX_KSNULL.thrw(this.info, ex);
                }
                ks.load(new FileInputStream(ksURI), ksPW.toCharArray());
                pk = (PrivateKey)ks.getKey(kAlias, pkPW.toCharArray());
                X509Certificate x509ce = (X509Certificate)ks.getCertificate(kAlias);
                if (x509ce == null) {
                    Err.CX_ALINV.thrw(this.info, kAlias);
                }
                PublicKey puk = x509ce.getPublicKey();
                KeyInfoFactory kifactory = fac.getKeyInfoFactory();
                KeyValue keyValue = kifactory.newKeyValue(puk);
                Vector<XMLStructure> kiCont = new Vector<XMLStructure>();
                kiCont.add(keyValue);
                ArrayList<Object> x509Content = new ArrayList<Object>();
                X509IssuerSerial issuer = kifactory.newX509IssuerSerial(x509ce.getIssuerX500Principal().getName(), x509ce.getSerialNumber());
                x509Content.add(x509ce.getSubjectX500Principal().getName());
                x509Content.add(issuer);
                x509Content.add(x509ce);
                X509Data x509Data = kifactory.newX509Data(x509Content);
                kiCont.add(x509Data);
                ki = kifactory.newKeyInfo(kiCont);
            } else {
                KeyPairGenerator gen = KeyPairGenerator.getInstance(keytype);
                gen.initialize(512);
                KeyPair kp = gen.generateKeyPair();
                KeyInfoFactory kif = fac.getKeyInfoFactory();
                KeyValue kv = kif.newKeyValue(kp.getPublic());
                ki = kif.newKeyInfo(Collections.singletonList(kv));
                pk = kp.getPrivate();
            }
            Document inputNode = DigitalSignature.toDOMNode(node);
            if (expr.length > 0) {
                XPathFactory xpf = XPathFactory.newInstance();
                XPathExpression xExpr = xpf.newXPath().compile(Token.string(expr));
                NodeList xRes = (NodeList)xExpr.evaluate(inputNode, XPathConstants.NODESET);
                if (xRes.getLength() < 1) {
                    Err.CX_XPINV.thrw(this.info, new Object[]{expr});
                }
                tfList = new ArrayList<Transform>(2);
                tfList.add(fac.newTransform("http://www.w3.org/TR/1999/REC-xpath-19991116", new XPathFilterParameterSpec(Token.string(expr))));
                tfList.add(fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
            } else {
                tfList = Collections.singletonList(fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
            }
            Reference ref = fac.newReference("", fac.newDigestMethod(digest, null), tfList, null, null);
            SignedInfo si = fac.newSignedInfo(fac.newCanonicalizationMethod(canonicalization, (C14NMethodParameterSpec)null), fac.newSignatureMethod(signature, null), Collections.singletonList(ref));
            if (Token.eq(type, DEFT)) {
                signContext = new DOMSignContext(pk, (Node)inputNode.getDocumentElement());
                xmlSig = fac.newXMLSignature(si, ki);
            } else {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                DOMStructure cont = new DOMStructure(inputNode.getDocumentElement());
                XMLObject obj = fac.newXMLObject(Collections.singletonList(cont), "", null, null);
                xmlSig = fac.newXMLSignature(si, ki, Collections.singletonList(obj), null, null);
                signContext = new DOMSignContext(pk, (Node)inputNode);
            }
            if (ns.length > 0) {
                signContext.setDefaultNamespacePrefix(Token.string(ns));
            }
            xmlSig.sign(signContext);
            signedNode = NodeType.DOC.cast(inputNode, ii);
        }
        catch (XPathExpressionException e) {
            Err.CX_XPINV.thrw(this.info, e);
        }
        catch (SAXException e) {
            Err.CX_IOEXC.thrw(this.info, e);
        }
        catch (IOException e) {
            Err.CX_IOEXC.thrw(this.info, e);
        }
        catch (ParserConfigurationException e) {
            Err.CX_IOEXC.thrw(this.info, e);
        }
        catch (KeyStoreException e) {
            Err.CX_KSEXC.thrw(this.info, e);
        }
        catch (MarshalException e) {
            Err.CX_SIGEXC.thrw(this.info, e);
        }
        catch (XMLSignatureException e) {
            Err.CX_SIGEXC.thrw(this.info, e);
        }
        catch (NoSuchAlgorithmException e) {
            Err.CX_ALGEXC.thrw(this.info, e);
        }
        catch (CertificateException e) {
            Err.CX_ALGEXC.thrw(this.info, e);
        }
        catch (UnrecoverableKeyException e) {
            Err.CX_NOKEY.thrw(this.info, e);
        }
        catch (KeyException e) {
            Err.CX_NOKEY.thrw(this.info, e);
        }
        catch (InvalidAlgorithmParameterException e) {
            Err.CX_ALGEXC.thrw(this.info, e);
        }
        return signedNode;
    }

    public Item validateSignature(ANode node) throws QueryException {
        boolean coreVal = false;
        try {
            Document doc = DigitalSignature.toDOMNode(node);
            DOMValidateContext valContext = new DOMValidateContext(new MyKeySelector(), (Node)doc);
            NodeList signl = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            if (signl.getLength() < 1) {
                Err.CX_NOSIG.thrw(this.info, node);
            }
            valContext.setNode(signl.item(0));
            XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
            XMLSignature signature = fac.unmarshalXMLSignature(valContext);
            coreVal = signature.validate(valContext);
        }
        catch (XMLSignatureException e) {
            Err.CX_IOEXC.thrw(this.info, e);
        }
        catch (SAXException e) {
            Err.CX_IOEXC.thrw(this.info, e);
        }
        catch (ParserConfigurationException e) {
            Err.CX_IOEXC.thrw(this.info, e);
        }
        catch (IOException e) {
            Err.CX_IOEXC.thrw(this.info, e);
        }
        catch (MarshalException e) {
            Err.CX_SIGEXC.thrw(this.info, e);
        }
        return Bln.get(coreVal);
    }

    private static byte[] nodeToBytes(ANode n) throws IOException {
        ArrayOutput ao = new ArrayOutput();
        Serializer ser = Serializer.get(ao, new SerializerProp("format=no"));
        ser.serialize(n);
        ser.close();
        return ao.toArray();
    }

    private static Document toDOMNode(ANode n) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        return dbf.newDocumentBuilder().parse(new ByteArrayInputStream(DigitalSignature.nodeToBytes(n)));
    }

    static {
        CANONICALIZATIONS.add(DEFC, Token.token("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments"));
        CANONICALIZATIONS.add(Token.token("exclusive-with-comments"), Token.token("http://www.w3.org/2001/10/xml-exc-c14n#WithComments"));
        CANONICALIZATIONS.add(Token.token("inclusive"), Token.token("http://www.w3.org/TR/2001/REC-xml-c14n-20010315"));
        CANONICALIZATIONS.add(Token.token("exclusive"), Token.token("http://www.w3.org/2001/10/xml-exc-c14n#"));
        DIGESTS.add(DEFD, Token.token("http://www.w3.org/2000/09/xmldsig#sha1"));
        DIGESTS.add(Token.token("sha256"), Token.token("http://www.w3.org/2001/04/xmlenc#sha256"));
        DIGESTS.add(Token.token("sha512"), Token.token("http://www.w3.org/2001/04/xmlenc#sha512"));
        SIGNATURES.add(DEFS, Token.token("http://www.w3.org/2000/09/xmldsig#rsa-sha1"));
        SIGNATURES.add(Token.token("dsa_sha1"), Token.token("http://www.w3.org/2000/09/xmldsig#dsa-sha1"));
        TYPES.add(DEFT);
        TYPES.add(ENVT);
    }
}

