/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.io.IOException;
import org.basex.io.IO;
import org.basex.io.in.TextInput;
import org.basex.query.QueryException;
import org.basex.query.func.Function;
import org.basex.query.util.Err;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;

public final class StrStream
extends Item {
    private final IO input;
    private final String encoding;
    private final Err error;
    private byte[] val;

    public StrStream(IO io, String enc, Err err) {
        super(AtomType.STR);
        this.input = io;
        this.encoding = enc;
        this.error = err;
    }

    @Override
    public byte[] string(InputInfo ii) throws QueryException {
        if (this.val == null) {
            try {
                this.val = this.input(ii).content();
            }
            catch (IOException ex) {
                throw this.error.thrw(ii, this.input);
            }
        }
        return this.val;
    }

    @Override
    public boolean bool(InputInfo ii) throws QueryException {
        return this.string(ii).length != 0;
    }

    @Override
    public boolean eq(InputInfo ii, Item it) throws QueryException {
        return Token.eq(this.string(ii), it.string(ii));
    }

    @Override
    public int diff(InputInfo ii, Item it) throws QueryException {
        return Token.diff(this.string(ii), it.string(ii));
    }

    @Override
    public String toJava() throws QueryException {
        return Token.string(this.string(null));
    }

    @Override
    public TextInput input(InputInfo ii) throws QueryException {
        TextInput nli = null;
        try {
            nli = new TextInput(this.input);
            nli.encoding(this.encoding).valid(true);
            return nli;
        }
        catch (IOException ex) {
            if (nli != null) {
                try {
                    nli.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            throw this.error.thrw(ii, this.input);
        }
    }

    @Override
    public Item materialize(InputInfo ii) throws QueryException {
        return Str.get(this.string(ii));
    }

    @Override
    public String toString() {
        return Util.info(Function._FILE_READ_TEXT.args(this.input), new Object[0]);
    }
}

