/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import org.basex.core.Context;
import org.basex.core.Perm;
import org.basex.io.IO;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;

public class InputParser {
    private static final String FOUND = ", found '%'";
    public final String input;
    public final int il;
    public String file;
    public int ip;
    public int im;

    public InputParser(String in) {
        this.input = in;
        this.il = this.input.length();
    }

    protected void file(IO f, Context c) {
        this.file = f == null ? null : (c.user.has(Perm.ADMIN) ? f.path() : f.name());
    }

    public final boolean more() {
        return this.ip < this.il;
    }

    public final char curr() {
        int i = this.ip;
        return i < this.il ? this.input.charAt(i) : (char)'\u0000';
    }

    public final boolean curr(int ch) {
        int i = this.ip;
        return i < this.il && ch == this.input.charAt(i);
    }

    protected final void mark() {
        this.im = this.ip;
    }

    protected final char next() {
        int i = this.ip + 1;
        return i < this.il ? this.input.charAt(i) : (char)'\u0000';
    }

    public final char consume() {
        return this.ip < this.il ? this.input.charAt(this.ip++) : (char)'\u0000';
    }

    public final boolean consume(int ch) {
        int i;
        return (i = this.ip++) < this.il && ch == this.input.charAt(i);
    }

    protected static final boolean quote(int ch) {
        return ch == 34 || ch == 39;
    }

    public final boolean consume(String str) {
        int i = this.ip;
        int l = str.length();
        if (i + l > this.il) {
            return false;
        }
        for (int s = 0; s < l; ++s) {
            if (this.input.charAt(i++) == str.charAt(s)) continue;
            return false;
        }
        this.ip = i;
        return true;
    }

    protected final byte[] found() {
        return this.curr() == '\u0000' ? Token.EMPTY : Util.inf(FOUND, Character.valueOf(this.curr()));
    }

    protected final String rest() {
        int ie = Math.min(this.il, this.ip + 15);
        return this.input.substring(this.ip, ie) + (ie == this.il ? "" : "...");
    }

    public final InputInfo info() {
        return new InputInfo(this);
    }
}

