/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.kindocument;

import java.util.HashMap;

public class ImportTranslator {
    private HashMap<TranslationElement, TranslationElement> translateTable = new HashMap();
    boolean ignoreCase;

    public ImportTranslator(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public void addTranslationEntry(String fieldName, String fieldValue, String translatedFieldName, String translatedFieldValue) {
        this.translateTable.put(new TranslationElement(fieldName, fieldValue), new TranslationElement(translatedFieldName, translatedFieldValue));
    }

    public TranslationElement translate(String fieldName, String fieldValue) {
        TranslationElement translatedInput = new TranslationElement(fieldName, fieldValue);
        TranslationElement translatedResult = this.translateTable.get(translatedInput);
        if (translatedResult == null) {
            translatedInput = new TranslationElement(fieldName, null);
            translatedResult = this.translateTable.get(translatedInput);
        }
        if (translatedResult != null) {
            if (translatedResult.fieldValue == null) {
                return new TranslationElement(translatedResult.fieldName, fieldValue);
            }
            return translatedResult;
        }
        return new TranslationElement(fieldName, fieldValue);
    }

    public class TranslationElement {
        String fieldName;
        String fieldValue;

        public TranslationElement(String fieldName, String fieldValue) {
            if (fieldName.matches("^[0-9].*")) {
                fieldName = "_" + fieldName;
            }
            this.fieldName = fieldName.replaceAll("[^a-zA-Z0-9]+", "_");
            this.fieldValue = fieldValue;
        }

        private String checkCase(String inputString) {
            if (ImportTranslator.this.ignoreCase) {
                return inputString.toLowerCase();
            }
            return inputString;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TranslationElement other = (TranslationElement)obj;
            if (this.fieldName == null ? other.fieldName != null : !this.fieldName.equals(other.fieldName)) {
                return false;
            }
            return !(this.fieldValue == null ? other.fieldValue != null : !this.checkCase(this.fieldValue).equals(this.checkCase(other.fieldValue)));
        }

        public int hashCode() {
            int hash = 5;
            hash = 11 * hash + (this.fieldName != null ? this.fieldName.hashCode() : 0);
            hash = 11 * hash + (this.fieldValue != null ? this.checkCase(this.fieldValue).hashCode() : 0);
            return hash;
        }
    }
}

