/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilField;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.ui.ArbilTree;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.flap.plugin.PluginSessionStorage;
import nl.mpi.kinnate.data.KinTreeNode;
import nl.mpi.kinnate.entityindexer.EntityCollection;
import nl.mpi.kinnate.entityindexer.EntityServiceException;
import nl.mpi.kinnate.gedcomimport.ImportException;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kindocument.EntityDocument;
import nl.mpi.kinnate.kindocument.ImportTranslator;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.ui.KinDiagramPanel;
import nl.mpi.kinnate.ui.KinTree;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;

public class KinDragTransferHandler
extends TransferHandler
implements Transferable {
    private ArbilNode[] selectedNodes;
    private DataFlavor dataFlavor = new DataFlavor(ArbilNode[].class, "ArbilObject");
    private DataFlavor[] dataFlavors = new DataFlavor[]{this.dataFlavor, DataFlavor.stringFlavor};
    private final KinDiagramPanel kinDiagramPanel;
    private EntityData targetEntity = null;
    private final SessionStorage sessionStorage;
    private final EntityCollection entityCollection;

    public KinDragTransferHandler(KinDiagramPanel kinDiagramPanel, SessionStorage sessionStorage, EntityCollection entityCollection) {
        this.kinDiagramPanel = kinDiagramPanel;
        this.sessionStorage = sessionStorage;
        this.entityCollection = entityCollection;
    }

    public int getSourceActions(JComponent comp) {
        return 1;
    }

    public Transferable createTransferable(JComponent comp) {
        this.selectedNodes = ((ArbilTree)comp).getAllSelectedNodes();
        if (this.selectedNodes.length == 0) {
            return null;
        }
        for (ArbilNode arbilNode : this.selectedNodes) {
            if (!(arbilNode instanceof ArbilDataNode) || !((ArbilDataNode)arbilNode).getParentDomNode().isCorpus() && !((ArbilDataNode)arbilNode).getParentDomNode().isCatalogue() && !((ArbilDataNode)arbilNode).getParentDomNode().isDirectory()) continue;
            return null;
        }
        return this;
    }

    public void exportDone(JComponent comp, Transferable trans, int action) {
        this.kinDiagramPanel.redrawIfKinTermsChanged();
    }

    public Object getTransferData(DataFlavor df) throws UnsupportedFlavorException, IOException {
        if (df.equals(DataFlavor.stringFlavor)) {
            StringBuilder stringBuilder = new StringBuilder();
            for (ArbilNode arbilNode : this.selectedNodes) {
                if (!(arbilNode instanceof KinTreeNode)) continue;
                if (stringBuilder.length() == 0) {
                    stringBuilder.append("\n");
                }
                stringBuilder.append("[Entity.Identifier=");
                stringBuilder.append(((KinTreeNode)arbilNode).getUniqueIdentifier().getQueryIdentifier());
                stringBuilder.append("]");
            }
            return stringBuilder.toString();
        }
        return "";
    }

    public DataFlavor[] getTransferDataFlavors() {
        return this.dataFlavors;
    }

    public boolean isDataFlavorSupported(DataFlavor df) {
        return true;
    }

    public boolean canImport(TransferHandler.TransferSupport support) {
        this.targetEntity = null;
        if (!support.isDataFlavorSupported(this.dataFlavor)) {
            return false;
        }
        Component dropLocation = support.getComponent();
        if (dropLocation instanceof GraphPanel) {
            return true;
        }
        if (dropLocation instanceof KinTree && this.selectedNodes != null && this.selectedNodes.length > 0 && this.selectedNodes[0] instanceof ArbilDataNode) {
            ArbilNode dropNode = ((KinTree)((Object)dropLocation)).getLeadSelectionNode();
            if (dropNode == null) {
                return true;
            }
            if (dropNode instanceof KinTreeNode) {
                this.targetEntity = ((KinTreeNode)dropNode).getEntityData();
                return this.targetEntity != null && !this.targetEntity.getUniqueIdentifier().isTransientIdentifier();
            }
        }
        return false;
    }

    private boolean addEntitiesToGraph(Point defaultLocation) {
        ArrayList<UniqueIdentifier> slectedIdentifiers = new ArrayList<UniqueIdentifier>();
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{UniqueIdentifier.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            for (ArbilNode currentArbilNode : this.selectedNodes) {
                if (!(currentArbilNode instanceof KinTreeNode)) continue;
                KinTreeNode kinTreeNode = (KinTreeNode)currentArbilNode;
                slectedIdentifiers.add(kinTreeNode.getUniqueIdentifier());
            }
        }
        catch (JAXBException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)((Object)exception));
        }
        this.kinDiagramPanel.addRequiredNodes(slectedIdentifiers.toArray(new UniqueIdentifier[0]), defaultLocation);
        return true;
    }

    private boolean importMetadata(Point defaultLocation) {
        System.out.println("importMetadata");
        ImportTranslator importTranslator = new ImportTranslator(true);
        importTranslator.addTranslationEntry("Sex", "Male", "Gender", "Male");
        importTranslator.addTranslationEntry("Sex", "Female", "Gender", "Female");
        importTranslator.addTranslationEntry("BirthDate", null, "DateOfBirth", null);
        try {
            ArrayList<EntityDocument> entityDocumentList = new ArrayList<EntityDocument>();
            for (ArbilNode draggedNode : this.selectedNodes) {
                EntityDocument entityDocument = new EntityDocument(EntityDocument.defaultDragType, importTranslator, this.sessionStorage);
                entityDocument.insertValue("Name", draggedNode.toString());
                if (draggedNode instanceof ArbilDataNode) {
                    for (String fieldOfInterest : new String[]{"Sex", "BirthDate"}) {
                        ArbilField[] arbilFeildsArray = (ArbilField[])((ArbilDataNode)draggedNode).getFields().get(fieldOfInterest);
                        if (arbilFeildsArray == null || arbilFeildsArray.length <= 0) continue;
                        entityDocument.insertValue(fieldOfInterest, arbilFeildsArray[0].getFieldValue().toLowerCase());
                    }
                    entityDocument.entityData.addArchiveLink(((ArbilDataNode)draggedNode).getURI());
                }
                entityDocumentList.add(entityDocument);
            }
            for (EntityDocument entityDocument : entityDocumentList) {
                entityDocument.saveDocument();
                URI addedEntityUri = entityDocument.getFile().toURI();
                this.entityCollection.updateDatabase(entityDocument.getFile().toURI(), entityDocument.getUniqueIdentifier());
                this.kinDiagramPanel.addRequiredNodes(new UniqueIdentifier[]{entityDocument.getUniqueIdentifier()}, defaultLocation);
            }
            return true;
        }
        catch (ImportException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)exception);
            return false;
        }
        catch (EntityServiceException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)exception);
            return false;
        }
    }

    private boolean attachMetadata(EntityData entityData) {
        for (ArbilNode currentArbilNode : this.selectedNodes) {
            ArbilDataNode currentArbilDataNode = (ArbilDataNode)currentArbilNode;
            entityData.addArchiveLink(currentArbilDataNode.getURI());
        }
        return false;
    }

    private boolean attachMetadata() {
        System.out.println("importMetadata");
        try {
            EntityDocument entityDocument = new EntityDocument(this.targetEntity.getUniqueIdentifier().getFileInProject((PluginSessionStorage)this.sessionStorage).toURI(), new ImportTranslator(true), this.sessionStorage);
            this.attachMetadata(entityDocument.entityData);
            entityDocument.saveDocument();
            URI addedEntityUri = entityDocument.getFile().toURI();
            this.entityCollection.updateDatabase(entityDocument.getFile().toURI(), entityDocument.getUniqueIdentifier());
            this.kinDiagramPanel.entityRelationsChanged(new UniqueIdentifier[]{entityDocument.getUniqueIdentifier()});
            return true;
        }
        catch (ImportException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)exception);
            return false;
        }
        catch (EntityServiceException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)exception);
            return false;
        }
    }

    public boolean importData(TransferHandler.TransferSupport support) {
        if (!this.canImport(support)) {
            return false;
        }
        boolean isImportingMetadata = this.selectedNodes != null && this.selectedNodes.length > 0 && this.selectedNodes[0] instanceof ArbilDataNode;
        Component dropLocation = support.getComponent();
        if (dropLocation instanceof GraphPanel) {
            Point defaultLocation = support.getDropLocation().getDropPoint();
            System.out.println("dropped to GraphPanel");
            if (isImportingMetadata) {
                return this.importMetadata(defaultLocation);
            }
            return this.addEntitiesToGraph(defaultLocation);
        }
        if (dropLocation instanceof KinTree) {
            System.out.println("dropped to KinTree");
            if (isImportingMetadata) {
                return this.attachMetadata();
            }
        }
        return false;
    }
}

