/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui.menu;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.kinnate.ui.window.AbstractDiagramManager;

public class ProjectFileMenu
extends JMenu
implements ActionListener {
    private final AbstractDiagramManager diagramWindowManager;
    private final SessionStorage sessionStorage;
    private final Component parentComponent;

    public ProjectFileMenu(AbstractDiagramManager diagramWindowManager, SessionStorage sessionStorage, Component parentComponent) {
        this.diagramWindowManager = diagramWindowManager;
        this.sessionStorage = sessionStorage;
        this.parentComponent = parentComponent;
        this.setText("Open Recent Project");
        this.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                ProjectFileMenu.this.setupMenu();
            }
        });
    }

    public static void addRecentProject(SessionStorage sessionStorageS, File recentProjectFile) {
        ArrayList<String> tempList = new ArrayList<String>();
        try {
            String[] tempArray = sessionStorageS.loadStringArray("RecentKinProjects");
            if (tempArray != null) {
                tempList.addAll(Arrays.asList(tempArray));
            }
            while (tempList.size() > 10) {
                tempList.remove(0);
            }
            tempList.remove(recentProjectFile.toString());
            tempList.add(recentProjectFile.toString());
        }
        catch (IOException exception) {
            String[] tempArray = new String[]{recentProjectFile.toString()};
        }
        try {
            sessionStorageS.saveStringArray("RecentKinProjects", tempList.toArray(new String[0]));
        }
        catch (IOException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)exception);
        }
    }

    private void setupMenu() {
        this.removeAll();
        try {
            String[] recentProjectFileArray = this.sessionStorage.loadStringArray("RecentKinProjects");
            if (recentProjectFileArray != null) {
                for (int currentIndex = recentProjectFileArray.length - 1; currentIndex >= 0; --currentIndex) {
                    String currentFilePath = recentProjectFileArray[currentIndex];
                    JMenuItem currentMenuItem = new JMenuItem(currentFilePath);
                    currentMenuItem.setActionCommand(currentFilePath);
                    currentMenuItem.addActionListener(this);
                    this.add(currentMenuItem);
                }
            }
            this.add(new JSeparator());
            JMenuItem clearMenuItem = new JMenuItem("Clear List");
            clearMenuItem.setActionCommand("Clear List");
            clearMenuItem.addActionListener(this);
            this.add(clearMenuItem);
        }
        catch (IOException exception) {
            JMenuItem currentMenuItem = new JMenuItem("no recent files");
            currentMenuItem.setEnabled(false);
            this.add(currentMenuItem);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if ("browse".equals(e.getActionCommand())) {
            System.out.println("browse for project");
        } else if ("Clear List".equals(e.getActionCommand())) {
            try {
                this.sessionStorage.saveStringArray("RecentKinProjects", new String[0]);
            }
            catch (IOException exception) {
                BugCatcherManager.getBugCatcher().logError((Exception)exception);
            }
        } else {
            String actionString = e.getActionCommand();
            File recentProjectFile = new File(actionString);
            String recentName = recentProjectFile.getName();
            Dimension parentSize = this.parentComponent.getSize();
            Point parentLocation = this.parentComponent.getLocation();
            int offset = 10;
            Rectangle windowRectangle = new Rectangle(parentLocation.x + offset, parentLocation.y + offset, parentSize.width - offset, parentSize.height - offset);
            this.diagramWindowManager.openDiagram(recentName, recentProjectFile.toURI(), true, windowRectangle);
        }
    }
}

