/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.plugins.export.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import nl.mpi.flap.kinnate.entityindexer.QueryException;
import nl.mpi.flap.plugin.PluginBugCatcher;
import nl.mpi.flap.plugin.PluginDialogHandler;
import nl.mpi.flap.plugin.PluginException;
import nl.mpi.flap.plugin.PluginSessionStorage;
import nl.mpi.kinnate.entityindexer.CollectionExport;
import nl.mpi.kinnate.plugins.export.GedcomExport;

public class KinOathExportPanel
extends JPanel {
    final PluginDialogHandler arbilWindowManager;
    final PluginBugCatcher bugCatcher;

    public KinOathExportPanel(PluginDialogHandler dialogHandler, PluginSessionStorage sessionStorage, final PluginBugCatcher bugCatcher) {
        super(new BorderLayout());
        this.arbilWindowManager = dialogHandler;
        this.bugCatcher = bugCatcher;
        this.setName("CMDI/IMDI/KMDI Export Tool");
        JLabel queryTimeLabel = new JLabel();
        CollectionExport entityCollection = new CollectionExport(bugCatcher, sessionStorage);
        final GedcomExport gedcomExport = new GedcomExport(entityCollection);
        final JProgressBar jProgressBar = new JProgressBar();
        String browseOption = "<browse>";
        final JComboBox<String> locationSelect = new JComboBox<String>(new String[]{"<browse>"});
        File defaultKinOathDirectory = sessionStorage.getProjectDirectory();
        for (File currentFile : defaultKinOathDirectory.getParentFile().listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().startsWith(".kinoath");
            }
        })) {
            locationSelect.addItem(currentFile.toString());
        }
        final JTextArea resultsText = new JTextArea();
        final JButton saveAsButton = new JButton("Save KinOath Export File");
        final JButton recreateButton = new JButton("Create Temporary Database");
        saveAsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                saveAsButton.setEnabled(false);
                recreateButton.setEnabled(false);
                locationSelect.setEnabled(false);
                HashMap<String, 1> fileFilterMap = new HashMap<String, 1>(2);
                fileFilterMap.put("KinOath Export", new javax.swing.filechooser.FileFilter(){

                    public boolean accept(File selectedFile) {
                        if (selectedFile.isDirectory()) {
                            return true;
                        }
                        String currentFileName = selectedFile.getName().toLowerCase();
                        return currentFileName.endsWith(".kinoath");
                    }

                    public String getDescription() {
                        return "KinOath Kinship Data";
                    }
                });
                File[] saveFile = KinOathExportPanel.this.arbilWindowManager.showFileSelectBox("Save KinOath Export File", false, false, fileFilterMap, PluginDialogHandler.DialogueType.save, null);
                if (saveFile != null) {
                    jProgressBar.setIndeterminate(true);
                    try {
                        if (!saveFile[0].getName().toLowerCase().endsWith(".kinoath")) {
                            saveFile[0] = new File(saveFile[0].getParentFile(), saveFile[0].getName() + ".kinoath");
                        }
                        resultsText.setText("Generating export contents.\n");
                        String generateExportResult = gedcomExport.generateExport(gedcomExport.getGedcomQuery());
                        resultsText.setText("Creating export file: " + saveFile.toString() + "\n");
                        FileWriter fileWriter = new FileWriter(saveFile[0]);
                        fileWriter.write(generateExportResult);
                        fileWriter.close();
                        resultsText.setText("Export file complete.\n");
                        KinOathExportPanel.this.arbilWindowManager.addMessageDialogToQueue("Save Complete", "Save File");
                    }
                    catch (IOException exception) {
                        resultsText.setText("Error Saving File.\n");
                        KinOathExportPanel.this.arbilWindowManager.addMessageDialogToQueue(exception.getMessage(), "Error Saving File");
                        bugCatcher.logException(new PluginException(exception.getMessage()));
                    }
                    catch (QueryException exception) {
                        resultsText.setText("Error Creating Export.\n");
                        KinOathExportPanel.this.arbilWindowManager.addMessageDialogToQueue(exception.getMessage(), "Error Creating Export");
                        bugCatcher.logException(new PluginException(exception.getMessage()));
                    }
                } else {
                    resultsText.setText("Export file not valid, no export created.\n");
                }
                jProgressBar.setIndeterminate(false);
                saveAsButton.setEnabled(true);
                recreateButton.setEnabled(true);
                locationSelect.setEnabled(true);
            }
        });
        recreateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                saveAsButton.setEnabled(false);
                recreateButton.setEnabled(false);
                locationSelect.setEnabled(false);
                File importDirectory = null;
                if (!locationSelect.getSelectedItem().toString().equals("<browse>")) {
                    importDirectory = new File(locationSelect.getSelectedItem().toString());
                } else {
                    File[] importDirectoryArray = KinOathExportPanel.this.arbilWindowManager.showFileSelectBox("Select Import Directory", true, false, null, PluginDialogHandler.DialogueType.open, null);
                    if (importDirectoryArray != null && importDirectoryArray.length > 0) {
                        importDirectory = importDirectoryArray[0];
                    }
                }
                jProgressBar.setIndeterminate(true);
                if (importDirectory != null) {
                    resultsText.setText("Dropping old temporary database\n");
                    resultsText.setText("Creating new temporary database for: " + importDirectory + "\n");
                    final File importDirectoryFinal = importDirectory;
                    new Thread(){

                        public void run() {
                            try {
                                gedcomExport.dropAndCreate(importDirectoryFinal, "*.kmdi");
                                resultsText.append("Completed cteating temporary database\n");
                            }
                            catch (QueryException exception) {
                                resultsText.append("Error creating temporary database: " + exception.getMessage() + "\n");
                                KinOathExportPanel.this.arbilWindowManager.addMessageDialogToQueue(exception.getMessage(), "Create Temporary Database");
                                bugCatcher.logException(new PluginException(exception.getMessage()));
                            }
                            jProgressBar.setIndeterminate(false);
                            saveAsButton.setEnabled(true);
                            recreateButton.setEnabled(true);
                            locationSelect.setEnabled(true);
                        }
                    }.start();
                } else {
                    resultsText.append("Invalid Import Directory\n");
                    jProgressBar.setIndeterminate(false);
                    saveAsButton.setEnabled(true);
                    recreateButton.setEnabled(true);
                    locationSelect.setEnabled(true);
                }
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(locationSelect);
        buttonPanel.add(recreateButton);
        buttonPanel.add(saveAsButton);
        buttonPanel.add(queryTimeLabel);
        JPanel progressPanel = new JPanel(new BorderLayout());
        progressPanel.add((Component)buttonPanel, "First");
        progressPanel.add((Component)jProgressBar, "Last");
        this.add((Component)new JScrollPane(resultsText), "Center");
        this.add((Component)progressPanel, "First");
    }
}

