/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.basex.core.Perm;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.core.User;
import org.basex.io.IOFile;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.util.Table;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.StringList;
import org.basex.util.list.TokenList;

public final class Users {
    private final List<User> list = new ArrayList<User>(0);
    private IOFile file;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Users(boolean global) {
        if (!global) {
            return;
        }
        this.file = new IOFile(Prop.HOME, ".basexperm");
        if (!this.file.exists()) {
            this.list.add(new User("admin", Token.md5("admin"), Perm.ADMIN));
        } else {
            DataInput in = null;
            try {
                in = new DataInput(this.file);
                this.read(in);
            }
            catch (IOException ex) {
                Util.errln(ex, new Object[0]);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public synchronized void read(DataInput in) throws IOException {
        int s = in.readNum();
        for (int u = 0; u < s; ++u) {
            User user = new User(Token.string(in.readToken()), Token.string(in.readToken()), Perm.get(in.readNum()));
            this.list.add(user);
        }
    }

    public synchronized void write() {
        if (this.file == null) {
            return;
        }
        try {
            DataOutput out = new DataOutput(this.file);
            this.write(out);
            out.close();
        }
        catch (IOException ex) {
            Util.debug(ex);
        }
    }

    public synchronized boolean create(String usern, String pass) {
        return this.get(usern) == null && this.create(new User(usern, pass, Perm.NONE));
    }

    public synchronized boolean create(User user) {
        this.list.add(user);
        this.write();
        return true;
    }

    public synchronized boolean alter(String usern, String pass) {
        User user = this.get(usern);
        if (user == null) {
            return false;
        }
        user.password = pass;
        this.write();
        return true;
    }

    public synchronized boolean drop(User user) {
        if (!this.list.remove(user)) {
            return false;
        }
        this.write();
        return true;
    }

    public synchronized User get(String usern) {
        for (User user : this.list) {
            if (!user.name.equals(usern)) continue;
            return user;
        }
        return null;
    }

    public synchronized String[] find(Pattern pattern) {
        StringList sl = new StringList();
        for (User u : this.list) {
            if (!pattern.matcher(u.name).matches()) continue;
            sl.add(u.name);
        }
        return sl.toArray();
    }

    public synchronized void write(DataOutput out) throws IOException {
        out.writeNum(this.list.size());
        for (User user : this.list) {
            out.writeToken(Token.token(user.name));
            out.writeToken(Token.token(user.password));
            out.writeNum(user.perm.num);
        }
    }

    public synchronized byte[] info(Users users) {
        Table table = new Table();
        table.description = Text.USERS;
        int sz = this.file == null ? 3 : 5;
        for (int u = 0; u < sz; ++u) {
            table.header.add(Text.USERHEAD[u]);
        }
        for (User user : this.list) {
            if (users != null && users.get(user.name) == null) continue;
            TokenList tl = new TokenList();
            tl.add(user.name);
            tl.add(user.has(Perm.READ) ? "X" : "");
            tl.add(user.has(Perm.WRITE) ? "X" : "");
            if (sz == 5) {
                tl.add(user.has(Perm.CREATE) ? "X" : "");
                tl.add(user.has(Perm.ADMIN) ? "X" : "");
            }
            table.contents.add(tl);
        }
        return table.sort().toTop(Token.token("admin")).finish();
    }
}

