/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.info;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import org.basex.core.Command;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.core.cmd.XQuery;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIProp;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXEditor;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.view.View;
import org.basex.gui.view.ViewNotifier;
import org.basex.util.Performance;
import org.basex.util.TokenBuilder;
import org.basex.util.list.IntList;
import org.basex.util.list.StringList;

public final class InfoView
extends View {
    private final TokenBuilder text = new TokenBuilder();
    private final BaseXLabel header;
    private final BaseXLabel timer;
    private final BaseXBack north;
    private final BaseXEditor area;
    private IntList stat = new IntList();
    private StringList strings;
    private int focus = -1;
    private int w;
    private int h;
    private int bw;
    private int bs;

    public InfoView(ViewNotifier man) {
        super("info", man);
        this.border(6, 6, 6, 6).layout(new BorderLayout());
        this.north = new BaseXBack(GUIConstants.Fill.NONE).layout(new BorderLayout());
        this.header = new BaseXLabel(Text.QUERY_INFO);
        this.north.add((Component)this.header, "North");
        this.north.add((Component)this.header, "North");
        this.timer = new BaseXLabel(" ", true, false);
        this.north.add((Component)this.timer, "South");
        this.add((Component)this.north, (Object)"North");
        this.area = new BaseXEditor(false, this.gui);
        this.add((Component)this.area, (Object)"Center");
        this.refreshLayout();
    }

    @Override
    public void refreshInit() {
    }

    @Override
    public void refreshFocus() {
    }

    @Override
    public void refreshMark() {
    }

    @Override
    public void refreshContext(boolean more, boolean quick) {
    }

    @Override
    public void refreshUpdate() {
    }

    @Override
    public void refreshLayout() {
        this.header.setFont(GUIConstants.lfont);
        this.timer.setFont(GUIConstants.font);
        this.area.setFont(GUIConstants.font);
    }

    @Override
    public boolean visible() {
        return this.gui.gprop.is(GUIProp.SHOWINFO);
    }

    @Override
    public void visible(boolean v) {
        this.gui.gprop.set(GUIProp.SHOWINFO, v);
    }

    @Override
    protected boolean db() {
        return false;
    }

    public void setInfo(String info, Command cmd, String time, boolean ok) {
        StringList eval = new StringList();
        StringList comp = new StringList();
        StringList plan = new StringList();
        StringList sl = new StringList();
        StringList stats = new StringList();
        IntList il = new IntList();
        String err = "";
        String qu = "";
        String res = "";
        String[] split = info.split(Text.NL);
        for (int i = 0; i < split.length; ++i) {
            String line = split[i];
            int s = line.indexOf(58);
            if (line.startsWith(Text.PARSING_CC) || line.startsWith(Text.COMPILING_CC) || line.startsWith(Text.EVALUATING_CC) || line.startsWith(Text.PRINTING_CC) || line.startsWith(Text.TOTAL_TIME_CC)) {
                int t = line.indexOf(" ms");
                sl.add(line.substring(0, s).trim());
                il.add((int)(Double.parseDouble(line.substring(s + 1, t)) * 100.0));
                continue;
            }
            if (line.startsWith(Text.QUERY_C)) {
                qu = line.substring(s + 1).trim();
                continue;
            }
            if (line.startsWith(Text.QUERY_PLAN_C)) {
                while (++i < split.length && !split[i].isEmpty()) {
                    plan.add(split[i]);
                }
                --i;
                continue;
            }
            if (line.startsWith(Text.COMPILING_C)) {
                while (++i < split.length && !split[i].isEmpty()) {
                    comp.add(split[i]);
                }
                continue;
            }
            if (line.startsWith(Text.RESULT_C)) {
                res = line.substring(s + 1).trim();
                continue;
            }
            if (line.startsWith(Text.EVALUATING_C)) {
                while (++i < split.length && split[i].startsWith("- ")) {
                    eval.add(split[i]);
                }
                --i;
                continue;
            }
            if (!ok) {
                err = err + line + Text.NL;
                continue;
            }
            if (!line.startsWith(Text.HITS_X_CC) && !line.startsWith(Text.UPDATED_CC) && !line.startsWith(Text.PRINTED_CC)) continue;
            stats.add("- " + line);
        }
        this.stat = il;
        this.strings = sl;
        String total = time;
        if (ok && cmd instanceof XQuery) {
            this.text.reset();
            this.add(Text.EVALUATING_C, eval);
            this.add(Text.QUERY_C + ' ', qu);
            this.add(Text.COMPILING_C, comp);
            if (!comp.isEmpty()) {
                this.add(Text.RESULT_C, res);
            }
            this.add(Text.TIMING_C, sl);
            this.add(Text.RESULT_C, stats);
            this.add(Text.QUERY_PLAN_C, plan);
            int runs = Math.max(1, this.gui.context.prop.num(Prop.RUNS));
            total = Performance.getTime((long)il.get(il.size() - 1) * 10000L * (long)runs, runs);
        } else if (ok) {
            this.add(cmd);
            this.text.add(info).nline();
        } else {
            this.add(Text.ERROR_C, err);
            this.add(cmd);
            this.add(Text.COMPILING_C, comp);
            this.add(Text.QUERY_PLAN_C, plan);
        }
        this.area.setText(this.text.finish());
        if (total != null) {
            this.timer.setText(Text.TOTAL_TIME_CC + total);
        }
        this.repaint();
    }

    private void add(Command cmd) {
        if (cmd instanceof XQuery) {
            this.add(Text.QUERY_C + ' ', cmd.args[0].trim());
        } else if (cmd != null) {
            this.text.bold().add(Text.COMMAND + ": ").norm().addExt(cmd, new Object[0]).nline();
        }
    }

    public void reset() {
        this.text.reset();
    }

    private void add(String head, StringList list) {
        int runs = Math.max(1, this.gui.context.prop.num(Prop.RUNS));
        if (list.isEmpty()) {
            return;
        }
        this.text.bold().add(head).norm().nline();
        int is = list.size();
        for (int i = 0; i < is; ++i) {
            String line = list.get(i);
            if (list == this.strings) {
                line = " - " + line + ":  " + Performance.getTime((long)this.stat.get(i) * 10000L * (long)runs, runs);
            }
            this.text.add(line).nline();
        }
        this.text.hline();
    }

    private void add(String head, String txt) {
        if (!txt.isEmpty()) {
            this.text.bold().add(head).norm().add(txt).nline().hline();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int l = this.stat.size();
        if (l == 0) {
            return;
        }
        this.focus = -1;
        if (e.getY() < this.h) {
            for (int i = 0; i < l; ++i) {
                int bx = this.w - this.bw + this.bs * i;
                if (e.getX() < bx || e.getX() >= bx + this.bs) continue;
                this.focus = i;
            }
        }
        int runs = Math.max(1, this.gui.context.prop.num(Prop.RUNS));
        int f = this.focus == -1 ? l - 1 : this.focus;
        this.timer.setText(this.strings.get(f) + ": " + Performance.getTime((long)this.stat.get(f) * 10000L * (long)runs, runs));
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        int bx;
        int i;
        super.paintComponent(g);
        int l = this.stat.size();
        if (l == 0) {
            return;
        }
        this.h = this.north.getHeight();
        this.w = this.getWidth() - 8;
        this.bw = this.gui.gprop.num(GUIProp.FONTSIZE) * 2 + this.w / 10;
        this.bs = this.bw / (l - 1);
        int m = 0;
        for (int i2 = 0; i2 < l - 1; ++i2) {
            m = Math.max(m, this.stat.get(i2));
        }
        int by = 10;
        int bh = this.h - 10;
        for (i = 0; i < l - 1; ++i) {
            if (i != this.focus) continue;
            bx = this.w - this.bw + this.bs * i;
            g.setColor(GUIConstants.color3);
            g.fillRect(bx, 10, this.bs + 1, bh);
        }
        for (i = 0; i < l - 1; ++i) {
            bx = this.w - this.bw + this.bs * i;
            g.setColor(GUIConstants.color((i == this.focus ? 3 : 2) + i * 2));
            int p = Math.max(1, this.stat.get(i) * bh / m);
            g.fillRect(bx, 10 + bh - p, this.bs, p);
            g.setColor(GUIConstants.color(8));
            g.drawRect(bx, 10 + bh - p, this.bs, p - 1);
        }
    }
}

