/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.CmpR;
import org.basex.query.expr.CmpSR;
import org.basex.query.expr.Expr;
import org.basex.query.expr.InterSect;
import org.basex.query.expr.Logical;
import org.basex.query.expr.Pos;
import org.basex.query.util.IndexContext;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.ft.Scoring;

public final class And
extends Logical {
    public And(InputInfo ii, Expr[] e) {
        super(ii, e);
    }

    @Override
    public Expr compile(QueryContext ctx) throws QueryException {
        Expr c = super.compile(ctx);
        if (c != this) {
            return c;
        }
        Expr[] ex = new Expr[]{};
        Pos ps = null;
        CmpR cr = null;
        CmpSR cs = null;
        for (Expr e : this.expr) {
            Expr tmp = null;
            if (e instanceof Pos) {
                Expr expr = tmp = ps == null ? e : ps.intersect((Pos)e, this.info);
                if (!(tmp instanceof Pos)) {
                    return tmp;
                }
                ps = (Pos)tmp;
            } else if (e instanceof CmpR) {
                Expr expr = tmp = cr == null ? e : cr.intersect((CmpR)e);
                if (tmp instanceof CmpR) {
                    cr = (CmpR)tmp;
                } else if (tmp != null) {
                    return tmp;
                }
            } else if (e instanceof CmpSR) {
                Expr expr = tmp = cs == null ? e : cs.intersect((CmpSR)e);
                if (tmp instanceof CmpSR) {
                    cs = (CmpSR)tmp;
                } else if (tmp != null) {
                    return tmp;
                }
            }
            if (tmp != null) continue;
            ex = Array.add(ex, e);
        }
        this.expr = ex;
        if (ps != null) {
            this.expr = Array.add(this.expr, ps);
        }
        if (cr != null) {
            this.expr = Array.add(this.expr, cr);
        }
        if (cs != null) {
            this.expr = Array.add(this.expr, cs);
        }
        if (ex.length != this.expr.length) {
            ctx.compInfo("rewriting %", this);
        }
        this.compFlatten(ctx);
        return this.expr.length == 1 ? this.compBln(this.expr[0]) : this;
    }

    @Override
    public Bln item(QueryContext ctx, InputInfo ii) throws QueryException {
        double s = 0.0;
        for (Expr e : this.expr) {
            Item it = e.ebv(ctx, this.info);
            if (!it.bool(this.info)) {
                return Bln.FALSE;
            }
            s = Scoring.and(s, it.score());
        }
        return s == 0.0 ? Bln.TRUE : Bln.get(s);
    }

    @Override
    public boolean indexAccessible(IndexContext ic) throws QueryException {
        int is = 0;
        int[] ics = new int[this.expr.length];
        boolean ia = true;
        for (int e = 0; e < this.expr.length; ++e) {
            if (this.expr[e].indexAccessible(ic) && !ic.seq) {
                if (ic.costs() == 0) {
                    return true;
                }
                ics[e] = ic.costs();
                if (is != 0 && ic.costs() >= is) continue;
                is = ic.costs();
                continue;
            }
            ia = false;
        }
        if (ia) {
            int[] ord = Array.createOrder(ics, true);
            Expr[] ex = new Expr[ics.length];
            for (int e = 0; e < this.expr.length; ++e) {
                ex[e] = this.expr[ord[e]];
            }
            this.expr = ex;
        }
        ic.costs(is);
        return ia;
    }

    @Override
    public Expr indexEquivalent(IndexContext ic) throws QueryException {
        super.indexEquivalent(ic);
        return new InterSect(this.info, this.expr);
    }

    @Override
    public String toString() {
        return this.toString(" and ");
    }
}

