/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.basex.core.Prop;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.util.Err;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.FElem;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.TokenList;

public final class FNProc
extends StandardFunc {
    private static final QNm E_RESULT = new QNm("result");
    private static final QNm E_OUTPUT = new QNm("output");
    private static final QNm E_ERROR = new QNm("error");
    private static final QNm E_CODE = new QNm("code");

    public FNProc(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        this.checkCreate(ctx);
        TokenList tl = new TokenList();
        tl.add(this.checkStr(this.expr[0], ctx));
        if (this.expr.length > 1) {
            Item it;
            Iter ir = ctx.iter(this.expr[1]);
            while ((it = ir.next()) != null) {
                tl.add(this.checkStr(it, ctx));
            }
        }
        String c = this.expr.length > 2 ? Token.string(this.checkStr(this.expr[2], ctx)) : Prop.ENCODING;
        Charset cs = null;
        try {
            cs = Charset.forName(c);
        }
        catch (Exception ex) {
            Err.BXPR_ENC.thrw(this.info, c);
        }
        String[] args = tl.toStringArray();
        switch (this.sig) {
            case _PROC_SYSTEM: {
                return this.system(args, cs);
            }
            case _PROC_EXECUTE: {
                return this.execute(args, cs);
            }
        }
        return super.item(ctx, ii);
    }

    private Str system(String[] args, Charset cs) throws QueryException {
        Result result = this.exec(args, cs);
        if (result.code == 0) {
            return Str.get(this.norm(result.output));
        }
        QNm name = new QNm("PROC" + String.format("%04d", result.code));
        throw new QueryException(this.info, name, Token.string(this.norm(result.error)), new Object[0]);
    }

    private FElem execute(String[] args, Charset cs) {
        Result result = this.exec(args, cs);
        FElem root = new FElem(E_RESULT);
        root.add(new FElem(E_OUTPUT).add(this.norm(result.output)));
        root.add(new FElem(E_ERROR).add(this.norm(result.error)));
        root.add(new FElem(E_CODE).add(Token.token(result.code)));
        return root;
    }

    private Result exec(String[] args, Charset cs) {
        Process proc;
        Result result = new Result();
        try {
            proc = new ProcessBuilder(args).start();
        }
        catch (IOException ex) {
            result.error.add(ex.getMessage());
            result.code = 9999;
            return result;
        }
        try {
            Thread outt = this.reader(proc.getInputStream(), result.output, cs);
            Thread errt = this.reader(proc.getErrorStream(), result.error, cs);
            outt.start();
            errt.start();
            proc.waitFor();
            outt.join();
            errt.join();
        }
        catch (InterruptedException ex) {
            result.error.add(ex.getMessage());
        }
        result.code = proc.exitValue();
        return result;
    }

    private Thread reader(InputStream in, final TokenBuilder tb, Charset cs) {
        InputStreamReader isr = new InputStreamReader(in, cs);
        final BufferedReader br = new BufferedReader(isr);
        return new Thread(){

            @Override
            public void run() {
                try {
                    int b;
                    while ((b = br.read()) != -1) {
                        tb.add(b);
                    }
                }
                catch (IOException ex) {
                    Util.stack(ex);
                }
            }
        };
    }

    private byte[] norm(TokenBuilder tb) {
        return Token.delete(tb.finish(), 13);
    }

    static class Result {
        final TokenBuilder output = new TokenBuilder();
        final TokenBuilder error = new TokenBuilder();
        int code;

        Result() {
        }
    }
}

