/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.node;

import org.basex.api.dom.BXAttr;
import org.basex.api.dom.BXComm;
import org.basex.api.dom.BXDoc;
import org.basex.api.dom.BXElem;
import org.basex.api.dom.BXNode;
import org.basex.api.dom.BXPI;
import org.basex.api.dom.BXText;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.iter.AxisIter;
import org.basex.query.iter.AxisMoreIter;
import org.basex.query.iter.NodeSeqBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.NodeType;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public abstract class ANode
extends Item {
    private static final NodeType[] TYPES = new NodeType[]{NodeType.DOC, NodeType.ELM, NodeType.TXT, NodeType.ATT, NodeType.COM, NodeType.PI};
    private static int sid;
    public final int id = ++sid;
    byte[] val;
    ANode par;

    ANode(NodeType t) {
        super(t);
    }

    @Override
    public final boolean bool(InputInfo ii) {
        return true;
    }

    @Override
    public final byte[] string(InputInfo ii) {
        return this.string();
    }

    public abstract byte[] string();

    @Override
    public final boolean eq(InputInfo ii, Item it) throws QueryException {
        return !it.type.isUntyped() ? it.eq(ii, this) : Token.eq(this.string(), it.string(ii));
    }

    @Override
    public final int diff(InputInfo ii, Item it) throws QueryException {
        return !it.type.isUntyped() ? -it.diff(ii, this) : Token.diff(this.string(), it.string(ii));
    }

    @Override
    public abstract ANode copy();

    public abstract ANode deepCopy();

    public byte[] name() {
        return null;
    }

    public QNm qname() {
        return null;
    }

    public abstract QNm qname(QNm var1);

    public ANode optimize() {
        return this;
    }

    public Atts namespaces() {
        return null;
    }

    public final Atts nsScope() {
        Atts ns = new Atts();
        ANode node = this;
        do {
            Atts n;
            if ((n = node.namespaces()) == null) continue;
            for (int a = n.size() - 1; a >= 0; --a) {
                byte[] key = n.name(a);
                if (ns.contains(key)) continue;
                ns.add(key, n.string(a));
            }
        } while ((node = node.parent()) != null && node.type == NodeType.ELM);
        return ns;
    }

    public final byte[] uri(byte[] pref, QueryContext ctx) {
        Atts at = this.namespaces();
        if (at != null) {
            int i = at.get(pref);
            if (i != -1) {
                return at.string(i);
            }
            ANode n = this.parent();
            if (n != null) {
                return n.uri(pref, ctx);
            }
        }
        return (byte[])(pref.length == 0 ? Token.EMPTY : null);
    }

    public byte[] baseURI() {
        return Token.EMPTY;
    }

    public abstract boolean is(ANode var1);

    public abstract int diff(ANode var1);

    public ANode finish() {
        return this;
    }

    public abstract ANode parent();

    public abstract ANode parent(ANode var1);

    public abstract boolean hasChildren();

    public byte[] attribute(QNm name) {
        ANode node;
        AxisMoreIter ai = this.attributes();
        do {
            if ((node = ai.next()) != null) continue;
            return null;
        } while (!node.qname().eq(name));
        return node.string();
    }

    public abstract AxisIter ancestor();

    public abstract AxisIter ancestorOrSelf();

    public abstract AxisMoreIter attributes();

    public abstract AxisMoreIter children();

    public abstract AxisIter descendant();

    public abstract AxisIter descendantOrSelf();

    public abstract AxisIter following();

    public abstract AxisIter followingSibling();

    public abstract AxisIter parentIter();

    public final AxisIter preceding() {
        return new AxisIter(){
            private NodeSeqBuilder nc;

            @Override
            public ANode next() {
                if (this.nc == null) {
                    this.nc = new NodeSeqBuilder();
                    ANode n = ANode.this;
                    for (ANode p = n.parent(); p != null; p = p.parent()) {
                        if (n.type != NodeType.ATT) {
                            ANode c;
                            NodeSeqBuilder tmp = new NodeSeqBuilder();
                            AxisMoreIter ai = p.children();
                            while ((c = ai.next()) != null && !c.is(n)) {
                                tmp.add(c.finish());
                                ANode.addDesc(c.children(), tmp);
                            }
                            for (long t = tmp.size() - 1L; t >= 0L; --t) {
                                this.nc.add(tmp.get(t));
                            }
                        }
                        n = p;
                    }
                }
                return this.nc.next();
            }
        };
    }

    public final AxisIter precedingSibling() {
        return new AxisIter(){
            private NodeSeqBuilder nc;
            private long c;

            @Override
            public ANode next() {
                if (this.nc == null) {
                    ANode n;
                    ANode r = ANode.this.parent();
                    if (r == null) {
                        return null;
                    }
                    this.nc = new NodeSeqBuilder();
                    AxisMoreIter ai = r.children();
                    while ((n = ai.next()) != null && !n.is(ANode.this)) {
                        this.nc.add(n.finish());
                    }
                    this.c = this.nc.size();
                }
                return this.c > 0L ? this.nc.get(--this.c) : null;
            }
        };
    }

    public final AxisMoreIter self() {
        return new AxisMoreIter(){
            private boolean more = true;

            @Override
            public boolean more() {
                return this.more;
            }

            @Override
            public ANode next() {
                return (this.more ^= true) ? null : ANode.this;
            }
        };
    }

    static final void addDesc(AxisMoreIter ch, NodeSeqBuilder nc) {
        ANode n;
        while ((n = ch.next()) != null) {
            nc.add(n.finish());
            ANode.addDesc(n.children(), nc);
        }
    }

    public int kind() {
        return ANode.kind(this.nodeType());
    }

    public static int kind(NodeType t) {
        switch (t) {
            case DOC: {
                return 0;
            }
            case ELM: {
                return 1;
            }
            case TXT: {
                return 2;
            }
            case ATT: {
                return 3;
            }
            case COM: {
                return 4;
            }
            case PI: {
                return 5;
            }
        }
        return -1;
    }

    public static NodeType type(int k) {
        return TYPES[k];
    }

    @Override
    public final BXNode toJava() {
        switch (this.nodeType()) {
            case DOC: {
                return new BXDoc(this);
            }
            case ELM: {
                return new BXElem(this);
            }
            case TXT: {
                return new BXText(this);
            }
            case ATT: {
                return new BXAttr(this);
            }
            case COM: {
                return new BXComm(this);
            }
            case PI: {
                return new BXPI(this);
            }
        }
        return null;
    }

    public final NodeType nodeType() {
        return (NodeType)this.type;
    }
}

