/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.ft;

import java.util.Collection;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.ft.FTIterator;
import org.basex.util.ft.InternalStemmer;
import org.basex.util.ft.Language;

public class GreekStemmer
extends InternalStemmer {
    private static final String[] EXC4 = new String[]{"\u03b8", "\u03b4", "\u03b5\u03bb", "\u03b3\u03b1\u03bb", "\u03bd", "\u03c0", "\u03b9\u03b4", "\u03c0\u03b1\u03c1"};
    private static final String[] EXC6 = new String[]{"\u03b1\u03bb", "\u03b1\u03b4", "\u03b5\u03bd\u03b4", "\u03b1\u03bc\u03b1\u03bd", "\u03b1\u03bc\u03bc\u03bf\u03c7\u03b1\u03bb", "\u03b7\u03b8", "\u03b1\u03bd\u03b7\u03b8", "\u03b1\u03bd\u03c4\u03b9\u03b4", "\u03c6\u03c5\u03c3", "\u03b2\u03c1\u03c9\u03bc", "\u03b3\u03b5\u03c1", "\u03b5\u03be\u03c9\u03b4", "\u03ba\u03b1\u03bb\u03c0", "\u03ba\u03b1\u03bb\u03bb\u03b9\u03bd", "\u03ba\u03b1\u03c4\u03b1\u03b4", "\u03bc\u03bf\u03c5\u03bb", "\u03bc\u03c0\u03b1\u03bd", "\u03bc\u03c0\u03b1\u03b3\u03b9\u03b1\u03c4", "\u03bc\u03c0\u03bf\u03bb", "\u03bc\u03c0\u03bf\u03c3", "\u03bd\u03b9\u03c4", "\u03be\u03b9\u03ba", "\u03c3\u03c5\u03bd\u03bf\u03bc\u03b7\u03bb", "\u03c0\u03b5\u03c4\u03c3", "\u03c0\u03b9\u03c4\u03c3", "\u03c0\u03b9\u03ba\u03b1\u03bd\u03c4", "\u03c0\u03bb\u03b9\u03b1\u03c4\u03c3", "\u03c0\u03bf\u03c3\u03c4\u03b5\u03bb\u03bd", "\u03c0\u03c1\u03c9\u03c4\u03bf\u03b4", "\u03c3\u03b5\u03c1\u03c4", "\u03c3\u03c5\u03bd\u03b1\u03b4", "\u03c4\u03c3\u03b1\u03bc", "\u03c5\u03c0\u03bf\u03b4", "\u03c6\u03b9\u03bb\u03bf\u03bd", "\u03c6\u03c5\u03bb\u03bf\u03b4", "\u03c7\u03b1\u03c3"};
    private static final String[] EXC7 = new String[]{"\u03b1\u03bd\u03b1\u03c0", "\u03b1\u03c0\u03bf\u03b8", "\u03b1\u03c0\u03bf\u03ba", "\u03b1\u03c0\u03bf\u03c3\u03c4", "\u03b2\u03bf\u03c5\u03b2", "\u03be\u03b5\u03b8", "\u03bf\u03c5\u03bb", "\u03c0\u03b5\u03b8", "\u03c0\u03b9\u03ba\u03c1", "\u03c0\u03bf\u03c4", "\u03c3\u03b9\u03c7", "\u03c7"};
    private static final String[] EXC8A = new String[]{"\u03c4\u03c1", "\u03c4\u03c3"};
    private static final String[] EXC8B = new String[]{"\u03b2\u03b5\u03c4\u03b5\u03c1", "\u03b2\u03bf\u03c5\u03bb\u03ba", "\u03b2\u03c1\u03b1\u03c7\u03bc", "\u03b3", "\u03b4\u03c1\u03b1\u03b4\u03bf\u03c5\u03bc", "\u03b8", "\u03ba\u03b1\u03bb\u03c0\u03bf\u03c5\u03b6", "\u03ba\u03b1\u03c3\u03c4\u03b5\u03bb", "\u03ba\u03bf\u03c1\u03bc\u03bf\u03c1", "\u03bb\u03b1\u03bf\u03c0\u03bb", "\u03bc\u03c9\u03b1\u03bc\u03b5\u03b8", "\u03bc", "\u03bc\u03bf\u03c5\u03c3\u03bf\u03c5\u03bb\u03bc", "\u03bd", "\u03bf\u03c5\u03bb", "\u03c0", "\u03c0\u03b5\u03bb\u03b5\u03ba", "\u03c0\u03bb", "\u03c0\u03bf\u03bb\u03b9\u03c3", "\u03c0\u03bf\u03c1\u03c4\u03bf\u03bb", "\u03c3\u03b1\u03c1\u03b1\u03ba\u03b1\u03c4\u03c3", "\u03c3\u03bf\u03c5\u03bb\u03c4", "\u03c4\u03c3\u03b1\u03c1\u03bb\u03b1\u03c4", "\u03bf\u03c1\u03c6", "\u03c4\u03c3\u03b9\u03b3\u03b3", "\u03c4\u03c3\u03bf\u03c0", "\u03c6\u03c9\u03c4\u03bf\u03c3\u03c4\u03b5\u03c6", "\u03c7", "\u03c8\u03c5\u03c7\u03bf\u03c0\u03bb", "\u03b1\u03b3", "\u03bf\u03c1\u03c6", "\u03b3\u03b1\u03bb", "\u03b3\u03b5\u03c1", "\u03b4\u03b5\u03ba", "\u03b4\u03b9\u03c0\u03bb", "\u03b1\u03bc\u03b5\u03c1\u03b9\u03ba\u03b1\u03bd", "\u03bf\u03c5\u03c1", "\u03c0\u03b9\u03b8", "\u03c0\u03bf\u03c5\u03c1\u03b9\u03c4", "\u03c3", "\u03b6\u03c9\u03bd\u03c4", "\u03b9\u03ba", "\u03ba\u03b1\u03c3\u03c4", "\u03ba\u03bf\u03c0", "\u03bb\u03b9\u03c7", "\u03bb\u03bf\u03c5\u03b8\u03b7\u03c1", "\u03bc\u03b1\u03b9\u03bd\u03c4", "\u03bc\u03b5\u03bb", "\u03c3\u03b9\u03b3", "\u03c3\u03c0", "\u03c3\u03c4\u03b5\u03b3", "\u03c4\u03c1\u03b1\u03b3", "\u03c4\u03c3\u03b1\u03b3", "\u03c6", "\u03b5\u03c1", "\u03b1\u03b4\u03b1\u03c0", "\u03b1\u03b8\u03b9\u03b3\u03b3", "\u03b1\u03bc\u03b7\u03c7", "\u03b1\u03bd\u03b9\u03ba", "\u03b1\u03bd\u03bf\u03c1\u03b3", "\u03b1\u03c0\u03b7\u03b3", "\u03b1\u03c0\u03b9\u03b8", "\u03b1\u03c4\u03c3\u03b9\u03b3\u03b3", "\u03b2\u03b1\u03c3", "\u03b2\u03b1\u03c3\u03ba", "\u03b2\u03b1\u03b8\u03c5\u03b3\u03b1\u03bb", "\u03b2\u03b9\u03bf\u03bc\u03b7\u03c7", "\u03b2\u03c1\u03b1\u03c7\u03c5\u03ba", "\u03b4\u03b9\u03b1\u03c4", "\u03b4\u03b9\u03b1\u03c6", "\u03b5\u03bd\u03bf\u03c1\u03b3", "\u03b8\u03c5\u03c3", "\u03ba\u03b1\u03c0\u03bd\u03bf\u03b2\u03b9\u03bf\u03bc\u03b7\u03c7", "\u03ba\u03b1\u03c4\u03b1\u03b3\u03b1\u03bb", "\u03ba\u03bb\u03b9\u03b2", "\u03ba\u03bf\u03b9\u03bb\u03b1\u03c1\u03c6", "\u03bb\u03b9\u03b2", "\u03bc\u03b5\u03b3\u03bb\u03bf\u03b2\u03b9\u03bf\u03bc\u03b7\u03c7", "\u03bc\u03b9\u03ba\u03c1\u03bf\u03b2\u03b9\u03bf\u03bc\u03b7\u03c7", "\u03bd\u03c4\u03b1\u03b2", "\u03be\u03b7\u03c1\u03bf\u03ba\u03bb\u03b9\u03b2", "\u03bf\u03bb\u03b9\u03b3\u03bf\u03b4\u03b1\u03bc", "\u03bf\u03bb\u03bf\u03b3\u03b1\u03bb", "\u03c0\u03b5\u03bd\u03c4\u03b1\u03c1\u03c6", "\u03c0\u03b5\u03c1\u03b7\u03c6", "\u03c0\u03b5\u03c1\u03b9\u03c4\u03c1", "\u03c0\u03bb\u03b1\u03c4", "\u03c0\u03bf\u03bb\u03c5\u03b4\u03b1\u03c0", "\u03c0\u03bf\u03bb\u03c5\u03bc\u03b7\u03c7", "\u03c3\u03c4\u03b5\u03c6", "\u03c4\u03b1\u03b2", "\u03c4\u03b5\u03c4", "\u03c5\u03c0\u03b5\u03c1\u03b7\u03c6", "\u03c5\u03c0\u03bf\u03ba\u03bf\u03c0", "\u03c7\u03b1\u03bc\u03b7\u03bb\u03bf\u03b4\u03b1\u03c0", "\u03c8\u03b7\u03bb\u03bf\u03c4\u03b1\u03b2"};
    private static final String[] EXC9 = new String[]{"\u03b1\u03b2\u03b1\u03c1", "\u03b2\u03b5\u03bd", "\u03b5\u03bd\u03b1\u03c1", "\u03b1\u03b2\u03c1", "\u03b1\u03b4", "\u03b1\u03b8", "\u03b1\u03bd", "\u03b1\u03c0\u03bb", "\u03b2\u03b1\u03c1\u03bf\u03bd", "\u03bd\u03c4\u03c1", "\u03c3\u03ba", "\u03ba\u03bf\u03c0", "\u03bc\u03c0\u03bf\u03c1", "\u03bd\u03b9\u03c6", "\u03c0\u03b1\u03b3", "\u03c0\u03b1\u03c1\u03b1\u03ba\u03b1\u03bb", "\u03c3\u03b5\u03c1\u03c0", "\u03c3\u03ba\u03b5\u03bb", "\u03c3\u03c5\u03c1\u03c6", "\u03c4\u03bf\u03ba", "\u03c5", "\u03b4", "\u03b5\u03bc", "\u03b8\u03b1\u03c1\u03c1", "\u03b8"};
    private static final String[] EXC12A = new String[]{"\u03c0", "\u03b1\u03c0", "\u03c3\u03c5\u03bc\u03c0", "\u03b1\u03c3\u03c5\u03bc\u03c0", "\u03b1\u03ba\u03b1\u03c4\u03b1\u03c0", "\u03b1\u03bc\u03b5\u03c4\u03b1\u03bc\u03c6"};
    private static final String[] EXC12B = new String[]{"\u03b1\u03bb", "\u03b1\u03c1", "\u03b5\u03ba\u03c4\u03b5\u03bb", "\u03b6", "\u03bc", "\u03be", "\u03c0\u03b1\u03c1\u03b1\u03ba\u03b1\u03bb", "\u03b1\u03c1", "\u03c0\u03c1\u03bf", "\u03bd\u03b9\u03c3"};
    private static final String[] EXC13 = new String[]{"\u03b4\u03b9\u03b1\u03b8", "\u03b8", "\u03c0\u03b1\u03c1\u03b1\u03ba\u03b1\u03c4\u03b1\u03b8", "\u03c0\u03c1\u03bf\u03c3\u03b8", "\u03c3\u03c5\u03bd\u03b8"};
    private static final String[] EXC14 = new String[]{"\u03c6\u03b1\u03c1\u03bc\u03b1\u03ba", "\u03c7\u03b1\u03b4", "\u03b1\u03b3\u03ba", "\u03b1\u03bd\u03b1\u03c1\u03c1", "\u03b2\u03c1\u03bf\u03bc", "\u03b5\u03ba\u03bb\u03b9\u03c0", "\u03bb\u03b1\u03bc\u03c0\u03b9\u03b4", "\u03bb\u03b5\u03c7", "\u03bc", "\u03c0\u03b1\u03c4", "\u03c1", "\u03bb", "\u03bc\u03b5\u03b4", "\u03bc\u03b5\u03c3\u03b1\u03b6", "\u03c5\u03c0\u03bf\u03c4\u03b5\u03b9\u03bd", "\u03b1\u03bc", "\u03b1\u03b9\u03b8", "\u03b1\u03bd\u03b7\u03ba", "\u03b4\u03b5\u03c3\u03c0\u03bf\u03b6", "\u03b5\u03bd\u03b4\u03b9\u03b1\u03c6\u03b5\u03c1", "\u03b4\u03b5", "\u03b4\u03b5\u03c5\u03c4\u03b5\u03c1\u03b5\u03c5", "\u03ba\u03b1\u03b8\u03b1\u03c1\u03b5\u03c5", "\u03c0\u03bb\u03b5", "\u03c4\u03c3\u03b1"};
    private static final String[] EXC15A = new String[]{"\u03b1\u03b2\u03b1\u03c3\u03c4", "\u03c0\u03bf\u03bb\u03c5\u03c6", "\u03b1\u03b4\u03b7\u03c6", "\u03c0\u03b1\u03bc\u03c6", "\u03c1", "\u03b1\u03c3\u03c0", "\u03b1\u03c6", "\u03b1\u03bc\u03b1\u03bb", "\u03b1\u03bc\u03b1\u03bb\u03bb\u03b9", "\u03b1\u03bd\u03c5\u03c3\u03c4", "\u03b1\u03c0\u03b5\u03c1", "\u03b1\u03c3\u03c0\u03b1\u03c1", "\u03b1\u03c7\u03b1\u03c1", "\u03b4\u03b5\u03c1\u03b2\u03b5\u03bd", "\u03b4\u03c1\u03bf\u03c3\u03bf\u03c0", "\u03be\u03b5\u03c6", "\u03bd\u03b5\u03bf\u03c0", "\u03bd\u03bf\u03bc\u03bf\u03c4", "\u03bf\u03bb\u03bf\u03c0", "\u03bf\u03bc\u03bf\u03c4", "\u03c0\u03c1\u03bf\u03c3\u03c4", "\u03c0\u03c1\u03bf\u03c3\u03c9\u03c0\u03bf\u03c0", "\u03c3\u03c5\u03bc\u03c0", "\u03c3\u03c5\u03bd\u03c4", "\u03c4", "\u03c5\u03c0\u03bf\u03c4", "\u03c7\u03b1\u03c1", "\u03b1\u03b5\u03b9\u03c0", "\u03b1\u03b9\u03bc\u03bf\u03c3\u03c4", "\u03b1\u03bd\u03c5\u03c0", "\u03b1\u03c0\u03bf\u03c4", "\u03b1\u03c1\u03c4\u03b9\u03c0", "\u03b4\u03b9\u03b1\u03c4", "\u03b5\u03bd", "\u03b5\u03c0\u03b9\u03c4", "\u03ba\u03c1\u03bf\u03ba\u03b1\u03bb\u03bf\u03c0", "\u03c3\u03b9\u03b4\u03b7\u03c1\u03bf\u03c0", "\u03bb", "\u03bd\u03b1\u03c5", "\u03bf\u03c5\u03bb\u03b1\u03bc", "\u03bf\u03c5\u03c1", "\u03c0", "\u03c4\u03c1", "\u03bc"};
    private static final String[] EXC15B = new String[]{"\u03c8\u03bf\u03c6", "\u03bd\u03b1\u03c5\u03bb\u03bf\u03c7"};
    private static final String[] EXC16 = new String[]{"\u03bd", "\u03c7\u03b5\u03c1\u03c3\u03bf\u03bd", "\u03b4\u03c9\u03b4\u03b5\u03ba\u03b1\u03bd", "\u03b5\u03c1\u03b7\u03bc\u03bf\u03bd", "\u03bc\u03b5\u03b3\u03b1\u03bb\u03bf\u03bd", "\u03b5\u03c0\u03c4\u03b1\u03bd"};
    private static final String[] EXC17 = new String[]{"\u03b1\u03c3\u03b2", "\u03c3\u03b2", "\u03b1\u03c7\u03c1", "\u03c7\u03c1", "\u03b1\u03c0\u03bb", "\u03b1\u03b5\u03b9\u03bc\u03bd", "\u03b4\u03c5\u03c3\u03c7\u03c1", "\u03b5\u03c5\u03c7\u03c1", "\u03ba\u03bf\u03b9\u03bd\u03bf\u03c7\u03c1", "\u03c0\u03b1\u03bb\u03b9\u03bc\u03c8"};
    private static final String[] EXC18 = new String[]{"\u03bd", "\u03c1", "\u03c3\u03c0\u03b9", "\u03c3\u03c4\u03c1\u03b1\u03b2\u03bf\u03bc\u03bf\u03c5\u03c4\u03c3", "\u03ba\u03b1\u03ba\u03bf\u03bc\u03bf\u03c5\u03c4\u03c3", "\u03b5\u03be\u03c9\u03bd"};
    private static final String[] EXC19 = new String[]{"\u03c0\u03b1\u03c1\u03b1\u03c3\u03bf\u03c5\u03c3", "\u03c6", "\u03c7", "\u03c9\u03c1\u03b9\u03bf\u03c0\u03bb", "\u03b1\u03b6", "\u03b1\u03bb\u03bb\u03bf\u03c3\u03bf\u03c5\u03c3", "\u03b1\u03c3\u03bf\u03c5\u03c3"};

    GreekStemmer(FTIterator fti) {
        super(fti);
    }

    @Override
    GreekStemmer get(Language l, FTIterator fti) {
        return new GreekStemmer(fti);
    }

    @Override
    Collection<Language> languages() {
        return GreekStemmer.collection("el");
    }

    @Override
    protected byte[] stem(byte[] word) {
        int ln = 0;
        int wl = word.length;
        char[] s = new char[wl];
        for (int i = 0; i < wl; i += Token.cl(word, i)) {
            s[ln++] = (char)Token.cp(word, i);
        }
        if (ln < 4) {
            return word;
        }
        int olen = ln;
        int l = this.rule0(s, ln);
        l = this.rule1(s, l);
        l = this.rule2(s, l);
        l = this.rule3(s, l);
        l = this.rule4(s, l);
        l = this.rule5(s, l);
        l = this.rule6(s, l);
        l = this.rule7(s, l);
        l = this.rule8(s, l);
        l = this.rule9(s, l);
        l = this.rule10(s, l);
        l = this.rule11(s, l);
        l = this.rule12(s, l);
        l = this.rule13(s, l);
        l = this.rule14(s, l);
        l = this.rule15(s, l);
        l = this.rule16(s, l);
        l = this.rule17(s, l);
        l = this.rule18(s, l);
        l = this.rule19(s, l);
        if ((l = this.rule20(s, l)) == olen) {
            l = this.rule21(s, l);
        }
        l = this.rule22(s, l);
        TokenBuilder tb = new TokenBuilder(l << 1);
        for (int i = 0; i < l; ++i) {
            tb.add(s[i]);
        }
        return tb.finish();
    }

    private int rule0(char[] s, int l) {
        if (l > 9 && (this.e(s, l, "\u03ba\u03b1\u03b8\u03b5\u03c3\u03c4\u03c9\u03c4\u03bf\u03c3") || this.e(s, l, "\u03ba\u03b1\u03b8\u03b5\u03c3\u03c4\u03c9\u03c4\u03c9\u03bd"))) {
            return l - 4;
        }
        if (l > 8 && (this.e(s, l, "\u03b3\u03b5\u03b3\u03bf\u03bd\u03bf\u03c4\u03bf\u03c3") || this.e(s, l, "\u03b3\u03b5\u03b3\u03bf\u03bd\u03bf\u03c4\u03c9\u03bd"))) {
            return l - 4;
        }
        if (l > 8 && this.e(s, l, "\u03ba\u03b1\u03b8\u03b5\u03c3\u03c4\u03c9\u03c4\u03b1")) {
            return l - 3;
        }
        if (l > 7 && (this.e(s, l, "\u03c4\u03b1\u03c4\u03bf\u03b3\u03b9\u03bf\u03c5") || this.e(s, l, "\u03c4\u03b1\u03c4\u03bf\u03b3\u03b9\u03c9\u03bd"))) {
            return l - 4;
        }
        if (l > 7 && this.e(s, l, "\u03b3\u03b5\u03b3\u03bf\u03bd\u03bf\u03c4\u03b1")) {
            return l - 3;
        }
        if (l > 7 && this.e(s, l, "\u03ba\u03b1\u03b8\u03b5\u03c3\u03c4\u03c9\u03c3")) {
            return l - 2;
        }
        if (l > 6 && this.e(s, l, "\u03c3\u03ba\u03b1\u03b3\u03b9\u03bf\u03c5") || this.e(s, l, "\u03c3\u03ba\u03b1\u03b3\u03b9\u03c9\u03bd") || this.e(s, l, "\u03bf\u03bb\u03bf\u03b3\u03b9\u03bf\u03c5") || this.e(s, l, "\u03bf\u03bb\u03bf\u03b3\u03b9\u03c9\u03bd") || this.e(s, l, "\u03ba\u03c1\u03b5\u03b1\u03c4\u03bf\u03c3") || this.e(s, l, "\u03ba\u03c1\u03b5\u03b1\u03c4\u03c9\u03bd") || this.e(s, l, "\u03c0\u03b5\u03c1\u03b1\u03c4\u03bf\u03c3") || this.e(s, l, "\u03c0\u03b5\u03c1\u03b1\u03c4\u03c9\u03bd") || this.e(s, l, "\u03c4\u03b5\u03c1\u03b1\u03c4\u03bf\u03c3") || this.e(s, l, "\u03c4\u03b5\u03c1\u03b1\u03c4\u03c9\u03bd")) {
            return l - 4;
        }
        if (l > 6 && this.e(s, l, "\u03c4\u03b1\u03c4\u03bf\u03b3\u03b9\u03b1")) {
            return l - 3;
        }
        if (l > 6 && this.e(s, l, "\u03b3\u03b5\u03b3\u03bf\u03bd\u03bf\u03c3")) {
            return l - 2;
        }
        if (l > 5 && (this.e(s, l, "\u03c6\u03b1\u03b3\u03b9\u03bf\u03c5") || this.e(s, l, "\u03c6\u03b1\u03b3\u03b9\u03c9\u03bd") || this.e(s, l, "\u03c3\u03bf\u03b3\u03b9\u03bf\u03c5") || this.e(s, l, "\u03c3\u03bf\u03b3\u03b9\u03c9\u03bd"))) {
            return l - 4;
        }
        if (l > 5 && (this.e(s, l, "\u03c3\u03ba\u03b1\u03b3\u03b9\u03b1") || this.e(s, l, "\u03bf\u03bb\u03bf\u03b3\u03b9\u03b1") || this.e(s, l, "\u03ba\u03c1\u03b5\u03b1\u03c4\u03b1") || this.e(s, l, "\u03c0\u03b5\u03c1\u03b1\u03c4\u03b1") || this.e(s, l, "\u03c4\u03b5\u03c1\u03b1\u03c4\u03b1"))) {
            return l - 3;
        }
        if (l > 4 && (this.e(s, l, "\u03c6\u03b1\u03b3\u03b9\u03b1") || this.e(s, l, "\u03c3\u03bf\u03b3\u03b9\u03b1") || this.e(s, l, "\u03c6\u03c9\u03c4\u03bf\u03c3") || this.e(s, l, "\u03c6\u03c9\u03c4\u03c9\u03bd"))) {
            return l - 3;
        }
        if (l > 4 && (this.e(s, l, "\u03ba\u03c1\u03b5\u03b1\u03c3") || this.e(s, l, "\u03c0\u03b5\u03c1\u03b1\u03c3") || this.e(s, l, "\u03c4\u03b5\u03c1\u03b1\u03c3"))) {
            return l - 2;
        }
        if (l > 3 && this.e(s, l, "\u03c6\u03c9\u03c4\u03b1")) {
            return l - 2;
        }
        if (l > 2 && this.e(s, l, "\u03c6\u03c9\u03c3")) {
            return l - 1;
        }
        return l;
    }

    private int rule1(char[] s, int l) {
        int len = l;
        if (!(len <= 4 || !this.e(s, len, "\u03b1\u03b4\u03b5\u03c3") && !this.e(s, len, "\u03b1\u03b4\u03c9\u03bd") || this.e(s, len -= 4, "\u03bf\u03ba") || this.e(s, len, "\u03bc\u03b1\u03bc") || this.e(s, len, "\u03bc\u03b1\u03bd") || this.e(s, len, "\u03bc\u03c0\u03b1\u03bc\u03c0") || this.e(s, len, "\u03c0\u03b1\u03c4\u03b5\u03c1") || this.e(s, len, "\u03b3\u03b9\u03b1\u03b3\u03b9") || this.e(s, len, "\u03bd\u03c4\u03b1\u03bd\u03c4") || this.e(s, len, "\u03ba\u03c5\u03c1") || this.e(s, len, "\u03b8\u03b5\u03b9") || this.e(s, len, "\u03c0\u03b5\u03b8\u03b5\u03c1"))) {
            len += 2;
        }
        return len;
    }

    private int rule2(char[] s, int l) {
        int len = l;
        if (len > 4 && (this.e(s, len, "\u03b5\u03b4\u03b5\u03c3") || this.e(s, len, "\u03b5\u03b4\u03c9\u03bd")) && (this.e(s, len -= 4, "\u03bf\u03c0") || this.e(s, len, "\u03b9\u03c0") || this.e(s, len, "\u03b5\u03bc\u03c0") || this.e(s, len, "\u03c5\u03c0") || this.e(s, len, "\u03b3\u03b7\u03c0") || this.e(s, len, "\u03b4\u03b1\u03c0") || this.e(s, len, "\u03ba\u03c1\u03b1\u03c3\u03c0") || this.e(s, len, "\u03bc\u03b9\u03bb"))) {
            len += 2;
        }
        return len;
    }

    private int rule3(char[] s, int l) {
        int len = l;
        if (len > 5 && (this.e(s, len, "\u03bf\u03c5\u03b4\u03b5\u03c3") || this.e(s, len, "\u03bf\u03c5\u03b4\u03c9\u03bd")) && (this.e(s, len -= 5, "\u03b1\u03c1\u03ba") || this.e(s, len, "\u03ba\u03b1\u03bb\u03b9\u03b1\u03ba") || this.e(s, len, "\u03c0\u03b5\u03c4\u03b1\u03bb") || this.e(s, len, "\u03bb\u03b9\u03c7") || this.e(s, len, "\u03c0\u03bb\u03b5\u03be") || this.e(s, len, "\u03c3\u03ba") || this.e(s, len, "\u03c3") || this.e(s, len, "\u03c6\u03bb") || this.e(s, len, "\u03c6\u03c1") || this.e(s, len, "\u03b2\u03b5\u03bb") || this.e(s, len, "\u03bb\u03bf\u03c5\u03bb") || this.e(s, len, "\u03c7\u03bd") || this.e(s, len, "\u03c3\u03c0") || this.e(s, len, "\u03c4\u03c1\u03b1\u03b3") || this.e(s, len, "\u03c6\u03b5"))) {
            len += 3;
        }
        return len;
    }

    private int rule4(char[] s, int l) {
        int len = l;
        if (len > 3 && (this.e(s, len, "\u03b5\u03c9\u03c3") || this.e(s, len, "\u03b5\u03c9\u03bd")) && this.c(EXC4, s, len -= 3)) {
            ++len;
        }
        return len;
    }

    private int rule5(char[] s, int l) {
        int len = l;
        if (len > 2 && this.e(s, len, "\u03b9\u03b1")) {
            if (this.ev(s, len -= 2)) {
                ++len;
            }
        } else if (len > 3 && (this.e(s, len, "\u03b9\u03bf\u03c5") || this.e(s, len, "\u03b9\u03c9\u03bd")) && this.ev(s, len -= 3)) {
            ++len;
        }
        return len;
    }

    private int rule6(char[] s, int l) {
        int len = l;
        boolean rem = false;
        if (len > 3 && (this.e(s, len, "\u03b9\u03ba\u03b1") || this.e(s, len, "\u03b9\u03ba\u03bf"))) {
            len -= 3;
            rem = true;
        } else if (len > 4 && (this.e(s, len, "\u03b9\u03ba\u03bf\u03c5") || this.e(s, len, "\u03b9\u03ba\u03c9\u03bd"))) {
            len -= 4;
            rem = true;
        }
        if (rem && (this.ev(s, len) || this.c(EXC6, s, len))) {
            len += 2;
        }
        return len;
    }

    private int rule7(char[] s, int l) {
        int len = l;
        if (len == 5 && this.e(s, len, "\u03b1\u03b3\u03b1\u03bc\u03b5")) {
            return len - 1;
        }
        if (len > 7 && this.e(s, len, "\u03b7\u03b8\u03b7\u03ba\u03b1\u03bc\u03b5")) {
            len -= 7;
        } else if (len > 6 && this.e(s, len, "\u03bf\u03c5\u03c3\u03b1\u03bc\u03b5")) {
            len -= 6;
        } else if (len > 5 && (this.e(s, len, "\u03b1\u03b3\u03b1\u03bc\u03b5") || this.e(s, len, "\u03b7\u03c3\u03b1\u03bc\u03b5") || this.e(s, len, "\u03b7\u03ba\u03b1\u03bc\u03b5"))) {
            len -= 5;
        }
        if (len > 3 && this.e(s, len, "\u03b1\u03bc\u03b5") && this.c(EXC7, s, len -= 3)) {
            len += 2;
        }
        return len;
    }

    private int rule8(char[] s, int l) {
        boolean rem = false;
        int len = l;
        if (len > 8 && this.e(s, len, "\u03b9\u03bf\u03c5\u03bd\u03c4\u03b1\u03bd\u03b5")) {
            len -= 8;
            rem = true;
        } else if (len > 7 && this.e(s, len, "\u03b9\u03bf\u03bd\u03c4\u03b1\u03bd\u03b5") || this.e(s, len, "\u03bf\u03c5\u03bd\u03c4\u03b1\u03bd\u03b5") || this.e(s, len, "\u03b7\u03b8\u03b7\u03ba\u03b1\u03bd\u03b5")) {
            len -= 7;
            rem = true;
        } else if (len > 6 && this.e(s, len, "\u03b9\u03bf\u03c4\u03b1\u03bd\u03b5") || this.e(s, len, "\u03bf\u03bd\u03c4\u03b1\u03bd\u03b5") || this.e(s, len, "\u03bf\u03c5\u03c3\u03b1\u03bd\u03b5")) {
            len -= 6;
            rem = true;
        } else if (len > 5 && this.e(s, len, "\u03b1\u03b3\u03b1\u03bd\u03b5") || this.e(s, len, "\u03b7\u03c3\u03b1\u03bd\u03b5") || this.e(s, len, "\u03bf\u03c4\u03b1\u03bd\u03b5") || this.e(s, len, "\u03b7\u03ba\u03b1\u03bd\u03b5")) {
            len -= 5;
            rem = true;
        }
        if (rem && this.c(EXC8A, s, len)) {
            s[(len += 4) - 4] = 945;
            s[len - 3] = 947;
            s[len - 2] = 945;
            s[len - 1] = 957;
        }
        if (len > 3 && this.e(s, len, "\u03b1\u03bd\u03b5") && (this.ey(s, len -= 3) || this.c(EXC8B, s, len))) {
            len += 2;
        }
        return len;
    }

    private int rule9(char[] s, int l) {
        int len = l;
        if (len > 5 && this.e(s, len, "\u03b7\u03c3\u03b5\u03c4\u03b5")) {
            len -= 5;
        }
        if (len > 3 && this.e(s, len, "\u03b5\u03c4\u03b5") && (this.c(EXC9, s, len -= 3) || this.ey(s, len) || this.e(s, len, "\u03bf\u03b4") || this.e(s, len, "\u03b1\u03b9\u03c1") || this.e(s, len, "\u03c6\u03bf\u03c1") || this.e(s, len, "\u03c4\u03b1\u03b8") || this.e(s, len, "\u03b4\u03b9\u03b1\u03b8") || this.e(s, len, "\u03c3\u03c7") || this.e(s, len, "\u03b5\u03bd\u03b4") || this.e(s, len, "\u03b5\u03c5\u03c1") || this.e(s, len, "\u03c4\u03b9\u03b8") || this.e(s, len, "\u03c5\u03c0\u03b5\u03c1\u03b8") || this.e(s, len, "\u03c1\u03b1\u03b8") || this.e(s, len, "\u03b5\u03bd\u03b8") || this.e(s, len, "\u03c1\u03bf\u03b8") || this.e(s, len, "\u03c3\u03b8") || this.e(s, len, "\u03c0\u03c5\u03c1") || this.e(s, len, "\u03b1\u03b9\u03bd") || this.e(s, len, "\u03c3\u03c5\u03bd\u03b4") || this.e(s, len, "\u03c3\u03c5\u03bd") || this.e(s, len, "\u03c3\u03c5\u03bd\u03b8") || this.e(s, len, "\u03c7\u03c9\u03c1") || this.e(s, len, "\u03c0\u03bf\u03bd") || this.e(s, len, "\u03b2\u03c1") || this.e(s, len, "\u03ba\u03b1\u03b8") || this.e(s, len, "\u03b5\u03c5\u03b8") || this.e(s, len, "\u03b5\u03ba\u03b8") || this.e(s, len, "\u03bd\u03b5\u03c4") || this.e(s, len, "\u03c1\u03bf\u03bd") || this.e(s, len, "\u03b1\u03c1\u03ba") || this.e(s, len, "\u03b2\u03b1\u03c1") || this.e(s, len, "\u03b2\u03bf\u03bb") || this.e(s, len, "\u03c9\u03c6\u03b5\u03bb"))) {
            len += 2;
        }
        return len;
    }

    private int rule10(char[] s, int l) {
        int len = l;
        if (len > 5 && (this.e(s, len, "\u03bf\u03bd\u03c4\u03b1\u03c3") || this.e(s, len, "\u03c9\u03bd\u03c4\u03b1\u03c3"))) {
            if ((len -= 5) == 3 && this.e(s, len, "\u03b1\u03c1\u03c7")) {
                s[(len += 3) - 3] = 959;
            }
            if (this.e(s, len, "\u03ba\u03c1\u03b5")) {
                s[(len += 3) - 3] = 969;
            }
        }
        return len;
    }

    private int rule11(char[] s, int l) {
        int len = l;
        if (len > 6 && this.e(s, len, "\u03bf\u03bc\u03b1\u03c3\u03c4\u03b5")) {
            if ((len -= 6) == 2 && this.e(s, len, "\u03bf\u03bd")) {
                len += 5;
            }
        } else if (len > 7 && this.e(s, len, "\u03b9\u03bf\u03bc\u03b1\u03c3\u03c4\u03b5") && (len -= 7) == 2 && this.e(s, len, "\u03bf\u03bd")) {
            s[(len += 5) - 5] = 959;
            s[len - 4] = 956;
            s[len - 3] = 945;
            s[len - 2] = 963;
            s[len - 1] = 964;
        }
        return len;
    }

    private int rule12(char[] s, int l) {
        int len = l;
        if (len > 5 && this.e(s, len, "\u03b9\u03b5\u03c3\u03c4\u03b5") && this.c(EXC12A, s, len -= 5)) {
            len += 4;
        }
        if (len > 4 && this.e(s, len, "\u03b5\u03c3\u03c4\u03b5") && this.c(EXC12B, s, len -= 4)) {
            len += 3;
        }
        return len;
    }

    private int rule13(char[] s, int l) {
        int len = l;
        if (len > 6 && this.e(s, len, "\u03b7\u03b8\u03b7\u03ba\u03b5\u03c3")) {
            len -= 6;
        } else if (len > 5 && (this.e(s, len, "\u03b7\u03b8\u03b7\u03ba\u03b1") || this.e(s, len, "\u03b7\u03b8\u03b7\u03ba\u03b5"))) {
            len -= 5;
        }
        boolean rem = false;
        if (len > 4 && this.e(s, len, "\u03b7\u03ba\u03b5\u03c3")) {
            len -= 4;
            rem = true;
        } else if (len > 3 && (this.e(s, len, "\u03b7\u03ba\u03b1") || this.e(s, len, "\u03b7\u03ba\u03b5"))) {
            len -= 3;
            rem = true;
        }
        if (rem && (this.c(EXC13, s, len) || this.e(s, len, "\u03c3\u03ba\u03c9\u03bb") || this.e(s, len, "\u03c3\u03ba\u03bf\u03c5\u03bb") || this.e(s, len, "\u03bd\u03b1\u03c1\u03b8") || this.e(s, len, "\u03c3\u03c6") || this.e(s, len, "\u03bf\u03b8") || this.e(s, len, "\u03c0\u03b9\u03b8"))) {
            len += 2;
        }
        return len;
    }

    private int rule14(char[] s, int l) {
        int len = l;
        boolean rem = false;
        if (len > 5 && this.e(s, len, "\u03bf\u03c5\u03c3\u03b5\u03c3")) {
            len -= 5;
            rem = true;
        } else if (len > 4 && (this.e(s, len, "\u03bf\u03c5\u03c3\u03b1") || this.e(s, len, "\u03bf\u03c5\u03c3\u03b5"))) {
            len -= 4;
            rem = true;
        }
        if (rem && (this.c(EXC14, s, len) || this.ev(s, len) || this.e(s, len, "\u03c0\u03bf\u03b4\u03b1\u03c1") || this.e(s, len, "\u03b2\u03bb\u03b5\u03c0") || this.e(s, len, "\u03c0\u03b1\u03bd\u03c4\u03b1\u03c7") || this.e(s, len, "\u03c6\u03c1\u03c5\u03b4") || this.e(s, len, "\u03bc\u03b1\u03bd\u03c4\u03b9\u03bb") || this.e(s, len, "\u03bc\u03b1\u03bb\u03bb") || this.e(s, len, "\u03ba\u03c5\u03bc\u03b1\u03c4") || this.e(s, len, "\u03bb\u03b1\u03c7") || this.e(s, len, "\u03bb\u03b7\u03b3") || this.e(s, len, "\u03c6\u03b1\u03b3") || this.e(s, len, "\u03bf\u03bc") || this.e(s, len, "\u03c0\u03c1\u03c9\u03c4"))) {
            len += 3;
        }
        return len;
    }

    private int rule15(char[] s, int l) {
        int len = l;
        boolean rem = false;
        if (len > 4 && this.e(s, len, "\u03b1\u03b3\u03b5\u03c3")) {
            len -= 4;
            rem = true;
        } else if (len > 3 && (this.e(s, len, "\u03b1\u03b3\u03b1") || this.e(s, len, "\u03b1\u03b3\u03b5"))) {
            len -= 3;
            rem = true;
        }
        if (rem) {
            boolean cond2;
            boolean cond1 = this.c(EXC15A, s, len) || this.e(s, len, "\u03bf\u03c6") || this.e(s, len, "\u03c0\u03b5\u03bb") || this.e(s, len, "\u03c7\u03bf\u03c1\u03c4") || this.e(s, len, "\u03bb\u03bb") || this.e(s, len, "\u03c3\u03c6") || this.e(s, len, "\u03c1\u03c0") || this.e(s, len, "\u03c6\u03c1") || this.e(s, len, "\u03c0\u03c1") || this.e(s, len, "\u03bb\u03bf\u03c7") || this.e(s, len, "\u03c3\u03bc\u03b7\u03bd");
            boolean bl = cond2 = this.c(EXC15B, s, len) || this.e(s, len, "\u03ba\u03bf\u03bb\u03bb");
            if (cond1 && !cond2) {
                len += 2;
            }
        }
        return len;
    }

    private int rule16(char[] s, int l) {
        int len = l;
        boolean rem = false;
        if (len > 4 && this.e(s, len, "\u03b7\u03c3\u03bf\u03c5")) {
            len -= 4;
            rem = true;
        } else if (len > 3 && (this.e(s, len, "\u03b7\u03c3\u03b5") || this.e(s, len, "\u03b7\u03c3\u03b1"))) {
            len -= 3;
            rem = true;
        }
        if (rem && this.c(EXC16, s, len)) {
            len += 2;
        }
        return len;
    }

    private int rule17(char[] s, int l) {
        int len = l;
        if (len > 4 && this.e(s, len, "\u03b7\u03c3\u03c4\u03b5") && this.c(EXC17, s, len -= 4)) {
            len += 3;
        }
        return len;
    }

    private int rule18(char[] s, int l) {
        boolean rem = false;
        int len = l;
        if (len > 6 && (this.e(s, len, "\u03b7\u03c3\u03bf\u03c5\u03bd\u03b5") || this.e(s, len, "\u03b7\u03b8\u03bf\u03c5\u03bd\u03b5"))) {
            len -= 6;
            rem = true;
        } else if (len > 4 && this.e(s, len, "\u03bf\u03c5\u03bd\u03b5")) {
            len -= 4;
            rem = true;
        }
        if (rem && this.c(EXC18, s, len)) {
            s[(len += 3) - 3] = 959;
            s[len - 2] = 965;
            s[len - 1] = 957;
        }
        return len;
    }

    private int rule19(char[] s, int l) {
        int len = l;
        boolean rem = false;
        if (len > 6 && (this.e(s, len, "\u03b7\u03c3\u03bf\u03c5\u03bc\u03b5") || this.e(s, len, "\u03b7\u03b8\u03bf\u03c5\u03bc\u03b5"))) {
            len -= 6;
            rem = true;
        } else if (len > 4 && this.e(s, len, "\u03bf\u03c5\u03bc\u03b5")) {
            len -= 4;
            rem = true;
        }
        if (rem && this.c(EXC19, s, len)) {
            s[(len += 3) - 3] = 959;
            s[len - 2] = 965;
            s[len - 1] = 956;
        }
        return len;
    }

    private int rule20(char[] s, int l) {
        int len = l;
        if (len > 5 && (this.e(s, len, "\u03bc\u03b1\u03c4\u03c9\u03bd") || this.e(s, len, "\u03bc\u03b1\u03c4\u03bf\u03c3"))) {
            len -= 3;
        } else if (len > 4 && this.e(s, len, "\u03bc\u03b1\u03c4\u03b1")) {
            len -= 2;
        }
        return len;
    }

    private int rule21(char[] s, int l) {
        if (l > 9 && this.e(s, l, "\u03b9\u03bf\u03bd\u03c4\u03bf\u03c5\u03c3\u03b1\u03bd")) {
            return l - 9;
        }
        if (l > 8 && (this.e(s, l, "\u03b9\u03bf\u03bc\u03b1\u03c3\u03c4\u03b1\u03bd") || this.e(s, l, "\u03b9\u03bf\u03c3\u03b1\u03c3\u03c4\u03b1\u03bd") || this.e(s, l, "\u03b9\u03bf\u03c5\u03bc\u03b1\u03c3\u03c4\u03b5") || this.e(s, l, "\u03bf\u03bd\u03c4\u03bf\u03c5\u03c3\u03b1\u03bd"))) {
            return l - 8;
        }
        if (l > 7 && (this.e(s, l, "\u03b9\u03b5\u03bc\u03b1\u03c3\u03c4\u03b5") || this.e(s, l, "\u03b9\u03b5\u03c3\u03b1\u03c3\u03c4\u03b5") || this.e(s, l, "\u03b9\u03bf\u03bc\u03bf\u03c5\u03bd\u03b1") || this.e(s, l, "\u03b9\u03bf\u03c3\u03b1\u03c3\u03c4\u03b5") || this.e(s, l, "\u03b9\u03bf\u03c3\u03bf\u03c5\u03bd\u03b1") || this.e(s, l, "\u03b9\u03bf\u03c5\u03bd\u03c4\u03b1\u03b9") || this.e(s, l, "\u03b9\u03bf\u03c5\u03bd\u03c4\u03b1\u03bd") || this.e(s, l, "\u03b7\u03b8\u03b7\u03ba\u03b1\u03c4\u03b5") || this.e(s, l, "\u03bf\u03bc\u03b1\u03c3\u03c4\u03b1\u03bd") || this.e(s, l, "\u03bf\u03c3\u03b1\u03c3\u03c4\u03b1\u03bd") || this.e(s, l, "\u03bf\u03c5\u03bc\u03b1\u03c3\u03c4\u03b5"))) {
            return l - 7;
        }
        if (l > 6 && (this.e(s, l, "\u03b9\u03bf\u03bc\u03bf\u03c5\u03bd") || this.e(s, l, "\u03b9\u03bf\u03bd\u03c4\u03b1\u03bd") || this.e(s, l, "\u03b9\u03bf\u03c3\u03bf\u03c5\u03bd") || this.e(s, l, "\u03b7\u03b8\u03b5\u03b9\u03c4\u03b5") || this.e(s, l, "\u03b7\u03b8\u03b7\u03ba\u03b1\u03bd") || this.e(s, l, "\u03bf\u03bc\u03bf\u03c5\u03bd\u03b1") || this.e(s, l, "\u03bf\u03c3\u03b1\u03c3\u03c4\u03b5") || this.e(s, l, "\u03bf\u03c3\u03bf\u03c5\u03bd\u03b1") || this.e(s, l, "\u03bf\u03c5\u03bd\u03c4\u03b1\u03b9") || this.e(s, l, "\u03bf\u03c5\u03bd\u03c4\u03b1\u03bd") || this.e(s, l, "\u03bf\u03c5\u03c3\u03b1\u03c4\u03b5"))) {
            return l - 6;
        }
        if (l > 5 && (this.e(s, l, "\u03b1\u03b3\u03b1\u03c4\u03b5") || this.e(s, l, "\u03b9\u03b5\u03bc\u03b1\u03b9") || this.e(s, l, "\u03b9\u03b5\u03c4\u03b1\u03b9") || this.e(s, l, "\u03b9\u03b5\u03c3\u03b1\u03b9") || this.e(s, l, "\u03b9\u03bf\u03c4\u03b1\u03bd") || this.e(s, l, "\u03b9\u03bf\u03c5\u03bc\u03b1") || this.e(s, l, "\u03b7\u03b8\u03b5\u03b9\u03c3") || this.e(s, l, "\u03b7\u03b8\u03bf\u03c5\u03bd") || this.e(s, l, "\u03b7\u03ba\u03b1\u03c4\u03b5") || this.e(s, l, "\u03b7\u03c3\u03b1\u03c4\u03b5") || this.e(s, l, "\u03b7\u03c3\u03bf\u03c5\u03bd") || this.e(s, l, "\u03bf\u03bc\u03bf\u03c5\u03bd") || this.e(s, l, "\u03bf\u03bd\u03c4\u03b1\u03b9") || this.e(s, l, "\u03bf\u03bd\u03c4\u03b1\u03bd") || this.e(s, l, "\u03bf\u03c3\u03bf\u03c5\u03bd") || this.e(s, l, "\u03bf\u03c5\u03bc\u03b1\u03b9") || this.e(s, l, "\u03bf\u03c5\u03c3\u03b1\u03bd"))) {
            return l - 5;
        }
        if (l > 4 && (this.e(s, l, "\u03b1\u03b3\u03b1\u03bd") || this.e(s, l, "\u03b1\u03bc\u03b1\u03b9") || this.e(s, l, "\u03b1\u03c3\u03b1\u03b9") || this.e(s, l, "\u03b1\u03c4\u03b1\u03b9") || this.e(s, l, "\u03b5\u03b9\u03c4\u03b5") || this.e(s, l, "\u03b5\u03c3\u03b1\u03b9") || this.e(s, l, "\u03b5\u03c4\u03b1\u03b9") || this.e(s, l, "\u03b7\u03b4\u03b5\u03c3") || this.e(s, l, "\u03b7\u03b4\u03c9\u03bd") || this.e(s, l, "\u03b7\u03b8\u03b5\u03b9") || this.e(s, l, "\u03b7\u03ba\u03b1\u03bd") || this.e(s, l, "\u03b7\u03c3\u03b1\u03bd") || this.e(s, l, "\u03b7\u03c3\u03b5\u03b9") || this.e(s, l, "\u03b7\u03c3\u03b5\u03c3") || this.e(s, l, "\u03bf\u03bc\u03b1\u03b9") || this.e(s, l, "\u03bf\u03c4\u03b1\u03bd"))) {
            return l - 4;
        }
        if (l > 3 && (this.e(s, l, "\u03b1\u03b5\u03b9") || this.e(s, l, "\u03b5\u03b9\u03c3") || this.e(s, l, "\u03b7\u03b8\u03c9") || this.e(s, l, "\u03b7\u03c3\u03c9") || this.e(s, l, "\u03bf\u03c5\u03bd") || this.e(s, l, "\u03bf\u03c5\u03c3"))) {
            return l - 3;
        }
        if (l > 2 && (this.e(s, l, "\u03b1\u03bd") || this.e(s, l, "\u03b1\u03c3") || this.e(s, l, "\u03b1\u03c9") || this.e(s, l, "\u03b5\u03b9") || this.e(s, l, "\u03b5\u03c3") || this.e(s, l, "\u03b7\u03c3") || this.e(s, l, "\u03bf\u03b9") || this.e(s, l, "\u03bf\u03c3") || this.e(s, l, "\u03bf\u03c5") || this.e(s, l, "\u03c5\u03c3") || this.e(s, l, "\u03c9\u03bd"))) {
            return l - 2;
        }
        if (l > 1 && this.ev(s, l)) {
            return l - 1;
        }
        return l;
    }

    private int rule22(char[] s, int l) {
        if (this.e(s, l, "\u03b5\u03c3\u03c4\u03b5\u03c1") || this.e(s, l, "\u03b5\u03c3\u03c4\u03b1\u03c4")) {
            return l - 5;
        }
        if (this.e(s, l, "\u03bf\u03c4\u03b5\u03c1") || this.e(s, l, "\u03bf\u03c4\u03b1\u03c4") || this.e(s, l, "\u03c5\u03c4\u03b5\u03c1") || this.e(s, l, "\u03c5\u03c4\u03b1\u03c4") || this.e(s, l, "\u03c9\u03c4\u03b5\u03c1") || this.e(s, l, "\u03c9\u03c4\u03b1\u03c4")) {
            return l - 4;
        }
        return l;
    }

    private boolean e(char[] s, int l, String suf) {
        int sl = suf.length();
        if (sl > l) {
            return false;
        }
        for (int i = sl - 1; i >= 0; --i) {
            if (s[l - (sl - i)] == suf.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private boolean ev(char[] s, int l) {
        if (l == 0) {
            return false;
        }
        switch (s[l - 1]) {
            case '\u03b1': 
            case '\u03b5': 
            case '\u03b7': 
            case '\u03b9': 
            case '\u03bf': 
            case '\u03c5': 
            case '\u03c9': {
                return true;
            }
        }
        return false;
    }

    private boolean ey(char[] s, int l) {
        if (l == 0) {
            return false;
        }
        switch (s[l - 1]) {
            case '\u03b1': 
            case '\u03b5': 
            case '\u03b7': 
            case '\u03b9': 
            case '\u03bf': 
            case '\u03c9': {
                return true;
            }
        }
        return false;
    }

    private boolean c(String[] strings, char[] s, int l) {
        for (String e : strings) {
            int el = e.length();
            if (l != el) continue;
            int i = -1;
            while (++i < l && e.charAt(i) == s[i]) {
            }
            if (i != l) continue;
            return true;
        }
        return false;
    }
}

