/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.data.CopyRunner;
import nl.mpi.arbil.data.DataNodeLoader;
import nl.mpi.arbil.data.importexport.ShibbolethNegotiator;
import nl.mpi.arbil.ui.AbstractArbilTableModel;
import nl.mpi.arbil.ui.ImportExportUI;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.DownloadAbortFlag;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.arbil.util.TreeHelper;
import nl.mpi.arbil.util.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportExportDialog
implements ImportExportUI {
    private static final String progressFoundLabelText = "Total Metadata Files Found: ";
    private static final String progressProcessedLabelText = "Total Metadata Files Processed: ";
    private static final String progressAlreadyInCacheLabelText = "Metadata Files already in Local Corpus: ";
    private static final String progressFailedLabelText = "Metadata File Copy Errors: ";
    private static final String progressXmlErrorsLabelText = "Metadata File Validation Errors: ";
    private static final String resourceCopyErrorsLabelText = "Resource File Copy Errors: ";
    private final JDialog importExportDialog;
    private final JPanel importExportPanel;
    private JPanel inputNodePanel;
    private JPanel outputNodePanel;
    private JCheckBox copyFilesExportCheckBox;
    private JCheckBox copyFilesImportCheckBox;
    private JCheckBox renameFileToNodeName;
    private JCheckBox renameFileToLamusFriendlyName;
    private JButton showMoreButton;
    private JButton showDetailsButton;
    private JCheckBox shibbolethCheckBox;
    private JPanel shibbolethPanel;
    private JLabel resourceProgressLabel;
    private JProgressBar progressBar;
    private JLabel diskSpaceLabel;
    private JPanel moreOptionsPanel;
    private JPanel detailsPanel;
    private JPanel detailsBottomPanel;
    private JLabel progressFoundLabel;
    private JLabel progressProcessedLabel;
    private JLabel progressAlreadyInCacheLabel;
    private JLabel progressFailedLabel;
    private JLabel progressXmlErrorsLabel;
    private JLabel resourceCopyErrorsLabel;
    private JButton showInTableButton;
    private JButton closeButton;
    private JButton stopButton;
    private JButton startButton;
    private JTabbedPane detailsTabPane;
    private JTextArea taskOutput;
    private JTextArea xmlOutput;
    private JTextArea resourceCopyOutput;
    private boolean stopCopy = false;
    private Vector<ArbilDataNode> selectedNodes;
    private ArbilDataNode destinationNode = null;
    private File exportDestinationDirectory = null;
    private DownloadAbortFlag downloadAbortFlag = new DownloadAbortFlag();
    private ShibbolethNegotiator shibbolethNegotiator = null;
    private Vector<URI> validationErrors = new Vector();
    private Vector<URI> metaDataCopyErrors = new Vector();
    private Vector<URI> fileCopyErrors = new Vector();
    private boolean showingMoreOptions = false;
    private boolean showingDetails = false;
    private static TreeHelper treeHelper;
    private static DataNodeLoader dataNodeLoader;
    private static SessionStorage sessionStorage;
    private static WindowManager windowManager;
    private static MessageDialogHandler dialogHandler;
    private MessageDialogHandler.DialogBoxResult rememberedOverwriteFileResult;

    public static void setTreeHelper(TreeHelper treeHelperInstance) {
        treeHelper = treeHelperInstance;
    }

    public static void setDataNodeLoader(DataNodeLoader dataNodeLoaderInstance) {
        dataNodeLoader = dataNodeLoaderInstance;
    }

    public static void setSessionStorage(SessionStorage sessionStorageInstance) {
        sessionStorage = sessionStorageInstance;
    }

    public static void setWindowManager(WindowManager windowManagerInstance) {
        windowManager = windowManagerInstance;
    }

    public static void setMessageDialogHandler(MessageDialogHandler dialogHandlerInstance) {
        dialogHandler = dialogHandlerInstance;
    }

    public ImportExportDialog(Component targetComponent) throws Exception {
        dialogHandler.offerUserToSaveChanges();
        this.importExportPanel = new JPanel();
        this.importExportPanel.setLayout(new BorderLayout());
        this.importExportPanel.add((Component)this.createInOutNodePanel(), "North");
        JPanel optionsPanel = new JPanel(new BorderLayout());
        optionsPanel.add((Component)this.createOptionsPanel(), "Center");
        optionsPanel.add((Component)this.createMoreOptionsPanel(), "South");
        this.importExportPanel.add((Component)optionsPanel, "Center");
        JPanel dialogBottomPanel = new JPanel(new BorderLayout());
        dialogBottomPanel.add((Component)this.createStartStopButtonsPanel(), "West");
        dialogBottomPanel.add((Component)this.createDetailsPanel(), "South");
        this.importExportPanel.add((Component)dialogBottomPanel, "South");
        this.importExportDialog = new JDialog(JOptionPane.getFrameForComponent(windowManager.getMainFrame()), true);
        this.importExportDialog.setDefaultCloseOperation(2);
        this.importExportDialog.addWindowStateListener(new WindowAdapter(){

            public void windowStateChanged(WindowEvent e) {
                if ((e.getNewState() & 6) == 6) {
                    ImportExportDialog.this.updateDialog(true, true);
                } else {
                    ImportExportDialog.this.importExportDialog.pack();
                }
            }
        });
        this.importExportDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ImportExportDialog.this.setStopCopy(true);
                ((ImportExportDialog)ImportExportDialog.this).downloadAbortFlag.abortDownload = true;
            }
        });
        this.importExportDialog.getContentPane().setLayout(new BorderLayout());
        this.importExportDialog.add((Component)this.importExportPanel, "Center");
        this.importExportDialog.setLocationRelativeTo(targetComponent);
        this.importExportDialog.setResizable(false);
        this.updateDialog(this.showingMoreOptions, this.showingDetails);
        JPanel closeButtonPanel = new JPanel(new FlowLayout(4));
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImportExportDialog.this.importExportDialog.dispose();
            }
        });
        closeButtonPanel.add(this.closeButton);
        closeButtonPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY));
        this.importExportDialog.add((Component)closeButtonPanel, "South");
        this.importExportDialog.pack();
    }

    private JPanel createOptionsPanel() {
        this.copyFilesExportCheckBox = new JCheckBox("Export Resource Files (if available)", false);
        this.copyFilesImportCheckBox = new JCheckBox("Import Resource Files (if available)", false);
        this.copyFilesImportCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImportExportDialog.this.shibbolethCheckBox.setVisible(ImportExportDialog.this.copyFilesImportCheckBox.isSelected());
                ImportExportDialog.this.shibbolethPanel.setVisible(ImportExportDialog.this.copyFilesImportCheckBox.isSelected());
                ImportExportDialog.this.importExportDialog.pack();
            }
        });
        JPanel optionsPanel = new JPanel();
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 3));
        this.copyFilesExportCheckBox.setAlignmentX(0.0f);
        optionsPanel.add(this.copyFilesExportCheckBox);
        optionsPanel.add(this.copyFilesImportCheckBox);
        optionsPanel.setAlignmentX(0.0f);
        return optionsPanel;
    }

    private JPanel createMoreOptionsPanel() {
        this.moreOptionsPanel = new JPanel();
        JPanel moreOptionsButtonPanel = new JPanel(new BorderLayout());
        this.showMoreButton = new JButton("");
        this.showMoreButton.setToolTipText("Show/hide additional options");
        this.showMoreButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    ImportExportDialog.this.updateDialog(!ImportExportDialog.this.showingMoreOptions, ImportExportDialog.this.showingDetails);
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        moreOptionsButtonPanel.add((Component)this.showMoreButton, "West");
        this.moreOptionsPanel.setLayout(new BorderLayout());
        this.shibbolethCheckBox.setEnabled(false);
        this.shibbolethPanel = new JPanel();
        this.shibbolethCheckBox.setVisible(false);
        this.shibbolethPanel.setVisible(false);
        this.shibbolethCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ImportExportDialog.this.shibbolethCheckBox.isSelected()) {
                    if (ImportExportDialog.this.getShibbolethNegotiator() == null) {
                        ImportExportDialog.this.shibbolethNegotiator = new ShibbolethNegotiator();
                    }
                    ImportExportDialog.this.shibbolethPanel.add(ImportExportDialog.this.getShibbolethNegotiator().getControlls());
                } else {
                    ImportExportDialog.this.shibbolethPanel.removeAll();
                    ImportExportDialog.this.shibbolethNegotiator = null;
                }
                ImportExportDialog.this.importExportDialog.pack();
            }
        });
        JPanel moreOptionsTopPanel = new JPanel();
        moreOptionsTopPanel.setLayout(new BoxLayout(moreOptionsTopPanel, 3));
        JPanel moreOptionsTopCheckBoxPanel = new JPanel();
        moreOptionsTopCheckBoxPanel.setLayout(new BoxLayout(moreOptionsTopCheckBoxPanel, 3));
        moreOptionsTopCheckBoxPanel.add(this.renameFileToNodeName);
        moreOptionsTopCheckBoxPanel.add(this.renameFileToLamusFriendlyName);
        moreOptionsTopCheckBoxPanel.add(this.shibbolethCheckBox);
        JPanel paddingPanel = new JPanel();
        paddingPanel.setLayout(new BoxLayout(paddingPanel, 2));
        JPanel leftPadding = new JPanel();
        leftPadding.setMaximumSize(new Dimension(500, 100));
        paddingPanel.add(leftPadding);
        paddingPanel.add(moreOptionsTopCheckBoxPanel);
        paddingPanel.add(new JPanel());
        moreOptionsTopPanel.add(paddingPanel);
        moreOptionsTopPanel.add(this.shibbolethPanel);
        this.moreOptionsPanel.add((Component)moreOptionsTopPanel, "North");
        JPanel moreOptionsContainerPanel = new JPanel();
        moreOptionsContainerPanel.setLayout(new BoxLayout(moreOptionsContainerPanel, 3));
        moreOptionsButtonPanel.setAlignmentX(0.0f);
        moreOptionsContainerPanel.add(moreOptionsButtonPanel);
        this.moreOptionsPanel.setAlignmentX(0.0f);
        moreOptionsContainerPanel.add(this.moreOptionsPanel);
        moreOptionsContainerPanel.setAlignmentX(0.0f);
        return moreOptionsContainerPanel;
    }

    private JPanel createDetailsPanel() {
        this.detailsPanel = new JPanel();
        this.detailsPanel.setLayout(new BorderLayout());
        this.detailsTabPane = new JTabbedPane();
        this.taskOutput = new JTextArea(5, 20);
        this.taskOutput.setMargin(new Insets(5, 5, 5, 5));
        this.taskOutput.setEditable(false);
        this.taskOutput.append("The details of the import / export process will be displayed here.\n");
        this.detailsTabPane.add("Process Details", new JScrollPane(this.taskOutput));
        this.xmlOutput = new JTextArea(5, 20);
        this.xmlOutput.setMargin(new Insets(5, 5, 5, 5));
        this.xmlOutput.setEditable(false);
        this.xmlOutput.append("When the metadata files are imported or exported they will be validated (for XML schema conformance) and any errors will be reported here.\n");
        this.detailsTabPane.add("Validation Errors", new JScrollPane(this.xmlOutput));
        this.resourceCopyOutput = new JTextArea(5, 20);
        this.resourceCopyOutput.setMargin(new Insets(5, 5, 5, 5));
        this.resourceCopyOutput.setEditable(false);
        this.resourceCopyOutput.append("If copying of resource files is selected, any file copy errors will be reported here.\n");
        this.detailsTabPane.add("Resource Copy Errors", new JScrollPane(this.resourceCopyOutput));
        this.detailsPanel.add((Component)this.detailsTabPane, "Center");
        this.detailsBottomPanel = new JPanel();
        this.detailsBottomPanel.setLayout(new BoxLayout(this.detailsBottomPanel, 3));
        this.progressFoundLabel = new JLabel(progressFoundLabelText);
        this.progressProcessedLabel = new JLabel(progressProcessedLabelText);
        this.progressAlreadyInCacheLabel = new JLabel(progressAlreadyInCacheLabelText);
        this.progressFailedLabel = new JLabel(progressFailedLabelText);
        this.progressXmlErrorsLabel = new JLabel(progressXmlErrorsLabelText);
        this.resourceCopyErrorsLabel = new JLabel(resourceCopyErrorsLabelText);
        this.showInTableButton = new JButton("Show errors in table");
        this.showInTableButton.setEnabled(false);
        this.showInTableButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    if (ImportExportDialog.this.metaDataCopyErrors.size() > 0) {
                        windowManager.openFloatingTableOnce(ImportExportDialog.this.metaDataCopyErrors.toArray(new URI[0]), ImportExportDialog.progressFailedLabelText);
                    }
                    if (ImportExportDialog.this.validationErrors.size() > 0) {
                        windowManager.openAllChildNodesInFloatingTableOnce(ImportExportDialog.this.validationErrors.toArray(new URI[0]), ImportExportDialog.progressXmlErrorsLabelText);
                    }
                    if (ImportExportDialog.this.fileCopyErrors.size() > 0) {
                        AbstractArbilTableModel resourceFileErrorsTable = windowManager.openFloatingTableOnceGetModel(ImportExportDialog.this.fileCopyErrors.toArray(new URI[0]), ImportExportDialog.resourceCopyErrorsLabelText);
                        resourceFileErrorsTable.addChildTypeToDisplay("MediaFiles");
                        resourceFileErrorsTable.addChildTypeToDisplay("WrittenResources");
                    }
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.diskSpaceLabel = new JLabel("Total Disk Free: ");
        this.progressAlreadyInCacheLabel.setForeground(Color.darkGray);
        this.progressFailedLabel.setForeground(Color.red);
        this.progressXmlErrorsLabel.setForeground(Color.red);
        this.resourceCopyErrorsLabel.setForeground(Color.red);
        this.detailsBottomPanel.add(this.progressFoundLabel);
        this.detailsBottomPanel.add(this.progressProcessedLabel);
        this.detailsBottomPanel.add(this.progressAlreadyInCacheLabel);
        this.detailsBottomPanel.add(this.progressFailedLabel);
        this.detailsBottomPanel.add(this.progressXmlErrorsLabel);
        this.detailsBottomPanel.add(this.resourceCopyErrorsLabel);
        this.detailsBottomPanel.add(this.showInTableButton);
        this.detailsBottomPanel.add(this.diskSpaceLabel);
        this.resourceProgressLabel = new JLabel(" ");
        this.detailsBottomPanel.add(this.resourceProgressLabel);
        this.detailsPanel.add((Component)this.detailsBottomPanel, "South");
        JPanel paddingPanel = new JPanel();
        paddingPanel.setLayout(new BoxLayout(paddingPanel, 2));
        JPanel leftPadding = new JPanel();
        leftPadding.setMaximumSize(new Dimension(500, 100));
        paddingPanel.add(leftPadding);
        paddingPanel.add(this.detailsPanel);
        paddingPanel.add(new JPanel());
        paddingPanel.setMinimumSize(new Dimension(800, 200));
        return paddingPanel;
    }

    private JPanel createInOutNodePanel() {
        JPanel inOutNodePanel = new JPanel();
        inOutNodePanel.setLayout(new BoxLayout(inOutNodePanel, 3));
        JPanel inputNodeLabelPanel = new JPanel();
        inputNodeLabelPanel.setLayout(new BorderLayout());
        this.inputNodePanel = new JPanel();
        this.inputNodePanel.setLayout(new GridLayout());
        inputNodeLabelPanel.add((Component)new JLabel("From: "), "Before");
        inputNodeLabelPanel.add((Component)this.inputNodePanel, "Center");
        inputNodeLabelPanel.setAlignmentX(0.0f);
        inOutNodePanel.add(inputNodeLabelPanel);
        JPanel outputNodeLabelPanel = new JPanel();
        outputNodeLabelPanel.setLayout(new BorderLayout());
        this.outputNodePanel = new JPanel();
        this.outputNodePanel.setLayout(new GridLayout());
        outputNodeLabelPanel.add((Component)new JLabel("To: "), "Before");
        outputNodeLabelPanel.add((Component)this.outputNodePanel, "Center");
        outputNodeLabelPanel.setAlignmentX(0.0f);
        inOutNodePanel.add(outputNodeLabelPanel);
        this.renameFileToNodeName = new JCheckBox("Rename Metadata Files (to match local corpus tree names)", true);
        this.renameFileToLamusFriendlyName = new JCheckBox("Limit Characters in File Names (LAMUS friendly format)", true);
        this.shibbolethCheckBox = new JCheckBox("Shibboleth authentication via the SURFnet method", false);
        inOutNodePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 0));
        return inOutNodePanel;
    }

    private JPanel createStartStopButtonsPanel() {
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        this.stopButton = new JButton("Stop");
        this.startButton = new JButton("Start");
        this.stopButton.setEnabled(false);
        buttonsPanel.add(this.stopButton);
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.progressBar.setString("");
        buttonsPanel.add(this.progressBar);
        buttonsPanel.add(this.startButton);
        this.startButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    ImportExportDialog.this.performCopy();
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    ImportExportDialog.this.setStopCopy(true);
                    ((ImportExportDialog)ImportExportDialog.this).downloadAbortFlag.abortDownload = true;
                    ImportExportDialog.this.stopButton.setEnabled(false);
                    ImportExportDialog.this.startButton.setEnabled(false);
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.showDetailsButton = new JButton("");
        buttonsPanel.add(this.showDetailsButton);
        this.showDetailsButton.setToolTipText("Show/hide detailed information");
        this.showDetailsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    ImportExportDialog.this.updateDialog(ImportExportDialog.this.showingMoreOptions, !ImportExportDialog.this.showingDetails);
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        buttonsPanel.setAlignmentX(0.0f);
        return buttonsPanel;
    }

    private void setNodesPanel(ArbilDataNode selectedNode, JPanel nodePanel) {
        JLabel currentLabel = new JLabel(selectedNode.toString(), selectedNode.getIcon(), 0);
        nodePanel.add(currentLabel);
    }

    private void setNodesPanel(Vector<ArbilDataNode> selectedNodes, JPanel nodePanel) {
        for (ArbilDataNode currentNode : selectedNodes) {
            JLabel currentLabel = new JLabel(currentNode.toString(), currentNode.getIcon(), 0);
            nodePanel.add(currentLabel);
        }
    }

    private void setLocalCacheToNodesPanel(JPanel nodePanel) {
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)treeHelper.getLocalCorpusTreeModel().getRoot();
        ArbilNode rootArbilNode = (ArbilNode)((Object)rootNode.getUserObject());
        JLabel currentLabel = new JLabel(((Object)((Object)rootArbilNode)).toString(), rootArbilNode.getIcon(), 0);
        nodePanel.add(currentLabel);
    }

    private void setLocalFileToNodesPanel(JPanel nodePanel, File destinationDirectory) {
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)treeHelper.getLocalDirectoryTreeModel().getRoot();
        ArbilNode rootArbilNode = (ArbilNode)((Object)rootNode.getUserObject());
        JLabel currentLabel = new JLabel(destinationDirectory.getPath(), rootArbilNode.getIcon(), 0);
        nodePanel.add(currentLabel);
    }

    public void importArbilBranch() {
        File[] selectedFiles = dialogHandler.showMetadataFileSelectBox("Import", true);
        if (selectedFiles != null) {
            Vector<ArbilDataNode> importNodeVector = new Vector<ArbilDataNode>();
            for (File currentFile : selectedFiles) {
                ArbilDataNode nodeToImport = dataNodeLoader.getArbilDataNode(null, currentFile.toURI());
                importNodeVector.add(nodeToImport);
            }
            this.copyToCache(importNodeVector);
        }
    }

    public void selectExportDirectoryAndExport(ArbilDataNode[] localCorpusSelectedNodes) {
        this.importExportDialog.setTitle("Export Branch");
        File destinationDirectory = dialogHandler.showEmptyExportDirectoryDialogue(this.importExportDialog.getTitle());
        if (destinationDirectory != null) {
            this.exportFromCache(new Vector<ArbilDataNode>(Arrays.asList(localCorpusSelectedNodes)), destinationDirectory);
        }
    }

    private void exportFromCache(Vector localSelectedNodes, File destinationDirectory) {
        this.selectedNodes = localSelectedNodes;
        if (!this.selectedNodesContainDataNode()) {
            dialogHandler.addMessageDialogToQueue("No relevant nodes are selected", this.importExportDialog.getTitle());
            return;
        }
        this.setNodesPanel(this.selectedNodes, this.inputNodePanel);
        this.setLocalFileToNodesPanel(this.outputNodePanel, destinationDirectory);
        this.exportDestinationDirectory = destinationDirectory;
        this.updateDialog(this.showingMoreOptions, this.showingDetails);
        this.importExportDialog.setVisible(true);
    }

    public void copyToCache(ArbilDataNode[] localSelectedNodes) {
        this.copyToCache(new Vector<ArbilDataNode>(Arrays.asList(localSelectedNodes)));
    }

    public void setDestinationNode(ArbilDataNode localDestinationNode) {
        this.destinationNode = localDestinationNode;
        this.setNodesPanel(this.destinationNode, this.outputNodePanel);
    }

    public void copyToCache(Vector localSelectedNodes) {
        this.selectedNodes = localSelectedNodes;
        this.importExportDialog.setTitle("Import Branch");
        if (!this.selectedNodesContainDataNode()) {
            dialogHandler.addMessageDialogToQueue("No relevant nodes are selected", this.importExportDialog.getTitle());
            return;
        }
        this.setNodesPanel(this.selectedNodes, this.inputNodePanel);
        if (this.destinationNode == null) {
            this.setLocalCacheToNodesPanel(this.outputNodePanel);
        }
        this.importExportDialog.setVisible(true);
    }

    private boolean selectedNodesContainDataNode() {
        for (ArbilDataNode currentNode : this.selectedNodes) {
            if (!(currentNode instanceof ArbilDataNode)) continue;
            return true;
        }
        return false;
    }

    private synchronized void updateDialog(boolean optionsFlag, boolean detailsFlag) {
        this.copyFilesImportCheckBox.setVisible(this.exportDestinationDirectory == null);
        this.copyFilesExportCheckBox.setVisible(this.exportDestinationDirectory != null);
        this.moreOptionsPanel.setVisible(this.exportDestinationDirectory != null);
        this.showMoreButton.setVisible(this.exportDestinationDirectory != null);
        if (!optionsFlag || !detailsFlag || this.showingMoreOptions != optionsFlag || this.showingDetails != detailsFlag) {
            this.detailsTabPane.setVisible(detailsFlag);
            this.detailsBottomPanel.setVisible(detailsFlag);
            this.renameFileToNodeName.setVisible(optionsFlag && this.exportDestinationDirectory != null);
            this.renameFileToLamusFriendlyName.setVisible(optionsFlag && this.exportDestinationDirectory != null);
            this.shibbolethCheckBox.setVisible(optionsFlag && this.copyFilesImportCheckBox.isSelected());
            this.shibbolethPanel.setVisible(optionsFlag && this.copyFilesImportCheckBox.isSelected());
            if (detailsFlag) {
                this.importExportDialog.setMinimumSize(new Dimension(500, 500));
            } else {
                this.importExportDialog.setMinimumSize(null);
            }
            this.showMoreButton.setText(optionsFlag ? "< < Fewer options" : "More options> >");
            this.showDetailsButton.setText(detailsFlag ? "< < Hide details" : "Details > >");
            this.showingMoreOptions = optionsFlag;
            this.showingDetails = detailsFlag;
            this.importExportDialog.pack();
        }
    }

    private void performCopy() {
        this.setUItoRunningState();
        CopyRunner copyRunner = new CopyRunner(this, sessionStorage, dataNodeLoader, treeHelper);
        new Thread((Runnable)copyRunner, "performCopy").start();
    }

    @Override
    public void appendToTaskOutput(final String lineOfText) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ImportExportDialog.this.taskOutput.append(lineOfText + "\n");
                ImportExportDialog.this.taskOutput.setCaretPosition(ImportExportDialog.this.taskOutput.getText().length());
            }
        });
    }

    private void setUItoRunningState() {
        this.stopButton.setEnabled(true);
        this.startButton.setEnabled(false);
        this.closeButton.setEnabled(false);
        this.showMoreButton.setEnabled(false);
        this.showInTableButton.setEnabled(false);
        this.copyFilesExportCheckBox.setEnabled(false);
        this.copyFilesImportCheckBox.setEnabled(false);
        this.taskOutput.setCursor(Cursor.getPredefinedCursor(3));
        this.importExportDialog.setCursor(Cursor.getPredefinedCursor(3));
        this.rememberedOverwriteFileResult = null;
    }

    public void setUItoStoppedState() {
        Toolkit.getDefaultToolkit().beep();
        this.taskOutput.setCursor(null);
        this.importExportDialog.setCursor(null);
        this.progressBar.setIndeterminate(false);
        this.resourceProgressLabel.setText(" ");
        this.stopButton.setEnabled(false);
        this.startButton.setEnabled(this.selectedNodes.size() > 0);
        this.closeButton.setEnabled(true);
        this.showMoreButton.setEnabled(true);
        this.showInTableButton.setEnabled(this.validationErrors.size() > 0 || this.metaDataCopyErrors.size() > 0 || this.fileCopyErrors.size() > 0);
        this.copyFilesExportCheckBox.setEnabled(true);
        this.copyFilesImportCheckBox.setEnabled(true);
        this.stopCopy = false;
        this.downloadAbortFlag.abortDownload = false;
    }

    public void waitTillVisible() {
        while (!this.importExportDialog.isVisible()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ignore) {
                BugCatcherManager.getBugCatcher().logError(ignore);
            }
        }
    }

    @Override
    public boolean isCopyFilesOnImport() {
        return this.copyFilesImportCheckBox.isSelected();
    }

    @Override
    public boolean isCopyFilesOnExport() {
        return this.copyFilesExportCheckBox.isSelected();
    }

    @Override
    public boolean isRenameFileToNodeName() {
        return this.renameFileToNodeName.isSelected();
    }

    @Override
    public boolean isRenameFileToLamusFriendlyName() {
        return this.renameFileToLamusFriendlyName.isSelected();
    }

    @Override
    public void appendToResourceCopyOutput(final String text) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ImportExportDialog.this.resourceCopyOutput.append(text);
                ImportExportDialog.this.resourceCopyOutput.setCaretPosition(ImportExportDialog.this.resourceCopyOutput.getText().length() - 1);
            }
        });
    }

    @Override
    public void appendToXmlOutput(final String text) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ImportExportDialog.this.xmlOutput.append(text);
                ImportExportDialog.this.xmlOutput.setCaretPosition(ImportExportDialog.this.xmlOutput.getText().length() - 1);
            }
        });
    }

    @Override
    public void addToValidationErrors(URI uri) {
        this.validationErrors.add(uri);
    }

    @Override
    public void addToMetadataCopyErrors(URI uri) {
        this.metaDataCopyErrors.add(uri);
    }

    @Override
    public void addToFileCopyErrors(URI uri) {
        this.fileCopyErrors.add(uri);
    }

    @Override
    public void setDiskspaceState(String text) {
        this.diskSpaceLabel.setText(text);
    }

    @Override
    public File getExportDestinationDirectory() {
        return this.exportDestinationDirectory;
    }

    @Override
    public DownloadAbortFlag getDownloadAbortFlag() {
        return this.downloadAbortFlag;
    }

    @Override
    public ShibbolethNegotiator getShibbolethNegotiator() {
        return this.shibbolethNegotiator;
    }

    @Override
    public Iterator<ArbilDataNode> getSelectedNodesIterator() {
        return this.selectedNodes.iterator();
    }

    @Override
    public void removeNodeSelection() {
        this.selectedNodes.removeAllElements();
    }

    @Override
    public synchronized boolean isStopCopy() {
        return this.stopCopy;
    }

    @Override
    public synchronized void setStopCopy(boolean stopCopy) {
        this.stopCopy = stopCopy;
    }

    @Override
    public ArbilDataNode getDestinationNode() {
        return this.destinationNode;
    }

    @Override
    public void setProgressIndeterminate(final boolean indeterminate) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ImportExportDialog.this.progressBar.setIndeterminate(indeterminate);
            }
        });
    }

    @Override
    public void setProgressText(final String text) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ImportExportDialog.this.resourceProgressLabel.setText(text);
            }
        });
    }

    @Override
    public boolean askContinue(String message) {
        return 0 == dialogHandler.showDialogBox(message, this.importExportDialog.getTitle(), 0, -1);
    }

    @Override
    public void onCopyStart() {
        this.waitTillVisible();
    }

    @Override
    public void onCopyEnd(final String finalMessage) throws HeadlessException {
        System.out.println("finalMessageString: " + finalMessage);
        final Object[] options = new Object[]{"Close", "Details"};
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ImportExportDialog.this.setUItoStoppedState();
                int detailsOption = JOptionPane.showOptionDialog(windowManager.getMainFrame(), finalMessage, ImportExportDialog.this.importExportDialog.getTitle(), 0, -1, null, options, options[0]);
                if (detailsOption == 0) {
                    ImportExportDialog.this.importExportDialog.dispose();
                } else if (!ImportExportDialog.this.showingDetails) {
                    ImportExportDialog.this.updateDialog(ImportExportDialog.this.showingMoreOptions, true);
                    ImportExportDialog.this.importExportDialog.pack();
                }
                if (ImportExportDialog.this.getExportDestinationDirectory() != null) {
                    windowManager.openFileInExternalApplication(ImportExportDialog.this.getExportDestinationDirectory().toURI());
                }
            }
        });
    }

    @Override
    public void updateStatus(final int getCount, final int totalLoaded, final int totalExisting, final int totalErrors, final int xsdErrors, final int resourceCopyErrors) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ImportExportDialog.this.progressFoundLabel.setText(ImportExportDialog.progressFoundLabelText + (getCount + totalLoaded));
                ImportExportDialog.this.progressProcessedLabel.setText(ImportExportDialog.progressProcessedLabelText + totalLoaded);
                ImportExportDialog.this.progressAlreadyInCacheLabel.setText(ImportExportDialog.progressAlreadyInCacheLabelText + totalExisting);
                ImportExportDialog.this.progressFailedLabel.setText(ImportExportDialog.progressFailedLabelText + totalErrors);
                ImportExportDialog.this.progressXmlErrorsLabel.setText(ImportExportDialog.progressXmlErrorsLabelText + xsdErrors);
                ImportExportDialog.this.resourceCopyErrorsLabel.setText(ImportExportDialog.resourceCopyErrorsLabelText + resourceCopyErrors);
                ImportExportDialog.this.progressBar.setString(totalLoaded + "/" + (getCount + totalLoaded) + " (" + (totalErrors + xsdErrors + resourceCopyErrors) + " errors)");
            }
        });
    }

    @Override
    public boolean askOverwrite(CopyRunner.RetrievableFile currentRetrievableFile) {
        if (this.rememberedOverwriteFileResult == null || !this.rememberedOverwriteFileResult.isRememberChoice()) {
            String message = String.format("The following file already exist in the target location:\n\n%s\n\n Overwrite?", currentRetrievableFile.getSourceURI());
            this.rememberedOverwriteFileResult = dialogHandler.showDialogBoxRememberChoice(message, "Overwrite file?", 1, 3);
        }
        if (2 == this.rememberedOverwriteFileResult.getResult()) {
            this.setStopCopy(true);
            return false;
        }
        return 0 == this.rememberedOverwriteFileResult.getResult();
    }

    @Override
    public boolean askCreateNewExportDir(File destinationFile) {
        Object[] dialogOptions = new Object[]{"Replace", "New location", "Cancel"};
        boolean newLocationOption = true;
        int cancelOption = 2;
        String message = String.format("Export location %s already exists! Do you want to replace or create a new location?\n\nChoosing 'Replace' will NOT remove any existing files or directories but may overwrite or some.\nYou will be able to decide for individual existing files whether to overwrite or not.\n\nIf you choose 'New location', a unique new file name will be created on basis of the original file\nname and files that are already present.", destinationFile.getName());
        int result = dialogHandler.showDialogBox(message, "Replace existing location?", 1, 2, dialogOptions, "New location");
        if (result == 2) {
            this.setStopCopy(true);
            return false;
        }
        return result == 1;
    }
}

