/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.gedcomimport;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.kinnate.gedcomimport.EntityImporter;
import nl.mpi.kinnate.gedcomimport.GedcomLineStructure;
import nl.mpi.kinnate.gedcomimport.GenericImporter;
import nl.mpi.kinnate.gedcomimport.ImportException;
import nl.mpi.kinnate.gedcomimport.ImportLineStructure;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kindata.EntityDate;
import nl.mpi.kinnate.kindata.EntityDateException;
import nl.mpi.kinnate.kindocument.EntityDocument;
import nl.mpi.kinnate.kindocument.ImportTranslator;
import nl.mpi.kinnate.ui.entityprofiles.ProfileRecord;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GedcomImporter
extends EntityImporter
implements GenericImporter {
    public GedcomImporter(JProgressBar progressBarLocal, JTextArea importTextAreaLocal, boolean overwriteExistingLocal, SessionStorage sessionStorage) {
        super(progressBarLocal, importTextAreaLocal, overwriteExistingLocal, sessionStorage);
    }

    @Override
    public boolean canImport(String inputFileString) {
        return inputFileString.toLowerCase().endsWith(".ged") || inputFileString.toLowerCase().endsWith(".gedcom");
    }

    protected ImportTranslator getImportTranslator() {
        ImportTranslator importTranslator = new ImportTranslator(true);
        importTranslator.addTranslationEntry("SEX", "F", "Gender", "Female");
        importTranslator.addTranslationEntry("SEX", "M", "Gender", "Male");
        importTranslator.addTranslationEntry("NAME", null, "Name", null);
        importTranslator.addTranslationEntry("chro", null, "Chromosome", null);
        return importTranslator;
    }

    protected ImportLineStructure getImportLineStructure(String lineString, ArrayList<String> gedcomLevelStrings) throws ImportException {
        return new GedcomLineStructure(lineString, gedcomLevelStrings);
    }

    @Override
    public UniqueIdentifier[] importFile(InputStreamReader inputStreamReader, String profileId) throws IOException, ImportException {
        String strLine;
        HashSet<UniqueIdentifier> createdNodes = new HashSet<UniqueIdentifier>();
        HashMap socialGroupRoleMap = new HashMap();
        ArrayList<FamGroupElement> famGroupList = new ArrayList<FamGroupElement>();
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        ImportTranslator importTranslator = this.getImportTranslator();
        ArrayList<String> gedcomLevelStrings = new ArrayList<String>();
        ArrayList<EntityDocument> documentsToDeleteIfNoFieldsAdded = new ArrayList<EntityDocument>();
        EntityDocument currentEntity = null;
        EntityDocument fileHeaderEntity = null;
        boolean skipFileEntity = false;
        String currentEntityType = "";
        while ((strLine = bufferedReader.readLine()) != null) {
            ImportLineStructure lineStructure;
            if (skipFileEntity) {
                skipFileEntity = false;
                while ((strLine = bufferedReader.readLine()) != null && !strLine.startsWith("0")) {
                }
            }
            if ((lineStructure = this.getImportLineStructure(strLine, gedcomLevelStrings)).isIncompleteLine()) {
                this.appendToTaskOutput("Incomplete line found");
                continue;
            }
            System.out.println(strLine);
            boolean lastFieldContinued = false;
            if (lineStructure.isContinueLineBreak()) {
                currentEntity.appendValueToLast(currentEntityType, "\n" + lineStructure.getEscapedLineContents());
                lastFieldContinued = true;
            } else if (lineStructure.isContinueLine()) {
                currentEntity.appendValueToLast(currentEntityType, lineStructure.getEscapedLineContents());
                lastFieldContinued = true;
            }
            if (!lastFieldContinued) {
                if (lineStructure.getGedcomLevel() == 0) {
                    if (lineStructure.isEndOfFileMarker()) {
                        this.appendToTaskOutput("End of file found");
                    } else {
                        String typeString = lineStructure.getProfileForEntityType(profileId, ProfileRecord.getDefaultImportProfile().profileId);
                        currentEntity = this.getEntityDocument(createdNodes, typeString, lineStructure.getCurrentID(), importTranslator);
                        currentEntityType = lineStructure.entityType;
                        if (lineStructure.isFileHeader()) {
                            fileHeaderEntity = currentEntity;
                            currentEntity.insertValue("Type", "Imported File Header");
                            if (lineStructure.hasLineContents()) {
                                currentEntity.insertValue(lineStructure.getCurrentName(), lineStructure.getLineContents().trim());
                            }
                        } else {
                            fileHeaderEntity.entityData.addRelatedNode(currentEntity.entityData, DataTypes.RelationType.other, null, null, null, "source");
                            if (lineStructure.getEntityType() != null) {
                                currentEntity.insertValue("Type", lineStructure.getEntityType());
                            }
                            if (lineStructure.getDeleteIfNoFeildsAdded()) {
                                documentsToDeleteIfNoFieldsAdded.add(currentEntity);
                            }
                            if (lineStructure.hasLineContents()) {
                                currentEntity.insertValue(lineStructure.getCurrentName(), lineStructure.getLineContents());
                            }
                        }
                    }
                    while (lineStructure.hasCurrentField()) {
                        if (lineStructure.hasLineContents()) {
                            currentEntity.insertValue(lineStructure.getCurrentName(), lineStructure.getLineContents());
                        }
                        lineStructure.moveToNextField();
                    }
                } else {
                    while (lineStructure.hasCurrentField()) {
                        if (!lineStructure.hasLineContents()) {
                            currentEntity.appendValue(lineStructure.getCurrentName(), null, lineStructure.getGedcomLevel());
                        } else {
                            boolean notConsumed = true;
                            if (gedcomLevelStrings.size() == 3 && gedcomLevelStrings.get(2).equals("DATE") && (gedcomLevelStrings.get(1).equals("BIRT") || gedcomLevelStrings.get(1).equals("DEAT"))) {
                                String dateText = lineStructure.getLineContents().trim();
                                String qualifierString = null;
                                String yearString = null;
                                String monthString = null;
                                String dayString = null;
                                for (String prefixString : new String[]{"ABT", "BEF", "AFT"}) {
                                    if (!dateText.startsWith(prefixString)) continue;
                                    qualifierString = prefixString.toLowerCase();
                                    dateText = dateText.substring(prefixString.length()).trim();
                                }
                                try {
                                    SimpleDateFormat formatter;
                                    if (dateText.matches("[0-9]{1,4}")) {
                                        while (dateText.length() < 4) {
                                            dateText = "0" + dateText;
                                        }
                                        yearString = dateText;
                                    } else if (dateText.matches("[a-zA-Z]{3} [0-9]{4}")) {
                                        formatter = new SimpleDateFormat("MMM yyyy");
                                        Date parsedDate = formatter.parse(dateText);
                                        monthString = new SimpleDateFormat("MM").format(parsedDate);
                                        yearString = new SimpleDateFormat("yyyy").format(parsedDate);
                                    } else {
                                        formatter = new SimpleDateFormat("dd MMM yyyy");
                                        Date parsedDate = formatter.parse(dateText);
                                        dayString = new SimpleDateFormat("dd").format(parsedDate);
                                        monthString = new SimpleDateFormat("MM").format(parsedDate);
                                        yearString = new SimpleDateFormat("yyyy").format(parsedDate);
                                    }
                                    EntityDate entityDate = new EntityDate(yearString, monthString, dayString, qualifierString);
                                    if (gedcomLevelStrings.get(1).equals("BIRT")) {
                                        currentEntity.insertValue("DateOfBirth", entityDate.getDateString());
                                    } else {
                                        currentEntity.insertValue("DateOfDeath", entityDate.getDateString());
                                    }
                                    notConsumed = false;
                                }
                                catch (ParseException exception) {
                                    System.out.println(exception.getMessage());
                                    this.appendToTaskOutput("Failed to parse date: " + strLine);
                                    this.appendToTaskOutput("The date data will been imported anyway and can be corrected manually later.");
                                }
                                catch (EntityDateException exception) {
                                    System.out.println(exception.getMessage());
                                    this.appendToTaskOutput("Failed to parse date: " + strLine + " " + exception.getMessage());
                                    this.appendToTaskOutput("The date data will been imported anyway and can be corrected manually later.");
                                }
                            }
                            if (gedcomLevelStrings.size() == 2 && (gedcomLevelStrings.get(1).equals("SEX") || gedcomLevelStrings.get(1).equals("NAME"))) {
                                if (lineStructure.getGedcomLevel() == 1) {
                                    currentEntity.insertValue(lineStructure.getCurrentName(), lineStructure.getLineContents());
                                } else {
                                    currentEntity.appendValue(lineStructure.getCurrentName(), lineStructure.getLineContents(), lineStructure.getGedcomLevel());
                                }
                                notConsumed = false;
                            }
                            if (gedcomLevelStrings.size() == 2 && gedcomLevelStrings.get(1).equals("chro") && lineStructure.getGedcomLevel() == 1) {
                                currentEntity.insertValue(lineStructure.getCurrentName(), lineStructure.getLineContents());
                                notConsumed = false;
                            }
                            if (gedcomLevelStrings.get(gedcomLevelStrings.size() - 1).equals("FILE")) {
                                if (lineStructure.getLineContents().toLowerCase().startsWith("mailto:")) {
                                    currentEntity.insertValue("mailto", lineStructure.getLineContents());
                                } else {
                                    try {
                                        URI resolvedUri = "jar".equals(this.inputFileUri.getScheme()) ? URI.create("http://example.net/example/files/not/included/demo").resolve(lineStructure.getLineContents()) : this.inputFileUri.resolve(lineStructure.getLineContents());
                                        currentEntity.entityData.addArchiveLink(resolvedUri);
                                        notConsumed = false;
                                    }
                                    catch (IllegalArgumentException exception) {
                                        this.appendToTaskOutput("Unsupported File Path: " + lineStructure.getLineContents());
                                    }
                                }
                            }
                            if (lineStructure.isRelation()) {
                                if (lineStructure.getCurrentName().equals("FAMS") || lineStructure.getCurrentName().equals("FAMC") || lineStructure.getCurrentName().equals("HUSB") || lineStructure.getCurrentName().equals("WIFE") || lineStructure.getCurrentName().equals("CHIL")) {
                                    EntityData socialGroupMember;
                                    UniqueIdentifier socialGroupIdentifier;
                                    if (lineStructure.getCurrentName().equals("FAMS") || lineStructure.getCurrentName().equals("FAMC")) {
                                        socialGroupIdentifier = this.getEntityDocument(createdNodes, (String)profileId, (String)lineStructure.getLineContents(), (ImportTranslator)importTranslator).entityData.getUniqueIdentifier();
                                        socialGroupMember = currentEntity.entityData;
                                    } else {
                                        socialGroupIdentifier = currentEntity.entityData.getUniqueIdentifier();
                                        socialGroupMember = this.getEntityDocument(createdNodes, (String)profileId, (String)lineStructure.getLineContents(), (ImportTranslator)importTranslator).entityData;
                                    }
                                    if (!socialGroupRoleMap.containsKey(socialGroupIdentifier)) {
                                        socialGroupRoleMap.put(socialGroupIdentifier, new ArrayList());
                                    }
                                    ((ArrayList)socialGroupRoleMap.get(socialGroupIdentifier)).add(new SocialMemberElement(lineStructure.getCurrentName(), socialGroupMember));
                                    famGroupList.add(new FamGroupElement(lineStructure.getCurrentName(), currentEntity, this.getEntityDocument(createdNodes, profileId, lineStructure.getLineContents(), importTranslator)));
                                    notConsumed = false;
                                } else {
                                    String currentName = lineStructure.getCurrentName();
                                    String customType = null;
                                    String dcrString = null;
                                    DataTypes.RelationType targetRelation = DataTypes.RelationType.other;
                                    String[] currentNameParts = currentName.split(":");
                                    if (currentNameParts.length > 0) {
                                        try {
                                            targetRelation = DataTypes.RelationType.valueOf(currentNameParts[0]);
                                        }
                                        catch (IllegalArgumentException exception) {
                                            if (currentNameParts.length == 3) {
                                                this.appendToTaskOutput("Unsupported Relation Type: " + currentName);
                                            }
                                            targetRelation = DataTypes.RelationType.other;
                                            customType = currentNameParts[0];
                                        }
                                    }
                                    if (currentNameParts.length == 3) {
                                        customType = currentNameParts[1];
                                        dcrString = currentNameParts[2];
                                    }
                                    currentEntity.entityData.addRelatedNode(this.getEntityDocument(createdNodes, (String)profileId, (String)lineStructure.getLineContents(), (ImportTranslator)importTranslator).entityData, targetRelation, null, null, dcrString, customType);
                                    notConsumed = false;
                                }
                            }
                            if (notConsumed) {
                                currentEntity.appendValue(lineStructure.getCurrentName(), lineStructure.getEscapedLineContents(), lineStructure.getGedcomLevel());
                            }
                        }
                        lineStructure.moveToNextField();
                    }
                }
                for (ImportLineStructure.RelationEntry relationEntry : lineStructure.getRelationList()) {
                    this.getEntityDocument(createdNodes, (String)profileId, (String)relationEntry.egoIdString, (ImportTranslator)importTranslator).entityData.addRelatedNode(this.getEntityDocument(createdNodes, (String)profileId, (String)relationEntry.alterIdString, (ImportTranslator)importTranslator).entityData, relationEntry.relationType, null, null, null, relationEntry.customType);
                }
            }
            super.incrementLineProgress();
        }
        for (ArrayList currentSocialGroup : socialGroupRoleMap.values()) {
            for (SocialMemberElement outerMemberElement : currentSocialGroup) {
                for (SocialMemberElement innerMemberElement : currentSocialGroup) {
                    if (innerMemberElement.memberEntity.equals(outerMemberElement.memberEntity)) continue;
                    if (innerMemberElement.typeString.equals("FAMC") || innerMemberElement.typeString.equals("CHIL")) {
                        if (outerMemberElement.typeString.equals("FAMC") || outerMemberElement.typeString.equals("CHIL")) {
                            innerMemberElement.memberEntity.addRelatedNode(outerMemberElement.memberEntity, DataTypes.RelationType.sibling, null, null, null, null);
                            continue;
                        }
                        innerMemberElement.memberEntity.addRelatedNode(outerMemberElement.memberEntity, DataTypes.RelationType.ancestor, null, null, null, null);
                        continue;
                    }
                    if (outerMemberElement.typeString.equals("FAMC") || outerMemberElement.typeString.equals("CHIL")) {
                        innerMemberElement.memberEntity.addRelatedNode(outerMemberElement.memberEntity, DataTypes.RelationType.descendant, null, null, null, null);
                        continue;
                    }
                    innerMemberElement.memberEntity.addRelatedNode(outerMemberElement.memberEntity, DataTypes.RelationType.union, null, null, null, null);
                }
            }
        }
        int omittedFamGroupCount = 0;
        for (FamGroupElement famGroupElement : famGroupList) {
            EntityDocument famGroup = null;
            if (documentsToDeleteIfNoFieldsAdded.contains(famGroupElement.famEntity)) {
                famGroup = famGroupElement.famEntity;
            } else if (documentsToDeleteIfNoFieldsAdded.contains(famGroupElement.memberEntity)) {
                famGroup = famGroupElement.memberEntity;
            }
            if (famGroup == null || famGroup.getAddedFieldCount() > 1) {
                famGroupElement.famEntity.entityData.addRelatedNode(famGroupElement.memberEntity.entityData, DataTypes.RelationType.other, null, null, null, famGroupElement.typeString);
                continue;
            }
            fileHeaderEntity.entityData.removeRelationsWithNode(famGroup.entityData);
            famGroup.entityData.removeRelationsWithNode(fileHeaderEntity.entityData);
            this.deleteEntityDocument(famGroup);
            createdNodes.remove(famGroup.getUniqueIdentifier());
            ++omittedFamGroupCount;
        }
        this.appendToTaskOutput("Omitted " + omittedFamGroupCount + " FAM groups that contained no field data (all relations have been preserved)");
        this.saveAllDocuments();
        return createdNodes.toArray(new UniqueIdentifier[0]);
    }

    class FamGroupElement {
        final String typeString;
        final EntityDocument famEntity;
        final EntityDocument memberEntity;

        public FamGroupElement(String typeString, EntityDocument famEntity, EntityDocument memberEntity) {
            this.typeString = typeString;
            this.famEntity = famEntity;
            this.memberEntity = memberEntity;
        }
    }

    class SocialMemberElement {
        String typeString;
        EntityData memberEntity;

        public SocialMemberElement(String typeString, EntityData memberEntity) {
            this.typeString = typeString;
            this.memberEntity = memberEntity;
        }
    }
}

