/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import nl.mpi.arbil.data.ArbilDataNodeLoader;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.kinnate.data.KinTreeNode;
import nl.mpi.kinnate.data.ProjectNode;
import nl.mpi.kinnate.entityindexer.DatabaseUpdateListener;
import nl.mpi.kinnate.entityindexer.EntityCollection;
import nl.mpi.kinnate.entityindexer.EntityServiceException;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.ui.KinDiagramPanel;
import nl.mpi.kinnate.ui.KinTree;

public class ProjectTreePanel
extends JPanel
implements DatabaseUpdateListener {
    private EntityCollection entityCollection;
    private KinTree kinTree;
    private String panelName;
    private KinDiagramPanel kinDiagramPanel;
    private GraphPanel graphPanel;
    private ProjectNode rootNode;
    private MessageDialogHandler dialogHandler;
    private ArbilDataNodeLoader dataNodeLoader;
    private JProgressBar progressBar;
    private ArrayList<KinTreeNode> treeNodesArray = null;
    private int currentPage = 0;
    private int maxNodesPerPage = 100;
    private JPanel pagePanel;
    private JLabel currentPageLabel;
    private static final Object lockObject = new Object();
    private static final AtomicBoolean ATOMIC_BOOLEAN = new AtomicBoolean(false);
    private static ArrayList<KinTreeNode> staticTreeNodesArray = null;
    private static boolean updateRequired = true;

    public ProjectTreePanel(EntityCollection entityCollection, String panelName, KinDiagramPanel kinDiagramPanel, GraphPanel graphPanel, MessageDialogHandler dialogHandler, ArbilDataNodeLoader dataNodeLoader) {
        super(new BorderLayout());
        this.setName(panelName);
        this.entityCollection = entityCollection;
        this.panelName = panelName;
        this.kinDiagramPanel = kinDiagramPanel;
        this.graphPanel = graphPanel;
        this.dataNodeLoader = dataNodeLoader;
        this.dialogHandler = dialogHandler;
        this.rootNode = new ProjectNode(entityCollection, panelName);
        this.kinTree = new KinTree(kinDiagramPanel, graphPanel, this.rootNode);
        this.kinTree.setBackground(this.getBackground());
        this.add((Component)new JScrollPane((Component)((Object)this.kinTree)), "Center");
        this.progressBar = new JProgressBar();
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if ("<".equals(e.getActionCommand())) {
                    ProjectTreePanel.this.currentPage--;
                } else if (">".equals(e.getActionCommand())) {
                    ProjectTreePanel.this.currentPage++;
                }
                ProjectTreePanel.this.showPage();
            }
        };
        JButton previousButton = new JButton("<");
        JButton nextButton = new JButton(">");
        this.currentPageLabel = new JLabel("", 0);
        previousButton.setActionCommand("<");
        nextButton.setActionCommand(">");
        previousButton.addActionListener(actionListener);
        nextButton.addActionListener(actionListener);
        Dimension preferredSize = previousButton.getPreferredSize();
        Dimension buttonDimension = new Dimension(preferredSize.height, preferredSize.height);
        previousButton.setPreferredSize(buttonDimension);
        nextButton.setPreferredSize(buttonDimension);
        this.pagePanel = new JPanel(new BorderLayout());
        this.pagePanel.add((Component)previousButton, "Before");
        this.pagePanel.add((Component)this.currentPageLabel, "Center");
        this.pagePanel.add((Component)nextButton, "After");
    }

    private void showPage() {
        if (this.treeNodesArray != null) {
            int startNode;
            int endNode;
            int pageCount = this.treeNodesArray.size() / this.maxNodesPerPage;
            if (this.currentPage < 0) {
                this.currentPage = 0;
            }
            if (this.currentPage > pageCount) {
                this.currentPage = pageCount;
            }
            if ((endNode = (startNode = this.currentPage * this.maxNodesPerPage) + this.maxNodesPerPage) > this.treeNodesArray.size()) {
                endNode = this.treeNodesArray.size();
            }
            this.currentPageLabel.setText(this.currentPage + 1 + " of " + (pageCount + 1));
            this.rootNode.setChildNodes(this.treeNodesArray.subList(startNode, endNode).toArray(new ArbilNode[0]));
            this.kinTree.requestResort();
        }
        this.progressBar.setVisible(false);
        this.remove(this.progressBar);
        this.add((Component)this.pagePanel, "Last");
        this.revalidate();
    }

    public void loadProjectTree() {
        this.remove(this.pagePanel);
        this.add((Component)this.progressBar, "Last");
        this.progressBar.setVisible(true);
        this.progressBar.setIndeterminate(true);
        this.revalidate();
        this.kinTree.requestResort();
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean projectQueryRunning = ATOMIC_BOOLEAN.getAndSet(true);
                Object object = lockObject;
                synchronized (object) {
                    if (!projectQueryRunning && updateRequired) {
                        staticTreeNodesArray = new ArrayList();
                        try {
                            EntityData[] projectEntities;
                            for (EntityData entityData : projectEntities = ProjectTreePanel.this.entityCollection.getEntityByEndPoint(DataTypes.RelationType.ancestor, ProjectTreePanel.this.graphPanel.getIndexParameters())) {
                                boolean isHorizontalEndPoint = true;
                                if (!isHorizontalEndPoint) continue;
                                staticTreeNodesArray.add(new KinTreeNode(entityData.getUniqueIdentifier(), entityData, ((ProjectTreePanel)ProjectTreePanel.this).graphPanel.dataStoreSvg, ProjectTreePanel.this.graphPanel.getIndexParameters(), ProjectTreePanel.this.dialogHandler, ProjectTreePanel.this.entityCollection, ProjectTreePanel.this.dataNodeLoader));
                            }
                            Collections.sort(staticTreeNodesArray);
                            updateRequired = false;
                        }
                        catch (EntityServiceException exception) {
                            ProjectTreePanel.this.dialogHandler.addMessageDialogToQueue(exception.getMessage(), "Get Project Entities");
                        }
                    }
                    ProjectTreePanel.this.treeNodesArray = staticTreeNodesArray;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ProjectTreePanel.this.showPage();
                        }
                    });
                    ATOMIC_BOOLEAN.set(false);
                }
            }
        }.start();
    }

    public void setTransferHandler(TransferHandler newHandler) {
        this.kinTree.setTransferHandler(newHandler);
        this.kinTree.setDragEnabled(true);
    }

    public void updateOccured() {
        updateRequired = true;
        this.loadProjectTree();
    }
}

